/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.http;

import okhttp3.internal.annotations.EverythingIsNonNull;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HttpLogger {
    Slf4j(new Slf4jLogger()),
    Console(new ConsoleLogger());

    private final HttpLoggingInterceptor.Logger logger;

    private HttpLogger(HttpLoggingInterceptor.Logger logger) {
        this.logger = logger;
    }

    public HttpLoggingInterceptor.Logger getLogger() {
        return this.logger;
    }

    @EverythingIsNonNull
    public static class ConsoleLogger
    implements HttpLoggingInterceptor.Logger {
        public void log(String message) {
            System.out.print("ConsoleLogger: ");
            System.out.println(message);
        }
    }

    @EverythingIsNonNull
    public static class Slf4jLogger
    implements HttpLoggingInterceptor.Logger {
        private static final Logger log = LoggerFactory.getLogger(Slf4jLogger.class);

        public void log(String message) {
            log.info(message);
        }
    }
}

