/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.dreamlu.mica.core.utils.JsonUtil;
import okhttp3.Cookie;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public interface ResponseSpec {
    public int code();

    public String message();

    default public boolean isOk() {
        return false;
    }

    public boolean isRedirect();

    public Headers headers();

    default public ResponseSpec headers(Consumer<Headers> consumer) {
        consumer.accept(this.headers());
        return this;
    }

    public List<Cookie> cookies();

    default public ResponseSpec cookies(Consumer<List<Cookie>> consumer) {
        consumer.accept(this.cookies());
        return this;
    }

    public String asString();

    public String asString(Charset var1);

    public byte[] asBytes();

    public InputStream asStream();

    public JsonNode asJsonNode();

    default public JsonNode atJsonPath(String jsonPtrExpr) {
        return this.asJsonNode().at(jsonPtrExpr);
    }

    default public <T> T atJsonPathValue(String jsonPtrExpr, Class<T> valueType) {
        return (T)JsonUtil.convertValue((Object)this.atJsonPath(jsonPtrExpr), valueType);
    }

    default public <T> T atJsonPathValue(String jsonPtrExpr, TypeReference<T> typeReference) {
        return (T)JsonUtil.convertValue((Object)this.atJsonPath(jsonPtrExpr), typeReference);
    }

    default public <T> List<T> atJsonPathList(String jsonPtrExpr, Class<T> valueType) {
        CollectionLikeType collectionLikeType = JsonUtil.getListType(valueType);
        return (List)JsonUtil.convertValue((Object)this.atJsonPath(jsonPtrExpr), (JavaType)collectionLikeType);
    }

    @Nullable
    public <T> T asValue(Class<T> var1);

    @Nullable
    public <T> T asValue(TypeReference<T> var1);

    public <T> List<T> asList(Class<T> var1);

    public <K, V> Map<K, V> asMap(Class<?> var1, Class<?> var2);

    public <V> Map<String, V> asMap(Class<?> var1);

    public File toFile(File var1);

    public Path toFile(Path var1);

    @Nullable
    public MediaType contentType();

    public long contentLength();

    public Request rawRequest();

    @Nullable
    default public ResponseSpec rawRequest(Consumer<Request> consumer) {
        consumer.accept(this.rawRequest());
        return this;
    }

    public Response rawResponse();

    default public ResponseSpec rawResponse(Consumer<Response> consumer) {
        consumer.accept(this.rawResponse());
        return this;
    }

    @Nullable
    public ResponseBody rawBody();

    @Nullable
    default public ResponseSpec rawBody(Consumer<ResponseBody> consumer) {
        consumer.accept(this.rawBody());
        return this;
    }
}

