/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.http;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.dreamlu.mica.http.ResponseSpec;

public class RetryPolicy {
    public static final RetryPolicy INSTANCE = new RetryPolicy();
    private final int maxAttempts;
    private final long sleepMillis;
    @Nullable
    private final Predicate<ResponseSpec> respPredicate;

    public RetryPolicy() {
        this(null);
    }

    public RetryPolicy(int maxAttempts, long sleepMillis) {
        this(maxAttempts, sleepMillis, null);
    }

    public RetryPolicy(@Nullable Predicate<ResponseSpec> respPredicate) {
        this(3, 0L, respPredicate);
    }

    public RetryPolicy(int maxAttempts, long sleepMillis, @Nullable Predicate<ResponseSpec> respPredicate) {
        this.maxAttempts = maxAttempts;
        this.sleepMillis = sleepMillis;
        this.respPredicate = respPredicate;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public long getSleepMillis() {
        return this.sleepMillis;
    }

    @Nullable
    public Predicate<ResponseSpec> getRespPredicate() {
        return this.respPredicate;
    }

    public String toString() {
        return "RetryPolicy(maxAttempts=" + this.getMaxAttempts() + ", sleepMillis=" + this.getSleepMillis() + ", respPredicate=" + this.getRespPredicate() + ")";
    }
}

