/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import net.dreamlu.mica.core.utils.NumberUtil;
import net.dreamlu.mica.core.utils.StringUtil;

public class RuntimeUtil {
    private static volatile int pId = -1;
    private static final int CPU_NUM = Runtime.getRuntime().availableProcessors();

    public static int getPId() {
        if (pId > 0) {
            return pId;
        }
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index > 0) {
            pId = NumberUtil.toInt(jvmName.substring(0, index), -1);
            return pId;
        }
        return pId;
    }

    public static Instant getStartTime() {
        return Instant.ofEpochMilli(ManagementFactory.getRuntimeMXBean().getStartTime());
    }

    public static Duration getUpTime() {
        return Duration.ofMillis(ManagementFactory.getRuntimeMXBean().getUptime());
    }

    public static String getJvmArguments() {
        List<String> vmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        return StringUtil.join(vmArguments, " ");
    }

    public static int getCpuNum() {
        return CPU_NUM;
    }
}

