/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.utils;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.dongliu.requests.exception.RequestsException;
import net.dongliu.requests.exception.TrustManagerLoadFailedException;

public class SSLSocketFactories {
    private static final SSLSocketFactory sslSocketFactoryLazy = SSLSocketFactories._getTrustAllSSLSocketFactory();
    private static final ConcurrentMap<KeyStore, SSLSocketFactory> map = new ConcurrentHashMap<KeyStore, SSLSocketFactory>();

    public static SSLSocketFactory _getTrustAllSSLSocketFactory() {
        SSLContext sslContext;
        TrustAllTrustManager trustManager = new TrustAllTrustManager();
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RequestsException(e);
        }
        return sslContext.getSocketFactory();
    }

    public static SSLSocketFactory getTrustAllSSLSocketFactory() {
        return sslSocketFactoryLazy;
    }

    private static SSLSocketFactory _getCustomSSLSocketFactory(KeyStore keyStore) {
        SSLContext sslContext;
        CustomCertTrustManager trustManager = new CustomCertTrustManager(keyStore);
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RequestsException(e);
        }
        return sslContext.getSocketFactory();
    }

    public static SSLSocketFactory getCustomTrustSSLSocketFactory(KeyStore keyStore) {
        if (!map.containsKey(keyStore)) {
            map.put(keyStore, SSLSocketFactories._getCustomSSLSocketFactory(keyStore));
        }
        return (SSLSocketFactory)map.get(keyStore);
    }

    static class CustomCertTrustManager
    implements X509TrustManager {
        private final KeyStore keyStore;
        private final X509TrustManager defaultTrustManager;
        private final X509TrustManager trustManager;

        public CustomCertTrustManager(KeyStore keyStore) {
            TrustManagerFactory trustManagerFactory;
            TrustManagerFactory defaultTrustManagerFactory;
            this.keyStore = keyStore;
            try {
                defaultTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                defaultTrustManagerFactory.init((KeyStore)null);
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                throw new TrustManagerLoadFailedException(e);
            }
            X509TrustManager defaultTrustManager = null;
            for (TrustManager tm : defaultTrustManagerFactory.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                defaultTrustManager = (X509TrustManager)tm;
                break;
            }
            if (defaultTrustManager == null) {
                throw new TrustManagerLoadFailedException("Default X509TrustManager not found");
            }
            this.defaultTrustManager = defaultTrustManager;
            try {
                trustManagerFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
                trustManagerFactory.init(keyStore);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException e) {
                throw new TrustManagerLoadFailedException(e);
            }
            X509TrustManager trustManager = null;
            for (TrustManager tm : trustManagerFactory.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                trustManager = (X509TrustManager)tm;
                break;
            }
            if (trustManager == null) {
                throw new TrustManagerLoadFailedException("X509TrustManager for user keystore not found");
            }
            this.trustManager = trustManager;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                this.trustManager.checkClientTrusted(chain, authType);
            }
            catch (CertificateException e) {
                this.defaultTrustManager.checkClientTrusted(chain, authType);
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                this.trustManager.checkServerTrusted(chain, authType);
            }
            catch (CertificateException e) {
                this.defaultTrustManager.checkServerTrusted(chain, authType);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            X509Certificate[] defaultAcceptedIssuers = this.defaultTrustManager.getAcceptedIssuers();
            X509Certificate[] acceptedIssuers = this.trustManager.getAcceptedIssuers();
            X509Certificate[] result = new X509Certificate[defaultAcceptedIssuers.length + acceptedIssuers.length];
            System.arraycopy(defaultAcceptedIssuers, 0, result, 0, defaultAcceptedIssuers.length);
            System.arraycopy(acceptedIssuers, 0, result, defaultAcceptedIssuers.length, acceptedIssuers.length);
            return result;
        }
    }

    static class TrustAllTrustManager
    implements X509TrustManager {
        TrustAllTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

