/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.dongliu.commons.collection.Lists;
import org.checkerframework.checker.nullness.qual.Nullable;

final class CookieDateUtil {
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String PATTERN_RFC1036 = "EEEE, dd-MMM-yy HH:mm:ss zzz";
    public static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    private static final Collection<String> DEFAULT_PATTERNS = Lists.of((Object)"EEE MMM d HH:mm:ss yyyy", (Object)"EEEE, dd-MMM-yy HH:mm:ss zzz", (Object)"EEE, dd MMM yyyy HH:mm:ss zzz");
    private static final Date DEFAULT_TWO_DIGIT_YEAR_START;
    private static final TimeZone GMT;

    private CookieDateUtil() {
    }

    public static @Nullable Date parseDate(String dateValue) {
        return CookieDateUtil.parseDate(dateValue, DEFAULT_PATTERNS);
    }

    public static @Nullable Date parseDate(String dateValue, Collection<String> dateFormats) {
        return CookieDateUtil.parseDate(dateValue, dateFormats, DEFAULT_TWO_DIGIT_YEAR_START);
    }

    public static @Nullable Date parseDate(String dateValue, Collection<String> dateFormats, Date startDate) {
        if (dateValue.length() > 1 && dateValue.startsWith("'") && dateValue.endsWith("'")) {
            dateValue = dateValue.substring(1, dateValue.length() - 1);
        }
        SimpleDateFormat dateParser = null;
        for (String format : dateFormats) {
            if (dateParser == null) {
                dateParser = new SimpleDateFormat(format, Locale.US);
                dateParser.setTimeZone(TimeZone.getTimeZone("GMT"));
                dateParser.set2DigitYearStart(startDate);
            } else {
                dateParser.applyPattern(format);
            }
            try {
                return dateParser.parse(dateValue);
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    public static String formatDate(Date date) {
        return CookieDateUtil.formatDate(date, PATTERN_RFC1123);
    }

    public static String formatDate(Date date, String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, Locale.US);
        formatter.setTimeZone(GMT);
        return formatter.format(date);
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2000, 0, 1, 0, 0);
        DEFAULT_TWO_DIGIT_YEAR_START = calendar.getTime();
        GMT = TimeZone.getTimeZone("GMT");
    }
}

