/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.json;

import java.util.Objects;
import net.dongliu.requests.json.FastJsonProcessor;
import net.dongliu.requests.json.GsonProcessor;
import net.dongliu.requests.json.JacksonProcessor;
import net.dongliu.requests.json.JsonProcessor;
import net.dongliu.requests.json.JsonProcessorNotFoundException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JsonLookup {
    private static JsonLookup instance = new JsonLookup();
    private volatile @Nullable JsonProcessor registeredJsonProcessor;
    private @Nullable JsonProcessor lookedJsonProcessor;
    private boolean init;

    private JsonLookup() {
    }

    public static JsonLookup getInstance() {
        return instance;
    }

    public void register(JsonProcessor jsonProcessor) {
        this.registeredJsonProcessor = Objects.requireNonNull(jsonProcessor);
    }

    boolean hasGson() {
        try {
            Class.forName("com.google.gson.Gson");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    JsonProcessor gsonProvider() {
        return new GsonProcessor();
    }

    boolean hasJackson() {
        try {
            Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    boolean hasFastJson() {
        try {
            Class.forName("com.alibaba.fastjson.JSON");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    JsonProcessor jacksonProvider() {
        return new JacksonProcessor();
    }

    JsonProcessor fastJsonProvider() {
        return new FastJsonProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull JsonProcessor lookup() {
        JsonProcessor registeredJsonProcessor = this.registeredJsonProcessor;
        if (registeredJsonProcessor != null) {
            return registeredJsonProcessor;
        }
        if (!this.init) {
            JsonLookup jsonLookup = this;
            synchronized (jsonLookup) {
                if (!this.init) {
                    this.lookedJsonProcessor = this.lookupInClasspath();
                    this.init = true;
                }
            }
        }
        if (this.lookedJsonProcessor != null) {
            return this.lookedJsonProcessor;
        }
        throw new JsonProcessorNotFoundException("Json Provider not found");
    }

    private @Nullable JsonProcessor lookupInClasspath() {
        if (this.hasJackson()) {
            return this.jacksonProvider();
        }
        if (this.hasGson()) {
            return this.gsonProvider();
        }
        if (this.hasFastJson()) {
            return this.fastJsonProvider();
        }
        return null;
    }
}

