/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import net.dongliu.requests.json.JsonProcessor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JacksonProcessor
implements JsonProcessor {
    private final ObjectMapper objectMapper;

    public JacksonProcessor() {
        this(JacksonProcessor.createDefault());
    }

    private static ObjectMapper createDefault() {
        return new ObjectMapper().findAndRegisterModules();
    }

    public JacksonProcessor(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public void marshal(Writer writer, @Nullable Object value) throws IOException {
        this.objectMapper.writeValue(writer, value);
    }

    @Override
    public <T> T unmarshal(InputStream inputStream, Charset charset, Type type) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, charset);){
            JavaType javaType = this.objectMapper.getTypeFactory().constructType(type);
            Object object = this.objectMapper.readValue((Reader)reader, javaType);
            return (T)object;
        }
    }
}

