/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import net.dongliu.commons.io.Closeables;
import net.dongliu.requests.exception.TrustManagerLoadFailedException;

public class KeyStores {
    public static KeyStore load(String path, char[] password) {
        try {
            return KeyStores.load(new FileInputStream(path), password);
        }
        catch (FileNotFoundException e) {
            throw new TrustManagerLoadFailedException(e);
        }
    }

    public static KeyStore load(InputStream in, char[] password) {
        try {
            KeyStore myTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            myTrustStore.load(in, password);
            KeyStore keyStore = myTrustStore;
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new TrustManagerLoadFailedException(e);
        }
        finally {
            Closeables.closeQuietly((AutoCloseable)in);
        }
    }
}

