/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.sequence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.dongliu.commons.sequence.Sequence;

class ChunkedSequence<T>
implements Sequence<List<T>> {
    private final Sequence<T> sequence;
    private final int size;

    public ChunkedSequence(Sequence<T> sequence, int size) {
        this.sequence = sequence;
        this.size = size;
    }

    @Override
    public boolean hasNext() {
        return this.sequence.hasNext();
    }

    @Override
    public List<T> next() {
        ArrayList<T> list = new ArrayList<T>(this.size);
        for (int i = 0; i < this.size && this.sequence.hasNext(); ++i) {
            list.add(this.sequence.next());
        }
        return Collections.unmodifiableList(list);
    }
}

