/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.dongliu.commons.Lazy;
import net.dongliu.commons.collection.Sets;

public class Classes {
    private static final Lazy<Set<Class<?>>> wrapperClasses = Lazy.of(() -> Sets.of(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, Character.class));

    public static <T> Class<T> cast(Class<? super T> cls) {
        return cls;
    }

    public static List<Field> getAllMemberFields(Class<?> cls) {
        Field[] fields;
        Objects.requireNonNull(cls);
        HashSet<String> fieldNames = new HashSet<String>();
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field field : fields = cls.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || field.isSynthetic()) continue;
            fieldNames.add(field.getName());
            list.add(field);
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null && !superclass.equals(Object.class)) {
            List<Field> superFields = Classes.getAllMemberFields(superclass);
            for (Field field : superFields) {
                String name = field.getName();
                if (fieldNames.contains(name)) continue;
                fieldNames.add(name);
                list.add(field);
            }
        }
        return Collections.unmodifiableList(list);
    }

    public static boolean exists(String className) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return Classes.exists(className, classLoader);
    }

    public static boolean exists(String className, ClassLoader classLoader) {
        Objects.requireNonNull(className);
        Objects.requireNonNull(classLoader);
        try {
            Class.forName(className, false, classLoader);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean hasMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        Objects.requireNonNull(cls);
        Objects.requireNonNull(methodName);
        try {
            cls.getMethod(methodName, parameterTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static boolean isPrimitiveWrapper(Class<?> cls) {
        return wrapperClasses.get().contains(Objects.requireNonNull(cls));
    }

    public static boolean isPrivate(Class<?> cls) {
        return Modifier.isPrivate(cls.getModifiers());
    }

    public static boolean isPublic(Class<?> cls) {
        return Modifier.isPublic(cls.getModifiers());
    }

    public static boolean isProtected(Class<?> cls) {
        return Modifier.isProtected(cls.getModifiers());
    }

    public static boolean isAbstract(Class<?> cls) {
        return Modifier.isAbstract(cls.getModifiers());
    }

    public static boolean isInterface(Class<?> cls) {
        return Modifier.isInterface(cls.getModifiers());
    }

    public static boolean isFinal(Class<?> cls) {
        return Modifier.isFinal(cls.getModifiers());
    }
}

