/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.dongliu.commons.Predications;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buffer;
    private int mark = -1;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = Objects.requireNonNull(buffer);
    }

    @Override
    public synchronized int read(byte[] b) {
        Objects.requireNonNull(b);
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) {
        Objects.requireNonNull(b);
        Predications.checkArrayRange(b, off, len);
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        int toRead = Math.min(this.buffer.remaining(), len);
        this.buffer.get(b, 0, toRead);
        return toRead;
    }

    @Override
    public synchronized long skip(long n) {
        if (n <= 0L) {
            return 0L;
        }
        int toSkip = (int)Math.min((long)this.buffer.remaining(), n);
        ((Buffer)this.buffer).position(this.buffer.position() + toSkip);
        return toSkip;
    }

    @Override
    public synchronized int available() {
        return this.buffer.remaining();
    }

    @Override
    public void close() {
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.buffer.position();
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark == -1) {
            throw new IOException("stream not marked");
        }
        ((Buffer)this.buffer).position(this.mark);
        this.mark = -1;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized int read() {
        if (this.buffer.hasRemaining()) {
            return Byte.toUnsignedInt(this.buffer.get());
        }
        return -1;
    }
}

