/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.function;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.dongliu.commons.exception.UndeclaredLambdaException;

public class UncheckedFunctions {
    UncheckedFunctions() {
    }

    public static void run(ERunnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            throw UncheckedFunctions.wrapException(e);
        }
    }

    public static <T> T call(ESupplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            throw UncheckedFunctions.wrapException(e);
        }
    }

    public static Runnable runnable(ERunnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                throw UncheckedFunctions.wrapException(e);
            }
        };
    }

    public static <T> Supplier<T> supplier(ESupplier<T> supplier) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception e) {
                throw UncheckedFunctions.wrapException(e);
            }
        };
    }

    public static <T> Consumer<T> consumer(EConsumer<T> consumer) {
        return v -> {
            try {
                consumer.accept(v);
            }
            catch (Exception e) {
                throw UncheckedFunctions.wrapException(e);
            }
        };
    }

    public static <T> Predicate<T> predicate(EPredicate<T> predicate) {
        return v -> {
            try {
                return predicate.test(v);
            }
            catch (Exception e) {
                throw UncheckedFunctions.wrapException(e);
            }
        };
    }

    public static <T, R> Function<T, R> function(EFunction<T, R> function) {
        return v -> {
            try {
                return function.apply(v);
            }
            catch (Exception e) {
                throw UncheckedFunctions.wrapException(e);
            }
        };
    }

    public static <T, U> BiConsumer<T, U> biConsumer(EBiConsumer<T, U> consumer) {
        return (v1, v2) -> {
            try {
                consumer.accept(v1, v2);
            }
            catch (Exception e) {
                throw UncheckedFunctions.wrapException(e);
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> biFunction(EBiFunction<T, U, R> function) {
        return (v1, v2) -> {
            try {
                return function.apply(v1, v2);
            }
            catch (Exception e) {
                throw UncheckedFunctions.wrapException(e);
            }
        };
    }

    private static RuntimeException wrapException(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new UndeclaredLambdaException(e);
    }

    @FunctionalInterface
    public static interface EBiFunction<T, U, R> {
        public R apply(T var1, U var2) throws Exception;
    }

    @FunctionalInterface
    public static interface EBiConsumer<T, U> {
        public void accept(T var1, U var2) throws Exception;
    }

    @FunctionalInterface
    public static interface EFunction<T, R> {
        public R apply(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface EPredicate<T> {
        public boolean test(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface EConsumer<T> {
        public void accept(T var1) throws Exception;
    }

    public static interface ESupplier<T> {
        public T get() throws Exception;
    }

    @FunctionalInterface
    public static interface ERunnable {
        public void run() throws Exception;
    }
}

