/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.concurrent;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadFactoryBuilder {
    private boolean daemon = false;
    private int priority = 5;
    private String name;
    private ThreadNameBuilder threadNameBuilder = (poolName, threadSeq) -> poolName + "-worker-" + threadSeq;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;
    private ClassLoader classLoader = null;

    ThreadFactoryBuilder(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public ThreadFactoryBuilder daemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public ThreadFactoryBuilder priority(int priority) {
        this.priority = priority;
        return this;
    }

    public ThreadFactoryBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ThreadFactoryBuilder uncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = Objects.requireNonNull(uncaughtExceptionHandler);
        return this;
    }

    public ThreadFactoryBuilder classLoader(ClassLoader classLoader) {
        this.classLoader = Objects.requireNonNull(classLoader);
        return this;
    }

    public ThreadFactoryBuilder threadNameBuilder(ThreadNameBuilder threadNameBuilder) {
        this.threadNameBuilder = threadNameBuilder;
        return this;
    }

    public ThreadFactory build() {
        return new DefaultThreadFactory(this.name, this.threadNameBuilder, this.daemon, this.priority, this.uncaughtExceptionHandler, this.classLoader);
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private final AtomicLong threadSeq = new AtomicLong();
        private final String name;
        private final boolean daemon;
        private final int priority;
        private final ThreadNameBuilder threadNameBuilder;
        private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
        private final ClassLoader contextClassLoader;

        protected DefaultThreadFactory(String name, ThreadNameBuilder threadNameBuilder, boolean daemon, int priority, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, ClassLoader contextClassLoader) {
            this.name = Objects.requireNonNull(name);
            this.threadNameBuilder = Objects.requireNonNull(threadNameBuilder);
            this.daemon = daemon;
            this.priority = priority;
            this.uncaughtExceptionHandler = uncaughtExceptionHandler;
            this.contextClassLoader = contextClassLoader;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.threadNameBuilder.getThreadName(this.name, this.threadSeq.getAndIncrement()));
            if (t.isDaemon() != this.daemon) {
                t.setDaemon(this.daemon);
            }
            if (t.getPriority() != this.priority) {
                t.setPriority(this.priority);
            }
            if (this.uncaughtExceptionHandler != null) {
                t.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
            }
            if (this.contextClassLoader != null) {
                t.setContextClassLoader(this.contextClassLoader);
            }
            return t;
        }
    }

    @FunctionalInterface
    static interface ThreadNameBuilder {
        public String getThreadName(String var1, long var2);
    }
}

