/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.concurrent;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.dongliu.commons.Lazy;
import net.dongliu.commons.collection.Lists;
import net.dongliu.commons.collection.Pair;
import net.dongliu.commons.collection.Triple;
import net.dongliu.commons.concurrent.ThreadFactories;

public class Futures {
    private static final Lazy<ScheduledExecutorService> futureScheduleExecutor = Lazy.of(() -> new ScheduledThreadPoolExecutor(1, ThreadFactories.newDaemonThreadFactory("delay-executor")));

    public static <T> T join(Future<T> future) {
        if (future instanceof CompletableFuture) {
            return ((CompletableFuture)future).join();
        }
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CancellationException();
        }
        catch (ExecutionException e) {
            throw new CompletionException(e.getCause());
        }
    }

    public static <T> CompletableFuture<T> just(T result) {
        return CompletableFuture.completedFuture(result);
    }

    public static <T> CompletableFuture<T> error(Throwable throwable) {
        CompletableFuture completableFuture = new CompletableFuture();
        completableFuture.completeExceptionally(throwable);
        return completableFuture;
    }

    public static <T> CompletableFuture<T> delay(CompletableFuture<T> future, Duration duration) {
        Objects.requireNonNull(future);
        Objects.requireNonNull(duration);
        return future.thenCompose(v -> Futures.delay(v, duration));
    }

    public static <T> CompletableFuture<T> delay(T value, Duration duration) {
        Objects.requireNonNull(duration);
        CompletableFuture f = new CompletableFuture();
        futureScheduleExecutor.get().schedule(() -> f.complete(value), duration.toMillis(), TimeUnit.MILLISECONDS);
        return f;
    }

    public static <T> CompletableFuture<T> timeout(CompletableFuture<T> future, Duration duration) {
        Objects.requireNonNull(future);
        Objects.requireNonNull(duration);
        CompletableFuture f = new CompletableFuture();
        ScheduledFuture<?> sf = futureScheduleExecutor.get().schedule(() -> {
            if (!future.isDone()) {
                future.cancel(true);
                f.completeExceptionally(new TimeoutException());
            }
        }, duration.toMillis(), TimeUnit.MILLISECONDS);
        ((CompletableFuture)future.thenAccept(v -> {
            sf.cancel(true);
            f.complete(v);
        })).exceptionally(e -> {
            sf.cancel(true);
            f.completeExceptionally((Throwable)e);
            return null;
        });
        return f;
    }

    @SafeVarargs
    public static <T> CompletableFuture<List<T>> allOf(CompletableFuture<T> ... futures) {
        Objects.requireNonNull(futures);
        if (futures.length == 0) {
            throw new IllegalArgumentException("no future");
        }
        return CompletableFuture.allOf(futures).thenApply(none -> Lists.convert(Arrays.asList(futures), CompletableFuture::join));
    }

    @SafeVarargs
    public static <T> CompletableFuture<T> anyOf(CompletableFuture<T> ... futures) {
        Objects.requireNonNull(futures);
        if (futures.length == 0) {
            throw new IllegalArgumentException("no future");
        }
        return CompletableFuture.anyOf(futures).thenCompose(none -> Arrays.stream(futures).filter(CompletableFuture::isDone).findAny().orElseThrow(() -> new RuntimeException("should not happen")));
    }

    public static <S, T> CompletableFuture<Pair<S, T>> combine(CompletableFuture<S> future1, CompletableFuture<T> future2) {
        Objects.requireNonNull(future1);
        Objects.requireNonNull(future2);
        return future1.thenCombine(future2, Pair::of);
    }

    public static <A, B, C> CompletableFuture<Triple<A, B, C>> combine(CompletableFuture<A> future1, CompletableFuture<B> future2, CompletableFuture<C> future3) {
        Objects.requireNonNull(future1);
        Objects.requireNonNull(future2);
        Objects.requireNonNull(future3);
        return CompletableFuture.allOf(future1, future2, future3).thenApply(ignore -> Triple.of(future1.join(), future2.join(), future3.join()));
    }
}

