/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.RandomAccess;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.dongliu.commons.collection.Collections2;
import net.dongliu.commons.collection.Iterables;
import net.dongliu.commons.collection.PartitionResult;
import net.dongliu.commons.exception.TooManyElementsException;
import net.dongliu.commons.function.IndexedConsumer;
import net.dongliu.commons.function.LastAwareConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Lists {
    private static final int INIT_SIZE = 16;

    public static <T> List<T> nullToEmpty(@Nullable List<T> list) {
        if (list == null) {
            return Lists.of();
        }
        return list;
    }

    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    public static <T> ArrayList<T> newArrayList(T v) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(v);
        return list;
    }

    public static <T> ArrayList<T> newArrayList(T v1, T v2) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(v1);
        list.add(v2);
        return list;
    }

    public static <T> ArrayList<T> newArrayList(T v1, T v2, T v3) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(v1);
        list.add(v2);
        list.add(v3);
        return list;
    }

    public static <T> ArrayList<T> newArrayList(T v1, T v2, T v3, T v4) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(v1);
        list.add(v2);
        list.add(v3);
        list.add(v4);
        return list;
    }

    public static <T> ArrayList<T> newArrayList(T v1, T v2, T v3, T v4, T v5) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(v1);
        list.add(v2);
        list.add(v3);
        list.add(v4);
        list.add(v5);
        return list;
    }

    @SafeVarargs
    public static <T> ArrayList<T> newArrayList(T ... values) {
        return Lists.newList(ArrayList::new, values);
    }

    @SafeVarargs
    public static <T, R extends List<T>> R newList(Supplier<R> supplier, T ... values) {
        List list = (List)supplier.get();
        Collections.addAll(list, values);
        return (R)list;
    }

    public static <T> List<T> of() {
        return Collections.emptyList();
    }

    public static <T> List<T> of(T v) {
        return Collections.singletonList(v);
    }

    public static <T> List<T> of(T v1, T v2) {
        return Collections.unmodifiableList(Lists.newArrayList(v1, v2));
    }

    public static <T> List<T> of(T v1, T v2, T v3) {
        return Collections.unmodifiableList(Lists.newArrayList(v1, v2, v3));
    }

    public static <T> List<T> of(T v1, T v2, T v3, T v4) {
        return Collections.unmodifiableList(Lists.newArrayList(v1, v2, v3, v4));
    }

    public static <T> List<T> of(T v1, T v2, T v3, T v4, T v5) {
        return Collections.unmodifiableList(Lists.newArrayList(v1, v2, v3, v4, v5));
    }

    public static <T> List<T> of(T v1, T v2, T v3, T v4, T v5, T v6) {
        return Collections.unmodifiableList(Lists.newArrayList(v1, v2, v3, v4, v5, v6));
    }

    @SafeVarargs
    public static <T> List<T> of(T ... values) {
        return Collections.unmodifiableList(Arrays.asList(values));
    }

    public static <T> List<T> copy(List<T> list) {
        return Lists.copyOf(list);
    }

    public static <T> List<T> copyOf(List<T> list) {
        if (list.isEmpty()) {
            return Lists.of();
        }
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static <S, T> List<T> convert(List<S> list, Function<? super S, ? extends T> mapper) {
        Objects.requireNonNull(list);
        return Collections2.convertToList(list, mapper);
    }

    @Deprecated
    public static <S, T> List<T> convertTo(List<S> list, Function<? super S, ? extends T> mapper) {
        Objects.requireNonNull(list);
        return Collections2.convertToList(list, mapper);
    }

    public static <T> List<T> filter(List<T> list, Predicate<? super T> predicate) {
        Objects.requireNonNull(list);
        if (list.isEmpty()) {
            return Lists.of();
        }
        ArrayList<T> newList = new ArrayList<T>(Math.min(16, list.size()));
        for (T e : list) {
            if (!predicate.test(e)) continue;
            newList.add(e);
        }
        return Collections.unmodifiableList(newList);
    }

    public static <T> List<T> reverse(List<T> list) {
        Objects.requireNonNull(list);
        ArrayList<T> newList = new ArrayList<T>(list);
        Collections.reverse(newList);
        return Collections.unmodifiableList(newList);
    }

    public static <T, R extends Comparable<R>> List<T> sort(List<? extends T> list, Function<? super T, R> comparator) {
        Objects.requireNonNull(list);
        ArrayList<T> newList = new ArrayList<T>(list);
        newList.sort(Comparator.comparing(comparator));
        return Collections.unmodifiableList(newList);
    }

    public static <T extends Comparable<T>> List<T> sort(List<T> list) {
        return Lists.sort(list, s -> s);
    }

    public static <T> List<T> concat(List<T> list1, List<T> list2) {
        Objects.requireNonNull(list1);
        Objects.requireNonNull(list2);
        int totalSize = Math.addExact(list1.size(), list2.size());
        ArrayList<T> list = new ArrayList<T>(totalSize);
        list.addAll(list1);
        list.addAll(list2);
        return Collections.unmodifiableList(list);
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> List<T> concat(List<? extends T> list1, List<? extends T> list2, List<? extends T> ... otherLists) {
        void var7_10;
        Objects.requireNonNull(list1);
        Objects.requireNonNull(list2);
        Objects.requireNonNull(otherLists);
        int totalSize = Math.addExact(list1.size(), list2.size());
        for (List<T> list : otherLists) {
            Objects.requireNonNull(list);
            totalSize = Math.addExact(totalSize, list.size());
        }
        ArrayList<Object> list = new ArrayList<Object>(totalSize);
        list.addAll(list1);
        list.addAll(list2);
        List<? extends T>[] listArray = otherLists;
        int n = listArray.length;
        boolean bl = false;
        while (var7_10 < n) {
            List<? extends T> otherList = listArray[var7_10];
            list.addAll(otherList);
            ++var7_10;
        }
        return Collections.unmodifiableList(list);
    }

    public static <T> List<List<T>> split(List<T> list, int subSize) {
        Objects.requireNonNull(list);
        if (subSize <= 0) {
            throw new IllegalArgumentException("SubList size must large than 0, but got: " + subSize);
        }
        int size = list.size();
        int count = (size - 1) / subSize + 1;
        ArrayList<List<T>> result = new ArrayList<List<T>>(count);
        for (int i = 0; i < count; ++i) {
            result.add(list.subList(i * subSize, Math.min(size, (i + 1) * subSize)));
        }
        return Collections.unmodifiableList(result);
    }

    public static <T> PartitionResult<List<T>> partition(List<T> list, Predicate<? super T> predicate) {
        Objects.requireNonNull(list);
        return Collections2.partitionToList(list, predicate);
    }

    public static <T> T getOneExactly(List<T> list) throws NoSuchElementException, TooManyElementsException {
        Objects.requireNonNull(list);
        int size = list.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        if (size > 1) {
            throw new TooManyElementsException("iterable has more than one elements");
        }
        return list.get(0);
    }

    public static <T> Optional<T> first(List<T> list) {
        Objects.requireNonNull(list);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list.get(0));
    }

    public static <T> @Nullable T firstOrNull(List<T> list) {
        Objects.requireNonNull(list);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public static <T> Optional<T> last(List<T> list) {
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list.listIterator(list.size()).previous());
    }

    public static <T> Optional<T> find(List<T> list, Predicate<? super T> predicate) {
        return Iterables.find(list, predicate);
    }

    public static <T> @Nullable T findOrNull(List<T> list, Predicate<? super T> predicate) {
        return Iterables.findOrNull(list, predicate);
    }

    public static <T> Optional<T> reverseFind(List<T> list, Predicate<? super T> predicate) {
        if (list.isEmpty()) {
            return Optional.empty();
        }
        ListIterator<T> iterator = list.listIterator(list.size());
        while (iterator.hasPrevious()) {
            T value = iterator.previous();
            if (!predicate.test(value)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    @Deprecated
    public static <T> T[] toArray(List<? extends T> list, IntFunction<T[]> maker) {
        return Collections2.toArray(list, maker);
    }

    public static <T> void forEachLastAware(List<T> list, LastAwareConsumer<? super T> consumer) {
        Objects.requireNonNull(list);
        Objects.requireNonNull(consumer);
        Iterables.forEachLastAware(list, consumer);
    }

    public static <T> void forEachIndexed(List<T> list, IndexedConsumer<? super T> consumer) {
        Objects.requireNonNull(list);
        Objects.requireNonNull(consumer);
        Iterables.forEachIndexed(list, consumer);
    }

    public static <T> List<T> randomAccessed(Collection<T> c) {
        Objects.requireNonNull(c);
        if (c instanceof List && c instanceof RandomAccess) {
            return (List)c;
        }
        return new ArrayList<T>(c);
    }
}

