/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Locale;
import net.dongliu.apk.parser.ApkFile;

public class Main {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws IOException, CertificateException {
        String action = args[0];
        String apkPath = args[1];
        try (ApkFile apkFile = new ApkFile(apkPath);){
            apkFile.setPreferredLocale(Locale.getDefault());
            switch (action) {
                case "meta": {
                    System.out.println(apkFile.getApkMeta());
                    return;
                }
                case "manifest": {
                    System.out.println(apkFile.getManifestXml());
                    return;
                }
                case "signer": {
                    System.out.println(apkFile.getApkSingers());
                    return;
                }
            }
            return;
        }
    }
}

