/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.dongliu.apk.parser.AbstractApkFile;
import net.dongliu.apk.parser.bean.ApkSignStatus;
import net.dongliu.apk.parser.utils.Inputs;

public class ApkFile
extends AbstractApkFile
implements Closeable {
    private final ZipFile zf;
    private File apkFile;

    public ApkFile(File apkFile) throws IOException {
        this.apkFile = apkFile;
        this.zf = new ZipFile(apkFile);
    }

    public ApkFile(String filePath) throws IOException {
        this(new File(filePath));
    }

    @Override
    protected List<AbstractApkFile.CertificateFile> getAllCertificateData() throws IOException {
        Enumeration<? extends ZipEntry> enu = this.zf.entries();
        ArrayList<AbstractApkFile.CertificateFile> list = new ArrayList<AbstractApkFile.CertificateFile>();
        while (enu.hasMoreElements()) {
            String name;
            ZipEntry ne = enu.nextElement();
            if (ne.isDirectory() || !(name = ne.getName().toUpperCase()).endsWith(".RSA") && !name.endsWith(".DSA")) continue;
            list.add(new AbstractApkFile.CertificateFile(name, Inputs.readAll(this.zf.getInputStream(ne))));
        }
        return list;
    }

    @Override
    public byte[] getFileData(String path) throws IOException {
        ZipEntry entry = this.zf.getEntry(path);
        if (entry == null) {
            return null;
        }
        InputStream inputStream = this.zf.getInputStream(entry);
        return Inputs.readAll(inputStream);
    }

    @Override
    protected ByteBuffer fileData() throws IOException {
        FileChannel channel = new FileInputStream(this.apkFile).getChannel();
        return channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    public ApkSignStatus verifyApk() throws IOException {
        ZipEntry entry = this.zf.getEntry("META-INF/MANIFEST.MF");
        if (entry == null) {
            return ApkSignStatus.notSigned;
        }
        try (JarFile jarFile = new JarFile(this.apkFile);){
            Enumeration<JarEntry> entries = jarFile.entries();
            byte[] buffer = new byte[8192];
            block13: while (entries.hasMoreElements()) {
                JarEntry e = entries.nextElement();
                if (e.isDirectory()) continue;
                try {
                    InputStream in = jarFile.getInputStream(e);
                    try {
                        while (true) {
                            int count;
                            if ((count = in.read(buffer, 0, buffer.length)) == -1) continue block13;
                        }
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (SecurityException se) {
                    ApkSignStatus apkSignStatus = ApkSignStatus.incorrect;
                    jarFile.close();
                    return apkSignStatus;
                }
            }
            return ApkSignStatus.signed;
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.zf.close();
    }
}

