/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.dongliu.apk.parser.struct.xml.XmlNamespaceEndTag;
import net.dongliu.apk.parser.struct.xml.XmlNamespaceStartTag;

class XmlNamespaces {
    private List<XmlNamespace> namespaces = new ArrayList<XmlNamespace>();
    private List<XmlNamespace> newNamespaces = new ArrayList<XmlNamespace>();

    public void addNamespace(XmlNamespaceStartTag tag) {
        XmlNamespace namespace = new XmlNamespace(tag.getPrefix(), tag.getUri());
        this.namespaces.add(namespace);
        this.newNamespaces.add(namespace);
    }

    public void removeNamespace(XmlNamespaceEndTag tag) {
        XmlNamespace namespace = new XmlNamespace(tag.getPrefix(), tag.getUri());
        this.namespaces.remove(namespace);
        this.newNamespaces.remove(namespace);
    }

    public String getPrefixViaUri(String uri) {
        if (uri == null) {
            return null;
        }
        for (XmlNamespace namespace : this.namespaces) {
            if (!namespace.uri.equals(uri)) continue;
            return namespace.prefix;
        }
        return null;
    }

    public List<XmlNamespace> consumeNameSpaces() {
        if (!this.newNamespaces.isEmpty()) {
            ArrayList<XmlNamespace> xmlNamespaces = new ArrayList<XmlNamespace>();
            xmlNamespaces.addAll(this.newNamespaces);
            this.newNamespaces.clear();
            return xmlNamespaces;
        }
        return Collections.emptyList();
    }

    public static class XmlNamespace {
        private String prefix;
        private String uri;

        private XmlNamespace(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getUri() {
            return this.uri;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            XmlNamespace namespace = (XmlNamespace)o;
            if (this.prefix == null && namespace.prefix != null) {
                return false;
            }
            if (this.uri == null && namespace.uri != null) {
                return false;
            }
            if (this.prefix != null && !this.prefix.equals(namespace.prefix)) {
                return false;
            }
            return this.uri == null || this.uri.equals(namespace.uri);
        }

        public int hashCode() {
            int result = this.prefix.hashCode();
            result = 31 * result + this.uri.hashCode();
            return result;
        }
    }
}

