/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.parser;

import java.security.cert.CertificateException;
import java.util.List;
import net.dongliu.apk.parser.ApkParsers;
import net.dongliu.apk.parser.bean.CertificateMeta;
import net.dongliu.apk.parser.parser.BCCertificateParser;
import net.dongliu.apk.parser.parser.JSSECertificateParser;

public abstract class CertificateParser {
    protected final byte[] data;

    public CertificateParser(byte[] data) {
        this.data = data;
    }

    public static CertificateParser getInstance(byte[] data) {
        if (ApkParsers.useBouncyCastle()) {
            return new BCCertificateParser(data);
        }
        return new JSSECertificateParser(data);
    }

    public abstract List<CertificateMeta> parse() throws CertificateException;
}

