/*
 * Decompiled with CFR 0.152.
 */
package net.dhruvpatel.shortify;

import android.os.AsyncTask;
import android.util.Log;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;

public class AJAX {
    private static final String TAG = "Shortify - AJAX";
    private static final int GET = 0;
    private static final int POST = 1;

    public static void get(URL url, AJAXCallback callback) {
        new HttpTask(url, callback, 0, null).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[0]);
    }

    public static void post(URL url, HashMap<String, Object> queryStringData, AJAXCallback callback) {
        new HttpTask(url, callback, 1, queryStringData).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[0]);
    }

    public static interface AJAXCallback {
        public void onComplete(String var1);
    }

    static class HttpTask
    extends AsyncTask<String, Void, Void> {
        private URL mUrl;
        private String data;
        private AJAXCallback mCallback;
        private int mRequestMethod;
        private HashMap<String, Object> mQueryStringData;

        public HttpTask(URL url, AJAXCallback callback, int requestMethod, HashMap<String, Object> queryStringData) {
            this.mRequestMethod = requestMethod;
            this.mCallback = callback;
            this.mUrl = url;
            this.mQueryStringData = queryStringData;
        }

        protected Void doInBackground(String ... urls) {
            try {
                Set<String> keys;
                StringBuilder queryStringBuilder;
                HttpURLConnection conn;
                InputStreamReader input = null;
                if (this.mUrl.toString().toLowerCase().startsWith("https://")) {
                    conn = (HttpsURLConnection)this.mUrl.openConnection();
                    Log.d((String)AJAX.TAG, (String)("Connecting " + this.mUrl.toString()));
                    Log.d((String)AJAX.TAG, (String)"Protocol: HTTPS");
                    conn.setConnectTimeout(20000);
                    conn.setReadTimeout(20000);
                    if (this.mRequestMethod == 0) {
                        conn.setRequestMethod("GET");
                        Log.d((String)AJAX.TAG, (String)"Request method: GET");
                    } else {
                        conn.setRequestMethod("POST");
                        Log.d((String)AJAX.TAG, (String)"Request method: POST");
                        queryStringBuilder = new StringBuilder();
                        keys = this.mQueryStringData.keySet();
                        for (String key : keys) {
                            queryStringBuilder.append(key).append("=").append(this.mQueryStringData.get(key)).append("&");
                        }
                        String urlParameters = queryStringBuilder.toString();
                        conn.setDoOutput(true);
                        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
                        wr.writeBytes(urlParameters);
                        wr.flush();
                        wr.close();
                        Log.d((String)AJAX.TAG, (String)("Data sent: " + urlParameters));
                    }
                    if (conn.getResponseCode() == 200) {
                        input = new InputStreamReader(conn.getInputStream());
                    }
                } else {
                    conn = (HttpURLConnection)this.mUrl.openConnection();
                    Log.d((String)AJAX.TAG, (String)("Connecting " + this.mUrl.toString()));
                    Log.d((String)AJAX.TAG, (String)"Protocol: HTTP");
                    conn.setConnectTimeout(20000);
                    conn.setReadTimeout(20000);
                    if (this.mRequestMethod == 0) {
                        conn.setRequestMethod("GET");
                        Log.d((String)AJAX.TAG, (String)"Request method: GET");
                    } else {
                        conn.setRequestMethod("POST");
                        Log.d((String)AJAX.TAG, (String)"Request method: POST");
                        queryStringBuilder = new StringBuilder();
                        keys = this.mQueryStringData.keySet();
                        for (String key : keys) {
                            queryStringBuilder.append(key).append("=").append(this.mQueryStringData.get(key)).append("&");
                        }
                        String urlParameters = queryStringBuilder.toString();
                        conn.setDoOutput(true);
                        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
                        wr.writeBytes(urlParameters);
                        wr.flush();
                        wr.close();
                        Log.d((String)AJAX.TAG, (String)("Data sent: " + urlParameters));
                    }
                    if (conn.getResponseCode() == 200) {
                        input = new InputStreamReader(conn.getInputStream());
                    }
                }
                if (input != null) {
                    String inputLine;
                    BufferedReader in = new BufferedReader(input);
                    StringBuilder response = new StringBuilder();
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                    this.data = response.toString();
                    Log.d((String)AJAX.TAG, (String)"Response received from server");
                    this.mCallback.onComplete(this.data);
                } else {
                    this.mCallback.onComplete("Bad request");
                }
            }
            catch (Exception e) {
                Log.e((String)AJAX.TAG, (String)e.toString());
            }
            return null;
        }
    }
}

