/*
 * Decompiled with CFR 0.152.
 */
package net.dhruvpatel.shortify;

import android.util.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONParser {
    private static final String TAG = "Shortify - JSONParser";

    private static Object parseJSON(String path, JSONObject data) {
        Object result = null;
        String[] pathParts = path.split("\\.");
        int totalParts = pathParts.length;
        for (int i = 0; i < totalParts; ++i) {
            JSONArray jsonArray;
            Log.v((String)TAG, (String)pathParts[i]);
            if (i == totalParts - 1) {
                if (pathParts[i].contains("[") && pathParts[i].contains("]")) {
                    try {
                        int indexNumber = Integer.parseInt(pathParts[i].substring(pathParts[i].indexOf("[") + 1, pathParts[i].indexOf("]")));
                        jsonArray = data.getJSONArray(pathParts[i].substring(0, pathParts[i].indexOf("[")));
                        return jsonArray.getJSONObject(indexNumber);
                    }
                    catch (JSONException e) {
                        Log.e((String)TAG, (String)e.getMessage());
                        continue;
                    }
                }
                try {
                    return data.get(pathParts[i]);
                }
                catch (JSONException e) {
                    Log.e((String)TAG, (String)e.getMessage());
                    continue;
                }
            }
            if (pathParts[i].contains("[") && pathParts[i].contains("]")) {
                try {
                    int indexNumber = Integer.parseInt(pathParts[i].substring(pathParts[i].indexOf("[") + 1, pathParts[i].indexOf("]")));
                    jsonArray = data.getJSONArray(pathParts[i].substring(0, pathParts[i].indexOf("[")));
                    data = jsonArray.getJSONObject(indexNumber);
                }
                catch (JSONException e) {
                    Log.e((String)TAG, (String)e.getMessage());
                }
                continue;
            }
            try {
                data = data.getJSONObject(pathParts[i]);
                continue;
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)e.getMessage());
            }
        }
        return result;
    }

    public static int getIntFromJSON(String path, JSONObject data) {
        return (Integer)JSONParser.parseJSON(path, data);
    }

    public static boolean getBooleanFromJSON(String path, JSONObject data) {
        return (Boolean)JSONParser.parseJSON(path, data);
    }

    public static String getStringFromJSON(String path, JSONObject data) {
        return String.valueOf(JSONParser.parseJSON(path, data));
    }

    public static double getDoubleFromJSON(String path, JSONObject data) {
        return (Double)JSONParser.parseJSON(path, data);
    }

    public static long getLongFromJSON(String path, JSONObject data) {
        return (Long)JSONParser.parseJSON(path, data);
    }
}

