/*
 * Decompiled with CFR 0.152.
 */
package net.dhruvpatel.shortify;

import android.os.AsyncTask;
import android.util.Log;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;

public class AJAX {
    private static final String TAG = "AJAX";
    private static final int GET = 0;
    private static final int POST = 1;

    public static void get(URL url, AJAXCallback callback) {
        new HttpTask(url, callback, 0, null).execute(new String[0]);
    }

    public static void post(URL url, HashMap<String, Object> queryStringData, AJAXCallback callback) {
        new HttpTask(url, callback, 1, queryStringData).execute(new String[0]);
    }

    public static interface AJAXCallback {
        public void onComplete(String var1);
    }

    static class HttpTask
    extends AsyncTask<String, Void, Void> {
        private URL mUrl;
        private String data;
        private AJAXCallback mCallback;
        private int mRequestMethod;
        private HashMap<String, Object> mQueryStringData;

        public HttpTask(URL url, AJAXCallback callback, int requestMethod, HashMap<String, Object> queryStringData) {
            this.mRequestMethod = requestMethod;
            this.mCallback = callback;
            this.mUrl = url;
            this.mQueryStringData = queryStringData;
        }

        protected Void doInBackground(String ... urls) {
            try {
                DataOutputStream wr;
                String urlParameters;
                Set<String> keys;
                StringBuilder queryStringBuilder;
                HttpURLConnection conn;
                InputStreamReader input = null;
                if (this.mUrl.toString().toLowerCase().startsWith("https://")) {
                    conn = (HttpsURLConnection)this.mUrl.openConnection();
                    if (this.mRequestMethod == 0) {
                        conn.setRequestMethod("GET");
                    } else {
                        conn.setRequestMethod("POST");
                        queryStringBuilder = new StringBuilder();
                        keys = this.mQueryStringData.keySet();
                        for (String key : keys) {
                            queryStringBuilder.append(key).append("=").append(this.mQueryStringData.get(key)).append("&");
                        }
                        urlParameters = queryStringBuilder.toString();
                        conn.setDoOutput(true);
                        wr = new DataOutputStream(conn.getOutputStream());
                        wr.writeBytes(urlParameters);
                        wr.flush();
                        wr.close();
                    }
                    if (conn.getResponseCode() == 200) {
                        input = new InputStreamReader(conn.getInputStream());
                    }
                    conn.disconnect();
                } else {
                    conn = (HttpURLConnection)this.mUrl.openConnection();
                    if (this.mRequestMethod == 0) {
                        conn.setRequestMethod("GET");
                    } else {
                        conn.setRequestMethod("POST");
                        queryStringBuilder = new StringBuilder();
                        keys = this.mQueryStringData.keySet();
                        for (String key : keys) {
                            queryStringBuilder.append(key).append("=").append(this.mQueryStringData.get(key)).append("&");
                        }
                        urlParameters = queryStringBuilder.toString();
                        conn.setDoOutput(true);
                        wr = new DataOutputStream(conn.getOutputStream());
                        wr.writeBytes(urlParameters);
                        wr.flush();
                        wr.close();
                    }
                    if (conn.getResponseCode() == 200) {
                        input = new InputStreamReader(conn.getInputStream());
                    }
                    conn.disconnect();
                }
                if (input != null) {
                    String inputLine;
                    BufferedReader in = new BufferedReader(input);
                    StringBuilder response = new StringBuilder();
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                    in.close();
                    this.data = response.toString();
                    this.mCallback.onComplete(this.data);
                } else {
                    this.mCallback.onComplete("Bad request");
                }
            }
            catch (Exception e) {
                Log.e((String)AJAX.TAG, (String)e.toString());
            }
            return null;
        }
    }
}

