/*
 * Decompiled with CFR 0.152.
 */
package net.dhruvpatel.shortify;

import android.app.Activity;
import android.app.DatePickerDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.TimePickerDialog;
import android.content.Context;
import android.os.Bundle;
import android.text.format.DateFormat;
import android.widget.DatePicker;
import android.widget.TimePicker;
import java.util.Calendar;
import net.dhruvpatel.shortify.interfaces.DateListener;
import net.dhruvpatel.shortify.interfaces.TimeListener;

public class InputHandlers {
    private static DatePickerFragment datePickerFragment;
    private static DateListener mDateListner;
    private static TimePickerFragment timePickerFragment;
    private static TimeListener mTimeListner;
    protected static Activity sInputHandlersActivity;

    public static void datePicker(DateListener dateListener) {
        datePickerFragment = new DatePickerFragment();
        datePickerFragment.show(sInputHandlersActivity.getFragmentManager(), "datePicker");
        mDateListner = dateListener;
    }

    public static void timePicker(TimeListener timeListener) {
        timePickerFragment = new TimePickerFragment();
        timePickerFragment.show(sInputHandlersActivity.getFragmentManager(), "timePicker");
        mTimeListner = timeListener;
    }

    public static class TimePickerFragment
    extends DialogFragment
    implements TimePickerDialog.OnTimeSetListener {
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            Calendar c = Calendar.getInstance();
            int hour = c.get(11);
            int minute = c.get(12);
            return new TimePickerDialog((Context)this.getActivity(), (TimePickerDialog.OnTimeSetListener)this, hour, minute, DateFormat.is24HourFormat((Context)this.getActivity()));
        }

        public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
            mTimeListner.onSelect(hourOfDay, minute);
        }
    }

    public static class DatePickerFragment
    extends DialogFragment
    implements DatePickerDialog.OnDateSetListener {
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            Calendar c = Calendar.getInstance();
            int year = c.get(1);
            int month = c.get(2);
            int day = c.get(5);
            return new DatePickerDialog((Context)this.getActivity(), (DatePickerDialog.OnDateSetListener)this, year, month, day);
        }

        public void onDateSet(DatePicker view, int year, int month, int day) {
            mDateListner.onSelect(day, month + 1, year);
        }
    }
}

