/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.scope;

import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.devh.boot.grpc.server.interceptor.GrpcGlobalServerInterceptor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.core.annotation.Order;

@GrpcGlobalServerInterceptor
@Order(value=-2147483648)
public class GrpcRequestScope
implements Scope,
BeanFactoryPostProcessor,
ServerInterceptor,
Context.CancellationListener {
    public static final String GRPC_REQUEST_SCOPE_NAME = "grpcRequest";
    private static final String GRPC_REQUEST_SCOPE_ID = "grpc-request";
    private static final Context.Key<ScopedBeansContainer> GRPC_REQUEST_KEY = Context.key((String)"grpcRequestScope");

    public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) throws BeansException {
        factory.registerScope(GRPC_REQUEST_SCOPE_NAME, (Scope)this);
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        ScopedBeansContainer container = new ScopedBeansContainer();
        Context context = Context.current().withValue(GRPC_REQUEST_KEY, (Object)container);
        context.addListener((Context.CancellationListener)this, MoreExecutors.directExecutor());
        return Contexts.interceptCall((Context)context, call, (Metadata)headers, next);
    }

    public Object get(String name, ObjectFactory<?> objectFactory) {
        return this.getCurrentScopeContainer().getOrCreate(name, objectFactory);
    }

    public Object remove(String name) {
        return this.getCurrentScopeContainer().remove(name);
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        this.getCurrentScopeContainer().registerDestructionCallback(name, callback);
    }

    public Object resolveContextualObject(String key) {
        return null;
    }

    public String getConversationId() {
        return GRPC_REQUEST_SCOPE_ID;
    }

    public void cancelled(Context context) {
        ScopedBeansContainer container = (ScopedBeansContainer)GRPC_REQUEST_KEY.get(context);
        if (container != null) {
            container.destroy();
        }
    }

    private ScopedBeansContainer getCurrentScopeContainer() {
        ScopedBeansContainer scopedBeansContainer = (ScopedBeansContainer)GRPC_REQUEST_KEY.get();
        if (scopedBeansContainer == null) {
            throw new IllegalStateException("Trying to access grpcRequest-Scope, but it was not assigned to this execution context.\nThere is either no active grpc request or you didn't transfer the correct GrpcContext to this async execution context.");
        }
        return scopedBeansContainer;
    }

    private static class ScopedBeansContainer {
        private final Map<String, ScopedBeanReference> references = new ConcurrentHashMap<String, ScopedBeanReference>();

        private ScopedBeansContainer() {
        }

        public Object getOrCreate(String name, ObjectFactory<?> objectFactory) {
            return this.references.computeIfAbsent(name, key -> new ScopedBeanReference(objectFactory)).getBean();
        }

        public Object remove(String name) {
            ScopedBeanReference ref = this.references.remove(name);
            if (ref == null) {
                return null;
            }
            return ref.getBeanIfExists();
        }

        public void registerDestructionCallback(String name, Runnable callback) {
            ScopedBeanReference ref = this.references.get(name);
            if (ref != null) {
                ref.setDestructionCallback(callback);
            }
        }

        public void destroy() {
            ArrayList<RuntimeException> errors = new ArrayList<RuntimeException>();
            Iterator<ScopedBeanReference> it = this.references.values().iterator();
            while (it.hasNext()) {
                ScopedBeanReference val = it.next();
                it.remove();
                try {
                    val.destroy();
                }
                catch (RuntimeException e) {
                    errors.add(e);
                }
            }
            if (!errors.isEmpty()) {
                RuntimeException rex = (RuntimeException)errors.remove(0);
                for (RuntimeException error : errors) {
                    rex.addSuppressed(error);
                }
                throw rex;
            }
        }
    }

    private static class ScopedBeanReference {
        private final ObjectFactory<?> objectFactory;
        private Object bean;
        private Runnable destructionCallback;

        public ScopedBeanReference(ObjectFactory<?> objectFactory) {
            this.objectFactory = objectFactory;
        }

        public synchronized Object getBean() {
            if (this.bean == null) {
                this.bean = this.objectFactory.getObject();
            }
            return this.bean;
        }

        public Object getBeanIfExists() {
            return this.bean;
        }

        public void setDestructionCallback(Runnable destructionCallback) {
            this.destructionCallback = destructionCallback;
        }

        public synchronized void destroy() {
            Runnable callback = this.destructionCallback;
            if (callback != null) {
                callback.run();
            }
            this.bean = null;
            this.destructionCallback = null;
        }

        public String toString() {
            return "ScopedBeanReference [objectFactory=" + this.objectFactory + ", bean=" + this.bean + "]";
        }
    }
}

