/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.security.authentication;

import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import net.devh.boot.grpc.server.security.authentication.GrpcAuthenticationReader;
import net.devh.boot.grpc.server.security.authentication.X509CertificateAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;

public class SSLContextGrpcAuthenticationReader
implements GrpcAuthenticationReader {
    private static final Logger log = LoggerFactory.getLogger(SSLContextGrpcAuthenticationReader.class);

    @Override
    public Authentication readAuthentication(ServerCall<?, ?> call, Metadata metadata) {
        Certificate[] certs;
        SSLSession sslSession = (SSLSession)call.getAttributes().get(Grpc.TRANSPORT_ATTR_SSL_SESSION);
        if (sslSession == null) {
            log.trace("Peer not verified via SSL");
            return null;
        }
        try {
            certs = sslSession.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            log.trace("Peer not verified via certificate", (Throwable)e);
            return null;
        }
        return this.fromCertificate(certs[certs.length - 1]);
    }

    @Nullable
    protected Authentication fromCertificate(Certificate cert) {
        if (cert instanceof X509Certificate) {
            log.debug("Found X509 certificate");
            return new X509CertificateAuthentication((X509Certificate)cert);
        }
        log.debug("Unsupported certificate type: {}", (Object)cert.getType());
        return null;
    }
}

