/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.serverfactory;

import com.google.common.net.InetAddresses;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import javax.net.ssl.SSLException;
import net.devh.boot.grpc.server.config.ClientAuth;
import net.devh.boot.grpc.server.config.GrpcServerProperties;
import net.devh.boot.grpc.server.serverfactory.AbstractGrpcServerFactory;
import net.devh.boot.grpc.server.serverfactory.GrpcServerConfigurer;

public class ShadedNettyGrpcServerFactory
extends AbstractGrpcServerFactory<NettyServerBuilder> {
    public ShadedNettyGrpcServerFactory(GrpcServerProperties properties, List<GrpcServerConfigurer> serverConfigurers) {
        super(properties, serverConfigurers);
    }

    @Override
    protected NettyServerBuilder newServerBuilder() {
        String address = this.getAddress();
        int port = this.getPort();
        if ("*".equals(address)) {
            return NettyServerBuilder.forPort((int)port);
        }
        return NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(InetAddresses.forString((String)address), port));
    }

    @Override
    protected void configureSecurity(NettyServerBuilder builder) {
        GrpcServerProperties.Security security = this.properties.getSecurity();
        if (security.isEnabled()) {
            File certificateChainFile = this.toCheckedFile("certificateChain", security.getCertificateChainPath());
            File privateKeyFile = this.toCheckedFile("privateKey", security.getPrivateKeyPath());
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forServer((File)certificateChainFile, (File)privateKeyFile);
            if (security.getClientAuth() != ClientAuth.NONE) {
                sslContextBuilder.clientAuth(ShadedNettyGrpcServerFactory.of(security.getClientAuth()));
                String trustCertCollectionPath = security.getTrustCertCollectionPath();
                if (trustCertCollectionPath != null && !trustCertCollectionPath.isEmpty()) {
                    File trustCertCollectionFile = this.toCheckedFile("trustCertCollection", trustCertCollectionPath);
                    sslContextBuilder.trustManager(trustCertCollectionFile);
                }
            }
            try {
                builder.sslContext(sslContextBuilder.build());
            }
            catch (SSLException e) {
                throw new IllegalStateException("Failed to create ssl context for grpc server", e);
            }
        }
    }

    protected static io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth of(ClientAuth clientAuth) {
        switch (clientAuth) {
            case NONE: {
                return io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth.NONE;
            }
            case OPTIONAL: {
                return io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth.OPTIONAL;
            }
            case REQUIRE: {
                return io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth.REQUIRE;
            }
        }
        throw new IllegalArgumentException("Unsupported ClientAuth: " + (Object)((Object)clientAuth));
    }
}

