/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.nameresolver;

import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import java.net.URI;
import net.devh.boot.grpc.server.config.GrpcServerProperties;
import net.devh.boot.grpc.server.nameresolver.SelfNameResolver;

public class SelfNameResolverFactory
extends NameResolverProvider {
    public static final String SELF_SCHEME = "self";
    private final GrpcServerProperties properties;

    public SelfNameResolverFactory(GrpcServerProperties properties) {
        this.properties = properties;
    }

    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (SELF_SCHEME.equals(targetUri.getScheme()) || targetUri.toString().equals(SELF_SCHEME)) {
            return new SelfNameResolver(this.properties, args);
        }
        return null;
    }

    public String getDefaultScheme() {
        return SELF_SCHEME;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 0;
    }

    public String toString() {
        return "SelfNameResolverFactory [scheme=" + this.getDefaultScheme() + "]";
    }
}

