/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.advice;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import net.devh.boot.grpc.server.advice.GrpcAdviceExceptionHandler;
import net.devh.boot.grpc.server.advice.GrpcAdviceExceptionListener;

public class GrpcAdviceExceptionInterceptor
implements ServerInterceptor {
    private final GrpcAdviceExceptionHandler grpcAdviceExceptionHandler;

    public GrpcAdviceExceptionInterceptor(GrpcAdviceExceptionHandler grpcAdviceExceptionHandler) {
        this.grpcAdviceExceptionHandler = grpcAdviceExceptionHandler;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        try {
            ServerCall.Listener delegate = next.startCall(call, headers);
            return new GrpcAdviceExceptionListener<ReqT, RespT>(delegate, call, this.grpcAdviceExceptionHandler);
        }
        catch (Throwable throwable) {
            return this.noOpCallListener();
        }
    }

    protected <ReqT> ServerCall.Listener<ReqT> noOpCallListener() {
        return new ServerCall.Listener<ReqT>(){};
    }
}

