/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.autoconfigure;

import javax.annotation.PostConstruct;
import net.devh.boot.grpc.server.config.GrpcServerProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.serviceregistry.ZookeeperRegistration;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties
@ConditionalOnClass(value={ZookeeperRegistration.class})
public class GrpcMetadataZookeeperConfiguration {
    @Autowired(required=false)
    private ZookeeperRegistration zookeeperRegistration;
    @Autowired
    private GrpcServerProperties grpcServerProperties;

    @PostConstruct
    public void init() {
        if (this.zookeeperRegistration != null) {
            int port = this.grpcServerProperties.getPort();
            this.zookeeperRegistration.setPort(0);
            if (-1 != port) {
                ((ZookeeperInstance)this.zookeeperRegistration.getServiceInstance().getPayload()).getMetadata().put("gRPC.port", Integer.toString(port));
            }
        }
    }
}

