/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.autoconfigure;

import javax.annotation.PostConstruct;
import net.devh.boot.grpc.server.config.GrpcServerProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaRegistration;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties
@ConditionalOnClass(value={EurekaRegistration.class})
public class GrpcMetadataEurekaConfiguration {
    @Autowired(required=false)
    private EurekaRegistration eurekaRegistration;
    @Autowired
    private GrpcServerProperties grpcProperties;

    @PostConstruct
    public void init() {
        int port;
        if (this.eurekaRegistration != null && -1 != (port = this.grpcProperties.getPort())) {
            this.eurekaRegistration.getInstanceConfig().getMetadataMap().put("gRPC.port", Integer.toString(port));
        }
    }
}

