/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.server;

import io.grpc.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanExtractor;
import org.springframework.util.StringUtils;

public class MetadataExtractor
implements SpanExtractor<Metadata> {
    private static final Logger log = LoggerFactory.getLogger(MetadataExtractor.class);
    private static final String GRPC_COMPONENT = "grpc";

    public Span joinTrace(Metadata carrier) {
        if (this.getMetadata(carrier, "X-B3-TraceId") == null) {
            return null;
        }
        boolean skip = "0".equals(this.getMetadata(carrier, "X-B3-Sampled"));
        long traceId = Span.hexToId((String)this.getMetadata(carrier, "X-B3-TraceId"));
        long spanId = this.spanId(carrier, traceId);
        return this.buildParentSpan(carrier, skip, traceId, spanId);
    }

    private String getMetadata(Metadata metadata, String name) {
        return (String)metadata.get(Metadata.Key.of((String)name, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
    }

    private long spanId(Metadata carrier, long traceId) {
        String spanId = this.getMetadata(carrier, "X-B3-SpanId");
        if (spanId == null) {
            log.debug("Request is missing a span id but it has a trace id. We'll assume that this is a root span with span id equal to trace id");
            return traceId;
        }
        return Span.hexToId((String)spanId);
    }

    private Span buildParentSpan(Metadata carrier, boolean skip, long traceId, long spanId) {
        Span.SpanBuilder span = Span.builder().traceId(traceId).spanId(spanId);
        String processId = this.getMetadata(carrier, "X-Process-Id");
        String parentName = this.getMetadata(carrier, "X-Span-Name");
        if (StringUtils.hasText((String)parentName)) {
            span.name(parentName);
        } else {
            span.name("grpc:/parent" + parentName);
        }
        if (StringUtils.hasText((String)processId)) {
            span.processId(processId);
        }
        if (this.getMetadata(carrier, "X-B3-ParentSpanId") != null) {
            span.parent(Long.valueOf(Span.hexToId((String)this.getMetadata(carrier, "X-B3-ParentSpanId"))));
        }
        span.remote(true);
        if (skip) {
            span.exportable(false);
        }
        return span.build();
    }
}

