/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.nameresolver;

import io.grpc.Attributes;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import jakarta.annotation.PreDestroy;
import java.net.URI;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.devh.boot.grpc.client.nameresolver.DiscoveryClientNameResolver;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.HeartbeatMonitor;
import org.springframework.context.event.EventListener;

public class DiscoveryClientResolverFactory
extends NameResolverProvider {
    public static final String DISCOVERY_SCHEME = "discovery";
    public static final Attributes.Key<String> DISCOVERY_SERVICE_NAME_KEY = Attributes.Key.create((String)"serviceName");
    public static final Attributes.Key<String> DISCOVERY_INSTANCE_ID_KEY = Attributes.Key.create((String)"instanceId");
    private final Set<DiscoveryClientNameResolver> discoveryClientNameResolvers = ConcurrentHashMap.newKeySet();
    private final HeartbeatMonitor monitor = new HeartbeatMonitor();
    private final DiscoveryClient client;

    public DiscoveryClientResolverFactory(DiscoveryClient client) {
        this.client = Objects.requireNonNull(client, "client");
    }

    @Nullable
    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (DISCOVERY_SCHEME.equals(targetUri.getScheme())) {
            String serviceName = targetUri.getPath();
            if (serviceName == null || serviceName.length() <= 1 || !serviceName.startsWith("/")) {
                throw new IllegalArgumentException("Incorrectly formatted target uri; expected: 'discovery:[//]/<service-name>'; but was '" + targetUri.toString() + "'");
            }
            DiscoveryClientNameResolver nameResolver = this.newNameResolver(serviceName.substring(1), args);
            this.discoveryClientNameResolvers.add(nameResolver);
            return nameResolver;
        }
        return null;
    }

    protected DiscoveryClientNameResolver newNameResolver(String serviceName, NameResolver.Args args) {
        return new DiscoveryClientNameResolver(serviceName, this.client, args, (SharedResourceHolder.Resource<Executor>)GrpcUtil.SHARED_CHANNEL_EXECUTOR, this.discoveryClientNameResolvers::remove);
    }

    public String getDefaultScheme() {
        return DISCOVERY_SCHEME;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 6;
    }

    @EventListener(value={HeartbeatEvent.class})
    public void heartbeat(HeartbeatEvent event) {
        if (this.monitor.update(event.getValue())) {
            for (DiscoveryClientNameResolver discoveryClientNameResolver : this.discoveryClientNameResolvers) {
                discoveryClientNameResolver.refreshFromExternal();
            }
        }
    }

    @PreDestroy
    public void destroy() {
        this.discoveryClientNameResolvers.clear();
    }

    public String toString() {
        return "DiscoveryClientResolverFactory [scheme=" + this.getDefaultScheme() + ", discoveryClient=" + this.client + "]";
    }
}

