/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.autoconfigure;

import brave.grpc.GrpcTracing;
import net.devh.boot.grpc.client.interceptor.GlobalClientInterceptorConfigurer;
import net.devh.boot.grpc.client.interceptor.OrderedClientInterceptor;
import net.devh.boot.grpc.common.autoconfigure.GrpcCommonTraceAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.grpc.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={GrpcCommonTraceAutoConfiguration.class})
@ConditionalOnBean(value={GrpcTracing.class})
public class GrpcClientTraceAutoConfiguration {
    @Bean
    public GlobalClientInterceptorConfigurer globalTraceClientInterceptorConfigurer(GrpcTracing grpcTracing) {
        return registry -> registry.addClientInterceptors(new OrderedClientInterceptor(grpcTracing.newClientInterceptor(), 2501));
    }
}

