/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.inject;

import com.google.common.collect.Lists;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.stub.AbstractStub;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.devh.boot.grpc.client.channelfactory.GrpcChannelFactory;
import net.devh.boot.grpc.client.inject.GrpcClient;
import net.devh.boot.grpc.client.inject.StubTransformer;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class GrpcClientBeanPostProcessor
implements BeanPostProcessor {
    private final ApplicationContext applicationContext;
    private GrpcChannelFactory channelFactory = null;
    private List<StubTransformer> stubTransformers = null;

    public GrpcClientBeanPostProcessor(ApplicationContext applicationContext) {
        this.applicationContext = Objects.requireNonNull(applicationContext, "applicationContext");
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        do {
            GrpcClient annotation;
            for (Field field : clazz.getDeclaredFields()) {
                annotation = (GrpcClient)AnnotationUtils.findAnnotation((AnnotatedElement)field, GrpcClient.class);
                if (annotation == null) continue;
                ReflectionUtils.makeAccessible((Field)field);
                ReflectionUtils.setField((Field)field, (Object)bean, this.processInjectionPoint(field, field.getType(), annotation));
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                annotation = (GrpcClient)AnnotationUtils.findAnnotation((Method)accessibleObject, GrpcClient.class);
                if (annotation == null) continue;
                Class<?>[] paramTypes = ((Method)accessibleObject).getParameterTypes();
                if (paramTypes.length != 1) {
                    throw new BeanDefinitionStoreException("Method " + accessibleObject + " doesn't have exactly one parameter.");
                }
                ReflectionUtils.makeAccessible((Method)accessibleObject);
                ReflectionUtils.invokeMethod((Method)accessibleObject, (Object)bean, (Object[])new Object[]{this.processInjectionPoint((Member)((Object)accessibleObject), paramTypes[0], annotation)});
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return bean;
    }

    protected <T> T processInjectionPoint(Member injectionTarget, Class<T> injectionType, GrpcClient annotation) {
        Channel channel;
        List<ClientInterceptor> interceptors = this.interceptorsFromAnnotation(annotation);
        String name = annotation.value();
        try {
            channel = this.getChannelFactory().createChannel(name, interceptors, annotation.sortInterceptors());
            if (channel == null) {
                throw new IllegalStateException("Channel factory created a null channel for " + name);
            }
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Failed to create channel: " + name, e);
        }
        T value = this.valueForMember(name, injectionTarget, injectionType, channel);
        if (value == null) {
            throw new IllegalStateException("Injection value is null unexpectedly for " + name + " at " + injectionTarget);
        }
        return value;
    }

    private GrpcChannelFactory getChannelFactory() {
        if (this.channelFactory == null) {
            GrpcChannelFactory factory;
            this.channelFactory = factory = (GrpcChannelFactory)this.applicationContext.getBean(GrpcChannelFactory.class);
            return factory;
        }
        return this.channelFactory;
    }

    private List<StubTransformer> getStubTransformers() {
        if (this.stubTransformers == null) {
            Collection transformers = this.applicationContext.getBeansOfType(StubTransformer.class).values();
            this.stubTransformers = new ArrayList(transformers);
            return this.stubTransformers;
        }
        return this.stubTransformers;
    }

    protected List<ClientInterceptor> interceptorsFromAnnotation(GrpcClient annotation) throws BeansException {
        ArrayList list = Lists.newArrayList();
        for (Class<? extends ClientInterceptor> interceptorClass : annotation.interceptors()) {
            ClientInterceptor clientInterceptor;
            if (this.applicationContext.getBeanNamesForType(ClientInterceptor.class).length > 0) {
                clientInterceptor = (ClientInterceptor)this.applicationContext.getBean(interceptorClass);
            } else {
                try {
                    clientInterceptor = interceptorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new BeanCreationException("Failed to create interceptor instance", (Throwable)e);
                }
            }
            list.add(clientInterceptor);
        }
        for (String interceptorName : annotation.interceptorNames()) {
            list.add(this.applicationContext.getBean(interceptorName, ClientInterceptor.class));
        }
        return list;
    }

    protected <T> T valueForMember(String name, Member injectionTarget, Class<T> injectionType, Channel channel) throws BeansException {
        if (Channel.class.equals(injectionType)) {
            return injectionType.cast(channel);
        }
        if (AbstractStub.class.isAssignableFrom(injectionType)) {
            try {
                Class<AbstractStub> stubClass = injectionType.asSubclass(AbstractStub.class);
                Constructor constructor = ReflectionUtils.accessibleConstructor(stubClass, (Class[])new Class[]{Channel.class});
                AbstractStub<?> stub = (AbstractStub<?>)constructor.newInstance(channel);
                for (StubTransformer stubTransformer : this.getStubTransformers()) {
                    stub = stubTransformer.transform(name, stub);
                }
                return injectionType.cast(stub);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new BeanInstantiationException(injectionType, "Failed to create gRPC client for : " + injectionTarget, (Throwable)e);
            }
        }
        throw new InvalidPropertyException(injectionTarget.getDeclaringClass(), injectionTarget.getName(), "Unsupported type " + injectionType.getName());
    }
}

