/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.nameresolver;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.SharedResourceHolder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.util.CollectionUtils;

public class DiscoveryClientNameResolver
extends NameResolver {
    private static final Logger log = LoggerFactory.getLogger(DiscoveryClientNameResolver.class);
    private final String name;
    private final DiscoveryClient client;
    private final SharedResourceHolder.Resource<Executor> executorResource;
    @GuardedBy(value="this")
    private NameResolver.Listener listener;
    @GuardedBy(value="this")
    private Executor executor;
    @GuardedBy(value="this")
    private boolean resolving;
    @GuardedBy(value="this")
    private boolean shutdown;
    @GuardedBy(value="this")
    private List<ServiceInstance> instanceList = Lists.newArrayList();

    public DiscoveryClientNameResolver(String name, DiscoveryClient client, SharedResourceHolder.Resource<Executor> executorResource) {
        this.name = name;
        this.client = client;
        this.executorResource = executorResource;
    }

    public final String getServiceAuthority() {
        return this.name;
    }

    public final synchronized void start(NameResolver.Listener listener) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
        this.executor = (Executor)SharedResourceHolder.get(this.executorResource);
        this.listener = (NameResolver.Listener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        this.resolve();
    }

    public final synchronized void refresh() {
        if (this.listener != null) {
            this.resolve();
        }
    }

    @GuardedBy(value="this")
    private void resolve() {
        log.debug("Scheduled resolve for {}", (Object)this.name);
        if (this.resolving || this.shutdown) {
            return;
        }
        this.resolving = true;
        this.executor.execute(new Resolve(this.listener, this.instanceList));
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.executor != null) {
            this.executor = (Executor)SharedResourceHolder.release(this.executorResource, (Object)this.executor);
        }
        this.instanceList = Lists.newArrayList();
    }

    public String toString() {
        return "DiscoveryClientNameResolver [name=" + this.name + ", discoveryClient=" + this.client + "]";
    }

    private final class Resolve
    implements Runnable {
        private final NameResolver.Listener savedListener;
        private final List<ServiceInstance> savedInstanceList;

        Resolve(NameResolver.Listener listener, List<ServiceInstance> instanceList) {
            this.savedListener = Objects.requireNonNull(listener, "listener");
            this.savedInstanceList = Objects.requireNonNull(instanceList, "instanceList");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList newInstanceList = null;
            try {
                newInstanceList = this.resolveInternal();
            }
            catch (Exception e) {
                this.savedListener.onError(Status.UNAVAILABLE.withCause((Throwable)e).withDescription("Failed to update server list for " + DiscoveryClientNameResolver.this.name));
                newInstanceList = Lists.newArrayList();
            }
            finally {
                DiscoveryClientNameResolver discoveryClientNameResolver = DiscoveryClientNameResolver.this;
                synchronized (discoveryClientNameResolver) {
                    DiscoveryClientNameResolver.this.resolving = false;
                    if (newInstanceList != null && !DiscoveryClientNameResolver.this.shutdown) {
                        DiscoveryClientNameResolver.this.instanceList = newInstanceList;
                    }
                }
            }
        }

        private List<ServiceInstance> resolveInternal() {
            String name = DiscoveryClientNameResolver.this.name;
            List newInstanceList = DiscoveryClientNameResolver.this.client.getInstances(name);
            log.debug("Got {} candidate servers for {}", (Object)newInstanceList.size(), (Object)name);
            if (CollectionUtils.isEmpty((Collection)newInstanceList)) {
                log.error("No servers found for {}", (Object)name);
                this.savedListener.onError(Status.UNAVAILABLE.withDescription("No servers found for " + name));
                return Lists.newArrayList();
            }
            if (!this.needsToUpdateConnections(newInstanceList)) {
                log.debug("Nothing has changed... skipping update for {}", (Object)name);
                return null;
            }
            log.debug("Ready to update server list for {}", (Object)name);
            ArrayList targets = Lists.newArrayList();
            for (ServiceInstance instance : newInstanceList) {
                int port = this.getGRPCPort(instance);
                log.debug("Found gRPC server {}:{} for {}", new Object[]{instance.getHost(), port, name});
                targets.add(new EquivalentAddressGroup((SocketAddress)new InetSocketAddress(instance.getHost(), port), Attributes.EMPTY));
            }
            if (targets.isEmpty()) {
                log.error("None of the servers for {} specified a gRPC port", (Object)name);
                this.savedListener.onError(Status.UNAVAILABLE.withDescription("None of the servers for " + name + " specified a gRPC port"));
                return Lists.newArrayList();
            }
            this.savedListener.onAddresses((List)targets, Attributes.EMPTY);
            log.info("Done updating server list for {}", (Object)name);
            return newInstanceList;
        }

        private int getGRPCPort(ServiceInstance instance) {
            Map metadata = instance.getMetadata();
            if (metadata == null) {
                return instance.getPort();
            }
            String portString = (String)metadata.get("gRPC.port");
            if (portString == null) {
                return instance.getPort();
            }
            try {
                return Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to parse gRPC port information from: " + instance, e);
            }
        }

        private boolean needsToUpdateConnections(List<ServiceInstance> newInstanceList) {
            if (this.savedInstanceList.size() != newInstanceList.size()) {
                return true;
            }
            for (ServiceInstance instance : this.savedInstanceList) {
                int port = this.getGRPCPort(instance);
                boolean isSame = false;
                for (ServiceInstance newInstance : newInstanceList) {
                    int newPort = this.getGRPCPort(newInstance);
                    if (!newInstance.getHost().equals(instance.getHost()) || port != newPort) continue;
                    isSame = true;
                    break;
                }
                if (isSame) continue;
                return true;
            }
            return false;
        }
    }
}

