/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.nameresolver;

import io.grpc.Attributes;
import io.grpc.NameResolver;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import net.devh.boot.grpc.client.nameresolver.DiscoveryClientNameResolver;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.HeartbeatMonitor;
import org.springframework.context.event.EventListener;

public class DiscoveryClientResolverFactory
extends NameResolver.Factory {
    public static final String DISCOVERY_SCHEME = "discovery";
    public static final Function<String, URI> DISCOVERY_DEFAULT_URI_MAPPER = clientName -> URI.create("discovery:///" + clientName);
    private final Collection<DiscoveryClientNameResolver> discoveryClientNameResolvers = new ArrayList<DiscoveryClientNameResolver>();
    private final HeartbeatMonitor monitor = new HeartbeatMonitor();
    private final DiscoveryClient client;

    public DiscoveryClientResolverFactory(DiscoveryClient client) {
        this.client = client;
    }

    @Nullable
    public NameResolver newNameResolver(URI targetUri, Attributes params) {
        if (DISCOVERY_SCHEME.equals(targetUri.getScheme())) {
            String serviceName = targetUri.getPath();
            if (serviceName == null || serviceName.length() <= 1 || !serviceName.startsWith("/")) {
                throw new IllegalArgumentException("Incorrectly formatted target uri; expected: 'discovery:[//]/<service-name>'; but was '" + targetUri.toString() + "'");
            }
            DiscoveryClientNameResolver discoveryClientNameResolver = new DiscoveryClientNameResolver(serviceName.substring(1), this.client, (SharedResourceHolder.Resource<ScheduledExecutorService>)GrpcUtil.TIMER_SERVICE, (SharedResourceHolder.Resource<Executor>)GrpcUtil.SHARED_CHANNEL_EXECUTOR);
            this.discoveryClientNameResolvers.add(discoveryClientNameResolver);
            return discoveryClientNameResolver;
        }
        return null;
    }

    public String getDefaultScheme() {
        return DISCOVERY_SCHEME;
    }

    @EventListener(value={HeartbeatEvent.class})
    public void heartbeat(HeartbeatEvent event) {
        if (this.monitor.update(event.getValue())) {
            for (DiscoveryClientNameResolver discoveryClientNameResolver : this.discoveryClientNameResolvers) {
                discoveryClientNameResolver.refresh();
            }
        }
    }

    @PreDestroy
    public void destroy() {
        this.discoveryClientNameResolvers.clear();
    }

    public String toString() {
        return "DiscoveryClientResolverFactory [scheme=" + this.getDefaultScheme() + ", discoveryClient=" + this.client + "]";
    }
}

