/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.client;

import com.google.common.collect.Lists;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannel;
import io.grpc.NameResolver;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.net.ssl.SSLException;
import net.devh.springboot.autoconfigure.grpc.client.GlobalClientInterceptorRegistry;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelFactory;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelProperties;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelsProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannelFactory
implements GrpcChannelFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractChannelFactory.class);
    private final GrpcChannelsProperties properties;
    private final LoadBalancer.Factory loadBalancerFactory;
    private final NameResolver.Factory nameResolverFactory;
    private final GlobalClientInterceptorRegistry globalClientInterceptorRegistry;
    @GuardedBy(value="this")
    private final Map<String, ManagedChannel> channels = new ConcurrentHashMap<String, ManagedChannel>();
    private boolean shutdown = false;

    public AbstractChannelFactory(GrpcChannelsProperties properties, LoadBalancer.Factory loadBalancerFactory, NameResolver.Factory nameResolverFactory, GlobalClientInterceptorRegistry globalClientInterceptorRegistry) {
        this.properties = properties;
        this.loadBalancerFactory = loadBalancerFactory;
        this.nameResolverFactory = nameResolverFactory;
        this.globalClientInterceptorRegistry = globalClientInterceptorRegistry;
    }

    public <T extends AbstractChannelFactory> AbstractChannelFactory(GrpcChannelsProperties properties, LoadBalancer.Factory loadBalancerFactory, Function<T, NameResolver.Factory> nameResolverFactoryCreator, GlobalClientInterceptorRegistry globalClientInterceptorRegistry) {
        this.properties = properties;
        this.loadBalancerFactory = loadBalancerFactory;
        this.nameResolverFactory = nameResolverFactoryCreator.apply(this);
        this.globalClientInterceptorRegistry = globalClientInterceptorRegistry;
    }

    @Override
    public Channel createChannel(String name) {
        return this.createChannel(name, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel createChannel(String name, List<ClientInterceptor> interceptors) {
        Channel channel;
        AbstractChannelFactory abstractChannelFactory = this;
        synchronized (abstractChannelFactory) {
            if (this.shutdown) {
                throw new IllegalStateException("GrpcChannelFactory is already closed!");
            }
            channel = (Channel)this.channels.computeIfAbsent(name, this::newManagedChannel);
        }
        List<ClientInterceptor> globalInterceptorList = this.globalClientInterceptorRegistry.getClientInterceptors();
        ArrayList interceptorSet = Lists.newArrayList();
        if (!globalInterceptorList.isEmpty()) {
            interceptorSet.addAll(globalInterceptorList);
        }
        if (!interceptors.isEmpty()) {
            interceptorSet.addAll(interceptors);
        }
        return ClientInterceptors.intercept((Channel)channel, (List)Lists.newArrayList((Iterable)interceptorSet));
    }

    protected ManagedChannel newManagedChannel(String name) {
        NettyChannelBuilder builder = (NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)name).loadBalancerFactory(this.loadBalancerFactory)).nameResolverFactory(this.nameResolverFactory);
        this.configure(builder, name);
        return builder.build();
    }

    protected final GrpcChannelProperties getPropertiesFor(String name) {
        return this.properties.getChannel(name);
    }

    protected void configure(NettyChannelBuilder builder, String name) {
        this.configureKeepAlive(builder, name);
        this.configureSecurity(builder, name);
        this.configureLimits(builder, name);
        this.configureCompression(builder, name);
    }

    protected void configureKeepAlive(NettyChannelBuilder builder, String name) {
        GrpcChannelProperties properties = this.getPropertiesFor(name);
        if (properties.isEnableKeepAlive()) {
            builder.keepAliveWithoutCalls(properties.isKeepAliveWithoutCalls()).keepAliveTime(properties.getKeepAliveTime(), TimeUnit.SECONDS).keepAliveTimeout(properties.getKeepAliveTimeout(), TimeUnit.SECONDS);
        }
    }

    protected void configureSecurity(NettyChannelBuilder builder, String name) {
        GrpcChannelProperties properties = this.getPropertiesFor(name);
        NegotiationType negotiationType = properties.getNegotiationType();
        builder.negotiationType(negotiationType);
        if (negotiationType != NegotiationType.PLAINTEXT) {
            String trustCertCollectionPath;
            GrpcChannelProperties.Security security = properties.getSecurity();
            String authorityOverwrite = security.getAuthorityOverride();
            if (authorityOverwrite != null && !authorityOverwrite.isEmpty()) {
                builder.overrideAuthority(authorityOverwrite);
            }
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
            if (security.isClientAuthEnabled()) {
                File keyCertChainFile = this.toCheckedFile("keyCertChain", security.getCertificateChainPath());
                File privateKeyFile = this.toCheckedFile("privateKey", security.getPrivateKeyPath());
                sslContextBuilder.keyManager(keyCertChainFile, privateKeyFile);
            }
            if ((trustCertCollectionPath = security.getTrustCertCollectionPath()) != null && !trustCertCollectionPath.isEmpty()) {
                File trustCertCollectionFile = this.toCheckedFile("trustCertCollection", trustCertCollectionPath);
                sslContextBuilder.trustManager(trustCertCollectionFile);
            }
            try {
                builder.sslContext(sslContextBuilder.build());
            }
            catch (SSLException e) {
                throw new IllegalStateException("Failed to create ssl context for grpc client", e);
            }
        }
    }

    private File toCheckedFile(String context, String path) {
        if (path == null || path.trim().isEmpty()) {
            throw new IllegalArgumentException(context + " path cannot be null or blank");
        }
        File file = new File(path);
        if (!file.isFile()) {
            String message = context + " file does not exist or path does not refer to a file: '" + file.getPath() + "'";
            if (!file.isAbsolute()) {
                message = message + " (" + file.getAbsolutePath() + ")";
            }
            throw new IllegalArgumentException(message);
        }
        return file;
    }

    protected void configureLimits(NettyChannelBuilder builder, String name) {
        GrpcChannelProperties properties = this.getPropertiesFor(name);
        Integer maxInboundMessageSize = properties.getMaxInboundMessageSize();
        if (maxInboundMessageSize != null) {
            builder.maxInboundMessageSize(maxInboundMessageSize.intValue());
        }
    }

    protected void configureCompression(NettyChannelBuilder builder, String name) {
        GrpcChannelProperties properties = this.getPropertiesFor(name);
        if (properties.isFullStreamDecompression()) {
            builder.enableFullStreamDecompression();
        }
    }

    @Override
    @PreDestroy
    public synchronized void close() throws InterruptedException {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        for (ManagedChannel channel : this.channels.values()) {
            channel.shutdown();
        }
        for (ManagedChannel channel : this.channels.values()) {
            int i = 0;
            do {
                log.debug("Awaiting channel shutdown: {} ({}s)", (Object)channel, (Object)i++);
            } while (!channel.awaitTermination(1L, TimeUnit.SECONDS));
        }
        int channelCount = this.channels.size();
        this.channels.clear();
        log.debug("GrpcCannelFactory closed (including {} channels)", (Object)channelCount);
    }
}

