/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannel;
import io.grpc.NameResolver;
import io.grpc.netty.NettyChannelBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.devh.springboot.autoconfigure.grpc.client.AddressChannelResolverFactory;
import net.devh.springboot.autoconfigure.grpc.client.GlobalClientInterceptorRegistry;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelFactory;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelProperties;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelsProperties;

public class AddressChannelFactory
implements GrpcChannelFactory {
    private final GrpcChannelsProperties properties;
    private final LoadBalancer.Factory loadBalancerFactory;
    private final NameResolver.Factory nameResolverFactory;
    private final GlobalClientInterceptorRegistry globalClientInterceptorRegistry;

    public AddressChannelFactory(GrpcChannelsProperties properties, LoadBalancer.Factory loadBalancerFactory, GlobalClientInterceptorRegistry globalClientInterceptorRegistry) {
        this.properties = properties;
        this.loadBalancerFactory = loadBalancerFactory;
        this.nameResolverFactory = new AddressChannelResolverFactory(properties);
        this.globalClientInterceptorRegistry = globalClientInterceptorRegistry;
    }

    @Override
    public Channel createChannel(String name) {
        return this.createChannel(name, null);
    }

    @Override
    public Channel createChannel(String name, List<ClientInterceptor> interceptors) {
        GrpcChannelProperties channelProperties = this.properties.getChannel(name);
        NettyChannelBuilder builder = (NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)name).loadBalancerFactory(this.loadBalancerFactory)).nameResolverFactory(this.nameResolverFactory);
        if (this.properties.getChannel(name).isPlaintext()) {
            builder.usePlaintext();
        }
        if (channelProperties.isEnableKeepAlive()) {
            builder.keepAliveWithoutCalls(channelProperties.isKeepAliveWithoutCalls()).keepAliveTime(channelProperties.getKeepAliveTime(), TimeUnit.SECONDS).keepAliveTimeout(channelProperties.getKeepAliveTimeout(), TimeUnit.SECONDS);
        }
        if (channelProperties.getMaxInboundMessageSize() > 0) {
            builder.maxInboundMessageSize(channelProperties.getMaxInboundMessageSize());
        }
        ManagedChannel channel = builder.build();
        List<ClientInterceptor> globalInterceptorList = this.globalClientInterceptorRegistry.getClientInterceptors();
        HashSet interceptorSet = Sets.newHashSet();
        if (globalInterceptorList != null && !globalInterceptorList.isEmpty()) {
            interceptorSet.addAll(globalInterceptorList);
        }
        if (interceptors != null && !interceptors.isEmpty()) {
            interceptorSet.addAll(interceptors);
        }
        return ClientInterceptors.intercept((Channel)channel, (List)Lists.newArrayList((Iterable)interceptorSet));
    }
}

