/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.client;

import io.grpc.LoadBalancer;
import io.grpc.util.RoundRobinLoadBalancerFactory;
import net.devh.springboot.autoconfigure.grpc.client.AddressChannelFactory;
import net.devh.springboot.autoconfigure.grpc.client.DiscoveryClientChannelFactory;
import net.devh.springboot.autoconfigure.grpc.client.GlobalClientInterceptorRegistry;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelFactory;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelsProperties;
import net.devh.springboot.autoconfigure.grpc.client.GrpcClient;
import net.devh.springboot.autoconfigure.grpc.client.GrpcClientBeanPostProcessor;
import net.devh.springboot.autoconfigure.grpc.client.MetadataInjector;
import net.devh.springboot.autoconfigure.grpc.client.TraceClientInterceptor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties
@ConditionalOnClass(value={GrpcChannelFactory.class})
public class GrpcClientAutoConfiguration {
    @ConditionalOnMissingBean
    @Bean
    public GrpcChannelsProperties grpcChannelsProperties() {
        return new GrpcChannelsProperties();
    }

    @Bean
    public GlobalClientInterceptorRegistry globalClientInterceptorRegistry() {
        return new GlobalClientInterceptorRegistry();
    }

    @ConditionalOnMissingBean
    @Bean
    public LoadBalancer.Factory grpcLoadBalancerFactory() {
        return RoundRobinLoadBalancerFactory.getInstance();
    }

    @ConditionalOnMissingBean(value={GrpcChannelFactory.class}, type={"org.springframework.cloud.client.discovery.DiscoveryClient"})
    @Bean
    public GrpcChannelFactory addressChannelFactory(GrpcChannelsProperties channels, LoadBalancer.Factory loadBalancerFactory, GlobalClientInterceptorRegistry globalClientInterceptorRegistry) {
        return new AddressChannelFactory(channels, loadBalancerFactory, globalClientInterceptorRegistry);
    }

    @Bean
    @ConditionalOnClass(value={GrpcClient.class})
    public GrpcClientBeanPostProcessor grpcClientBeanPostProcessor() {
        return new GrpcClientBeanPostProcessor();
    }

    @Configuration
    @ConditionalOnProperty(value={"spring.sleuth.scheduled.enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={Tracer.class})
    protected static class TraceClientAutoConfiguration {
        protected TraceClientAutoConfiguration() {
        }

        @Bean
        public BeanPostProcessor clientInterceptorPostProcessor(GlobalClientInterceptorRegistry registry) {
            return new ClientInterceptorPostProcessor(registry);
        }

        private static class ClientInterceptorPostProcessor
        implements BeanPostProcessor {
            private GlobalClientInterceptorRegistry registry;

            public ClientInterceptorPostProcessor(GlobalClientInterceptorRegistry registry) {
                this.registry = registry;
            }

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof Tracer) {
                    this.registry.addClientInterceptors(new TraceClientInterceptor((Tracer)bean, new MetadataInjector()));
                }
                return bean;
            }
        }
    }

    @Configuration
    @ConditionalOnBean(value={DiscoveryClient.class})
    protected static class DiscoveryGrpcClientAutoConfiguration {
        protected DiscoveryGrpcClientAutoConfiguration() {
        }

        @ConditionalOnMissingBean
        @Bean
        public GrpcChannelFactory discoveryClientChannelFactory(GrpcChannelsProperties channels, DiscoveryClient discoveryClient, LoadBalancer.Factory loadBalancerFactory, GlobalClientInterceptorRegistry globalClientInterceptorRegistry) {
            return new DiscoveryClientChannelFactory(channels, discoveryClient, loadBalancerFactory, globalClientInterceptorRegistry);
        }
    }
}

