/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.client;

import io.grpc.Attributes;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import net.devh.springboot.autoconfigure.grpc.client.DiscoveryClientChannelFactory;
import net.devh.springboot.autoconfigure.grpc.client.DiscoveryClientNameResolver;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class DiscoveryClientResolverFactory
extends NameResolverProvider {
    private final DiscoveryClient client;
    private DiscoveryClientChannelFactory discoveryClientChannelFactory;

    public DiscoveryClientResolverFactory(DiscoveryClient client, DiscoveryClientChannelFactory discoveryClientChannelFactory) {
        this.client = client;
        this.discoveryClientChannelFactory = discoveryClientChannelFactory;
    }

    @Nullable
    public NameResolver newNameResolver(URI targetUri, Attributes params) {
        DiscoveryClientNameResolver discoveryClientNameResolver = new DiscoveryClientNameResolver(targetUri.toString(), this.client, params, (SharedResourceHolder.Resource<ScheduledExecutorService>)GrpcUtil.TIMER_SERVICE, (SharedResourceHolder.Resource<ExecutorService>)GrpcUtil.SHARED_CHANNEL_EXECUTOR);
        this.discoveryClientChannelFactory.addDiscoveryClientNameResolver(discoveryClientNameResolver);
        return discoveryClientNameResolver;
    }

    public String getDefaultScheme() {
        return "discoveryClient";
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 5;
    }
}

