/*
 * Decompiled with CFR 0.152.
 */
package net.crystalapps.permission.runtime.library.core;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.crystalapps.permission.runtime.library.callbacks.PermissionCallback;
import net.crystalapps.permission.runtime.library.callbacks.PermissionSettingCallback;
import net.crystalapps.permission.runtime.library.core.AppSettingFragment;
import net.crystalapps.permission.runtime.library.core.PermsFragment;
import net.crystalapps.permission.runtime.library.models.Perm;
import net.crystalapps.permission.runtime.library.utils.ObjectUtil;
import net.crystalapps.permission.runtime.library.utils.PersistentUtil;
import net.crystalapps.permission.runtime.library.utils.ProxyUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0006\u001a\u0002H\u0007\"\b\b\u0000\u0010\b*\u00020\t\"\u0004\b\u0001\u0010\u00072\u0006\u0010\n\u001a\u0002H\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00070\f\u00a2\u0006\u0002\u0010\rJ1\u0010\u0006\u001a\u0002H\u0007\"\b\b\u0000\u0010\b*\u00020\u000e\"\u0004\b\u0001\u0010\u00072\u0006\u0010\n\u001a\u0002H\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00070\f\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J;\u0010\u0015\u001a\u00020\u0016\"\b\b\u0000\u0010\b*\u00020\t2\u0006\u0010\n\u001a\u0002H\b2\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\b0\u001b\u00a2\u0006\u0002\u0010\u001cJ;\u0010\u0015\u001a\u00020\u0016\"\b\b\u0000\u0010\b*\u00020\u000e2\u0006\u0010\n\u001a\u0002H\b2\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\b0\u001b\u00a2\u0006\u0002\u0010\u001dJ3\u0010\u0015\u001a\u00020\u0016\"\b\b\u0000\u0010\b*\u00020\t2\u0006\u0010\n\u001a\u0002H\b2\u0006\u0010\u0017\u001a\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\b0\u001b\u00a2\u0006\u0002\u0010\u001eJ3\u0010\u0015\u001a\u00020\u0016\"\b\b\u0000\u0010\b*\u00020\u000e2\u0006\u0010\n\u001a\u0002H\b2\u0006\u0010\u0017\u001a\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\b0\u001b\u00a2\u0006\u0002\u0010\u001fJA\u0010\u0015\u001a\u00020\u0016\"\u0004\b\u0000\u0010\b2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010\n\u001a\u0002H\b2\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\b0\u001bH\u0002\u00a2\u0006\u0002\u0010!J;\u0010\"\u001a\u00020\u0016\"\b\b\u0000\u0010\b*\u00020\t2\u0006\u0010\n\u001a\u0002H\b2\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\b0#\u00a2\u0006\u0002\u0010$J;\u0010\"\u001a\u00020\u0016\"\b\b\u0000\u0010\b*\u00020\u000e2\u0006\u0010\n\u001a\u0002H\b2\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\b0#\u00a2\u0006\u0002\u0010%J3\u0010\"\u001a\u00020\u0016\"\b\b\u0000\u0010\b*\u00020\t2\u0006\u0010\n\u001a\u0002H\b2\u0006\u0010\u0017\u001a\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\b0#\u00a2\u0006\u0002\u0010&J3\u0010\"\u001a\u00020\u0016\"\b\b\u0000\u0010\b*\u00020\u000e2\u0006\u0010\n\u001a\u0002H\b2\u0006\u0010\u0017\u001a\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\b0#\u00a2\u0006\u0002\u0010'JA\u0010\"\u001a\u00020\u0016\"\u0004\b\u0000\u0010\b2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010\n\u001a\u0002H\b2\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\b0#H\u0002\u00a2\u0006\u0002\u0010(R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006)"}, d2={"Lnet/crystalapps/permission/runtime/library/core/RuntimePermission;", "", "()V", "isPermissionRequired", "", "()Z", "ask", "S", "T", "Landroidx/fragment/app/Fragment;", "caller", "service", "Ljava/lang/Class;", "(Landroidx/fragment/app/Fragment;Ljava/lang/Class;)Ljava/lang/Object;", "Landroidx/fragment/app/FragmentActivity;", "(Landroidx/fragment/app/FragmentActivity;Ljava/lang/Class;)Ljava/lang/Object;", "hasPermission", "context", "Landroid/content/Context;", "perm", "", "openAppSettingIntent", "", "permType", "requestCode", "", "callback", "Lnet/crystalapps/permission/runtime/library/callbacks/PermissionSettingCallback;", "(Landroidx/fragment/app/Fragment;Ljava/lang/String;ILnet/crystalapps/permission/runtime/library/callbacks/PermissionSettingCallback;)V", "(Landroidx/fragment/app/FragmentActivity;Ljava/lang/String;ILnet/crystalapps/permission/runtime/library/callbacks/PermissionSettingCallback;)V", "(Landroidx/fragment/app/Fragment;Ljava/lang/String;Lnet/crystalapps/permission/runtime/library/callbacks/PermissionSettingCallback;)V", "(Landroidx/fragment/app/FragmentActivity;Ljava/lang/String;Lnet/crystalapps/permission/runtime/library/callbacks/PermissionSettingCallback;)V", "activity", "(Landroidx/fragment/app/FragmentActivity;Ljava/lang/Object;Ljava/lang/String;ILnet/crystalapps/permission/runtime/library/callbacks/PermissionSettingCallback;)V", "requestPermission", "Lnet/crystalapps/permission/runtime/library/callbacks/PermissionCallback;", "(Landroidx/fragment/app/Fragment;Ljava/lang/String;ILnet/crystalapps/permission/runtime/library/callbacks/PermissionCallback;)V", "(Landroidx/fragment/app/FragmentActivity;Ljava/lang/String;ILnet/crystalapps/permission/runtime/library/callbacks/PermissionCallback;)V", "(Landroidx/fragment/app/Fragment;Ljava/lang/String;Lnet/crystalapps/permission/runtime/library/callbacks/PermissionCallback;)V", "(Landroidx/fragment/app/FragmentActivity;Ljava/lang/String;Lnet/crystalapps/permission/runtime/library/callbacks/PermissionCallback;)V", "(Landroidx/fragment/app/FragmentActivity;Ljava/lang/Object;Ljava/lang/String;ILnet/crystalapps/permission/runtime/library/callbacks/PermissionCallback;)V", "mint-runtime-permission_release"})
public final class RuntimePermission {
    public static final RuntimePermission INSTANCE;

    public final boolean isPermissionRequired() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public final boolean hasPermission(@NotNull Context context, @NotNull String perm) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)perm, (String)"perm");
        return !this.isPermissionRequired() || ContextCompat.checkSelfPermission((Context)context, (String)perm) == 0;
    }

    public final <T extends Fragment> void requestPermission(@NotNull T caller, @NotNull String permType, @NotNull PermissionCallback<T> callback) {
        Intrinsics.checkParameterIsNotNull(caller, (String)"caller");
        Intrinsics.checkParameterIsNotNull((Object)permType, (String)"permType");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.requestPermission(caller, permType, 1947, callback);
    }

    public final <T extends Fragment> void requestPermission(@NotNull T caller, @NotNull String permType, int requestCode, @NotNull PermissionCallback<T> callback) {
        Intrinsics.checkParameterIsNotNull(caller, (String)"caller");
        Intrinsics.checkParameterIsNotNull((Object)permType, (String)"permType");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        FragmentActivity fragmentActivity = caller.getActivity();
        if (fragmentActivity == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"caller.activity!!");
        this.requestPermission(fragmentActivity, caller, permType, 1947, callback);
    }

    public final <T extends FragmentActivity> void requestPermission(@NotNull T caller, @NotNull String permType, @NotNull PermissionCallback<T> callback) {
        Intrinsics.checkParameterIsNotNull(caller, (String)"caller");
        Intrinsics.checkParameterIsNotNull((Object)permType, (String)"permType");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.requestPermission(caller, permType, 1947, callback);
    }

    public final <T extends FragmentActivity> void requestPermission(@NotNull T caller, @NotNull String permType, int requestCode, @NotNull PermissionCallback<T> callback) {
        Intrinsics.checkParameterIsNotNull(caller, (String)"caller");
        Intrinsics.checkParameterIsNotNull((Object)permType, (String)"permType");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.requestPermission(caller, caller, permType, requestCode, callback);
    }

    private final <T> void requestPermission(FragmentActivity activity, T caller, String permType, int requestCode, PermissionCallback<T> callback) {
        ObjectUtil.INSTANCE.requireNonNull(caller, "caller cannot be null");
        ObjectUtil.INSTANCE.requireNonNull(permType, "permission cannot be null");
        ObjectUtil.INSTANCE.requireNonNull(callback, "callback cannot be null");
        Perm<T> perm = ProxyUtil.INSTANCE.getProxy(permType, requestCode, caller);
        if (this.isPermissionRequired() && !this.hasPermission((Context)activity, permType)) {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)activity), (String)perm.getType()) && !PersistentUtil.INSTANCE.isCameFirst((Context)activity, perm.getType())) {
                callback.onPermanentDenied(perm);
            } else {
                FragmentManager fragmentManager = activity.getSupportFragmentManager();
                Intrinsics.checkExpressionValueIsNotNull((Object)fragmentManager, (String)"activity.supportFragmentManager");
                FragmentManager fragmentManager2 = fragmentManager;
                PermsFragment<?> fragment = PermsFragment.Companion.getInstance(perm, callback);
                fragmentManager2.beginTransaction().add((Fragment)fragment, "PERMS_FRAGMENT").commitNow();
                fragment.requestPermissions(new String[]{perm.getType()}, perm.getRequestCode());
            }
        } else {
            callback.onGranted(perm);
        }
    }

    public final <T extends Fragment> void openAppSettingIntent(@NotNull T caller, @NotNull String permType, @NotNull PermissionSettingCallback<T> callback) {
        Intrinsics.checkParameterIsNotNull(caller, (String)"caller");
        Intrinsics.checkParameterIsNotNull((Object)permType, (String)"permType");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.openAppSettingIntent(caller, permType, 148, callback);
    }

    public final <T extends Fragment> void openAppSettingIntent(@NotNull T caller, @NotNull String permType, int requestCode, @NotNull PermissionSettingCallback<T> callback) {
        Intrinsics.checkParameterIsNotNull(caller, (String)"caller");
        Intrinsics.checkParameterIsNotNull((Object)permType, (String)"permType");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        FragmentActivity fragmentActivity = caller.getActivity();
        if (fragmentActivity == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"caller.activity!!");
        this.openAppSettingIntent(fragmentActivity, caller, permType, requestCode, callback);
    }

    public final <T extends FragmentActivity> void openAppSettingIntent(@NotNull T caller, @NotNull String permType, @NotNull PermissionSettingCallback<T> callback) {
        Intrinsics.checkParameterIsNotNull(caller, (String)"caller");
        Intrinsics.checkParameterIsNotNull((Object)permType, (String)"permType");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.openAppSettingIntent(caller, permType, 148, callback);
    }

    public final <T extends FragmentActivity> void openAppSettingIntent(@NotNull T caller, @NotNull String permType, int requestCode, @NotNull PermissionSettingCallback<T> callback) {
        Intrinsics.checkParameterIsNotNull(caller, (String)"caller");
        Intrinsics.checkParameterIsNotNull((Object)permType, (String)"permType");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.openAppSettingIntent(caller, caller, permType, requestCode, callback);
    }

    private final <T> void openAppSettingIntent(FragmentActivity activity, T caller, String permType, int requestCode, PermissionSettingCallback<T> callback) {
        ObjectUtil.INSTANCE.requireNonNull(caller, "caller cannot be null");
        ObjectUtil.INSTANCE.requireNonNull(permType, "permission cannot be null");
        ObjectUtil.INSTANCE.requireNonNull(callback, "callback cannot be null");
        Perm<T> perm = ProxyUtil.INSTANCE.getProxy(permType, requestCode, caller);
        if (this.isPermissionRequired()) {
            FragmentManager fragmentManager = activity.getSupportFragmentManager();
            Intrinsics.checkExpressionValueIsNotNull((Object)fragmentManager, (String)"activity.supportFragmentManager");
            FragmentManager fragmentManager2 = fragmentManager;
            AppSettingFragment<?> fragment = AppSettingFragment.Companion.getInstance(perm, callback);
            fragmentManager2.beginTransaction().add((Fragment)fragment, "APP_SETTING_FRAGMENT").commitNow();
            Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts((String)"package", (String)activity.getPackageName(), null));
            fragment.startActivityForResult(intent, perm.getRequestCode());
        } else {
            callback.onGranted(perm);
        }
    }

    public final <T extends Fragment, S> S ask(@NotNull T caller, @NotNull Class<S> service) {
        Intrinsics.checkParameterIsNotNull(caller, (String)"caller");
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        FragmentActivity fragmentActivity = caller.getActivity();
        if (fragmentActivity == null) {
            Intrinsics.throwNpe();
        }
        return this.ask(fragmentActivity, service);
    }

    public final <T extends FragmentActivity, S> S ask(@NotNull T caller, @NotNull Class<S> service) {
        Intrinsics.checkParameterIsNotNull(caller, (String)"caller");
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        return ProxyUtil.INSTANCE.getDynamicProxy(caller, service);
    }

    private RuntimePermission() {
    }

    static {
        RuntimePermission runtimePermission;
        INSTANCE = runtimePermission = new RuntimePermission();
    }
}

