/*
 * Decompiled with CFR 0.152.
 */
package net.crystalapps.permission.runtime.library.core;

import androidx.fragment.app.FragmentActivity;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.crystalapps.permission.runtime.library.annotations.PermanentDenied;
import net.crystalapps.permission.runtime.library.annotations.PermissionContainer;
import net.crystalapps.permission.runtime.library.annotations.PermissionFailure;
import net.crystalapps.permission.runtime.library.annotations.Permit;
import net.crystalapps.permission.runtime.library.callbacks.PermanentDeniedHandler;
import net.crystalapps.permission.runtime.library.callbacks.PermissionCallback;
import net.crystalapps.permission.runtime.library.callbacks.PermissionFailureHandler;
import net.crystalapps.permission.runtime.library.callbacks.PermissionSettingCallback;
import net.crystalapps.permission.runtime.library.callbacks.Request;
import net.crystalapps.permission.runtime.library.callbacks.SettingOpener;
import net.crystalapps.permission.runtime.library.config.RuntimePermissionConfig;
import net.crystalapps.permission.runtime.library.core.DynamicPermProxyInvocationHandler;
import net.crystalapps.permission.runtime.library.core.RuntimePermission;
import net.crystalapps.permission.runtime.library.core.ServiceMethod;
import net.crystalapps.permission.runtime.library.models.Perm;
import net.crystalapps.permission.runtime.library.utils.ObjectUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u00020\u0004B\u001b\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bJ)\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0002\u0010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0007H\u0002\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007H\u0002J \u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007H\u0002J#\u0010\u0014\u001a\u0004\u0018\u0001H\u0015\"\u0004\b\u0002\u0010\u00152\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0007H\u0002\u00a2\u0006\u0002\u0010\u0016J0\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001bH\u0096\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002R\u0010\u0010\u0005\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lnet/crystalapps/permission/runtime/library/core/DynamicPermProxyInvocationHandler;", "T", "Landroidx/fragment/app/FragmentActivity;", "S", "Ljava/lang/reflect/InvocationHandler;", "act", "service", "Ljava/lang/Class;", "(Landroidx/fragment/app/FragmentActivity;Ljava/lang/Class;)V", "Landroidx/fragment/app/FragmentActivity;", "getAnnotation", "A", "method", "Ljava/lang/reflect/Method;", "clazz", "(Ljava/lang/reflect/Method;Ljava/lang/Class;)Ljava/lang/Object;", "getPermanentDeniedHandler", "Lnet/crystalapps/permission/runtime/library/callbacks/PermanentDeniedHandler;", "getPermissionFailureHandler", "Lnet/crystalapps/permission/runtime/library/callbacks/PermissionFailureHandler;", "initO", "O", "(Ljava/lang/Class;)Ljava/lang/Object;", "invoke", "", "o", "objects", "", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "normalize", "Ljava/util/Queue;", "Lnet/crystalapps/permission/runtime/library/annotations/Permit;", "process", "", "serviceMethod", "Lnet/crystalapps/permission/runtime/library/core/ServiceMethod;", "mint-runtime-permission_release"})
public final class DynamicPermProxyInvocationHandler<T extends FragmentActivity, S>
implements InvocationHandler {
    private final T act;
    private final Class<S> service;

    @Override
    @Nullable
    public Object invoke(@NotNull Object o, @NotNull Method method, @Nullable Object[] objects) {
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Class<?> clazz = method.getReturnType();
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"method.returnType");
        if (Intrinsics.areEqual((Object)clazz.getName(), (Object)"void") ^ true) {
            throw (Throwable)new IllegalStateException("Return type of " + method.getName() + " method should be void");
        }
        if (objects == null) {
            throw (Throwable)new IllegalStateException(Request.class.getName() + " parameter not found in " + method.getName() + " method");
        }
        if (objects.length != 1) {
            throw (Throwable)new IllegalStateException(method.getName() + " method should be contain only 1 parameter");
        }
        if (!(objects[0] instanceof Function)) {
            throw (Throwable)new IllegalArgumentException("Invalid parameter found in " + method.getName() + " method, param type should be " + Request.class.getName());
        }
        if (!method.isAnnotationPresent(Permit.class) && !method.isAnnotationPresent(PermissionContainer.class)) {
            throw (Throwable)new IllegalStateException("Add at least one Permit or PermissionContainer annotation in " + method.getName() + " method");
        }
        ArrayList failedPermissionsList = new ArrayList();
        Object object = objects[0];
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type () -> kotlin.Unit");
        }
        ServiceMethod serviceMethod = new ServiceMethod(this.normalize(method), failedPermissionsList, (Function0<Unit>)((Function0)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)object, (int)0)), this.getPermanentDeniedHandler(method, this.service), this.getPermissionFailureHandler(method, this.service), method);
        this.process(serviceMethod);
        return null;
    }

    private final Queue<Permit> normalize(Method method) {
        LinkedList<Permit> queue = new LinkedList<Permit>();
        if (method.isAnnotationPresent(Permit.class)) {
            queue.add(this.getAnnotation(method, Permit.class));
        }
        if (method.isAnnotationPresent(PermissionContainer.class)) {
            PermissionContainer container = this.getAnnotation(method, PermissionContainer.class);
            Permit[] permitArray = container.value();
            queue.addAll((Collection)Arrays.asList(Arrays.copyOf(permitArray, permitArray.length)));
        }
        return queue;
    }

    private final <A> A getAnnotation(Method method, Class<A> clazz) {
        Object annotation = null;
        for (Annotation anno : method.getDeclaredAnnotations()) {
            if (anno == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.annotation.Annotation");
            }
            if (!Intrinsics.areEqual(anno.annotationType(), clazz)) continue;
            annotation = anno;
        }
        Object object = annotation;
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (A)object;
    }

    private final PermanentDeniedHandler getPermanentDeniedHandler(Method method, Class<S> service) {
        PermanentDeniedHandler permanentDeniedHandler;
        Class<? extends PermanentDeniedHandler> clazz = null;
        if (method.isAnnotationPresent(PermanentDenied.class)) {
            clazz = method.getAnnotation(PermanentDenied.class).value();
        } else if (service.isAnnotationPresent(PermanentDenied.class)) {
            PermanentDenied permanentDenied = service.getAnnotation(PermanentDenied.class);
            Class<? extends PermanentDeniedHandler> clazz2 = clazz = permanentDenied != null ? permanentDenied.value() : null;
        }
        if (clazz != null) {
            PermanentDeniedHandler permanentDeniedHandler2 = ObjectUtil.INSTANCE.requireNonNull(this.initO(clazz));
            if (permanentDeniedHandler2 == null) {
                Intrinsics.throwNpe();
            }
            permanentDeniedHandler = permanentDeniedHandler2;
        } else {
            permanentDeniedHandler = RuntimePermissionConfig.Companion.getInstance().getPermanentDeniedHandler();
        }
        return permanentDeniedHandler;
    }

    private final PermissionFailureHandler getPermissionFailureHandler(Method method, Class<S> service) {
        Object object;
        block7: {
            block6: {
                Class<? extends PermissionFailureHandler> clazz = null;
                if (method.isAnnotationPresent(PermissionFailure.class)) {
                    clazz = method.getAnnotation(PermissionFailure.class).value();
                } else if (service.isAnnotationPresent(PermissionFailure.class)) {
                    PermissionFailure permissionFailure = service.getAnnotation(PermissionFailure.class);
                    clazz = permissionFailure != null ? permissionFailure.value() : null;
                }
                if ((object = clazz) == null) break block6;
                Class<? extends PermissionFailureHandler> clazz2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Class<? extends PermissionFailureHandler> it = clazz2;
                boolean bl3 = false;
                object = this.initO(it);
                if (object != null) break block7;
            }
            object = RuntimePermissionConfig.Companion.getInstance().getPermissionFailureHandler();
        }
        return object;
    }

    private final <O> O initO(Class<O> clazz) {
        try {
            Constructor<O> constructor;
            Constructor<O> constructor2 = constructor = clazz.getDeclaredConstructor(new Class[0]);
            Intrinsics.checkExpressionValueIsNotNull(constructor2, (String)"constructor");
            constructor2.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private final void process(ServiceMethod serviceMethod) {
        Permit permit = serviceMethod.getPermitQueue().poll();
        if (permit != null) {
            RuntimePermission.INSTANCE.requestPermission(this.act, permit.value(), new PermissionCallback<FragmentActivity>(this, serviceMethod, permit){
                final /* synthetic */ DynamicPermProxyInvocationHandler this$0;
                final /* synthetic */ ServiceMethod $serviceMethod;
                final /* synthetic */ Permit $permit;

                public void onGranted(@NotNull Perm<FragmentActivity> perm) {
                    Intrinsics.checkParameterIsNotNull(perm, (String)"perm");
                    DynamicPermProxyInvocationHandler.access$process(this.this$0, this.$serviceMethod);
                }

                public void onDenied(@NotNull Perm<FragmentActivity> perm) {
                    Intrinsics.checkParameterIsNotNull(perm, (String)"perm");
                    if (this.$permit.required()) {
                        this.$serviceMethod.addToFailureList(this.$permit);
                    }
                    DynamicPermProxyInvocationHandler.access$process(this.this$0, this.$serviceMethod);
                }

                public void onPermanentDenied(@NotNull Perm<FragmentActivity> perm) {
                    Intrinsics.checkParameterIsNotNull(perm, (String)"perm");
                    if (this.$permit.required()) {
                        this.$serviceMethod.addToFailureList(this.$permit);
                    }
                    if (this.$permit.checkPermanentDenied()) {
                        this.$serviceMethod.getPermanentDeniedHandler().onHandle(this.$permit, perm.getCaller(), new SettingOpener<FragmentActivity>(this, perm){
                            final /* synthetic */ process.1 this$0;
                            final /* synthetic */ Perm $perm;

                            public void open(@NotNull FragmentActivity caller, @NotNull String permission) {
                                Intrinsics.checkParameterIsNotNull((Object)caller, (String)"caller");
                                Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
                                RuntimePermission.INSTANCE.openAppSettingIntent((FragmentActivity)this.$perm.getCaller(), this.$perm.getType(), new PermissionSettingCallback<FragmentActivity>(this){
                                    final /* synthetic */ process.onPermanentDenied.1 this$0;

                                    public void onGranted(@NotNull Perm<FragmentActivity> perm) {
                                        Intrinsics.checkParameterIsNotNull(perm, (String)"perm");
                                        if (this.this$0.this$0.$permit.required()) {
                                            this.this$0.this$0.$serviceMethod.removeToFailureList(this.this$0.this$0.$permit);
                                        }
                                        DynamicPermProxyInvocationHandler.access$process(this.this$0.this$0.this$0, this.this$0.this$0.$serviceMethod);
                                    }

                                    public void onDenied(@NotNull Perm<FragmentActivity> perm) {
                                        Intrinsics.checkParameterIsNotNull(perm, (String)"perm");
                                        DynamicPermProxyInvocationHandler.access$process(this.this$0.this$0.this$0, this.this$0.this$0.$serviceMethod);
                                    }
                                    {
                                        this.this$0 = $outer;
                                    }
                                });
                            }

                            public void doNothing(@NotNull FragmentActivity caller, @NotNull String permission) {
                                Intrinsics.checkParameterIsNotNull((Object)caller, (String)"caller");
                                Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
                                DynamicPermProxyInvocationHandler.access$process(this.this$0.this$0, this.this$0.$serviceMethod);
                            }
                            {
                                this.this$0 = $outer;
                                this.$perm = $captured_local_variable$1;
                            }
                        });
                    } else {
                        DynamicPermProxyInvocationHandler.access$process(this.this$0, this.$serviceMethod);
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$serviceMethod = $captured_local_variable$1;
                    this.$permit = $captured_local_variable$2;
                }
            });
        } else if (!serviceMethod.getFailurePermissionList().isEmpty()) {
            PermissionFailureHandler failureHandler;
            PermissionFailureHandler permissionFailureHandler = failureHandler = serviceMethod.getPermissionFailureHandler();
            if (permissionFailureHandler != null) {
                permissionFailureHandler.onFailed(serviceMethod.getFailurePermissionList(), (FragmentActivity)this.act, serviceMethod.getMethod());
            }
        } else {
            serviceMethod.getCallback().invoke();
        }
    }

    public DynamicPermProxyInvocationHandler(@NotNull T act, @NotNull Class<S> service) {
        Intrinsics.checkParameterIsNotNull(act, (String)"act");
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        this.act = act;
        this.service = service;
    }

    public static final /* synthetic */ void access$process(DynamicPermProxyInvocationHandler $this, ServiceMethod serviceMethod) {
        $this.process(serviceMethod);
    }
}

