/*
 * Decompiled with CFR 0.152.
 */
package net.crystalapps.permission.runtime.library.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Queue;
import net.crystalapps.permission.runtime.library.annotations.Permit;
import net.crystalapps.permission.runtime.library.callbacks.PermanentDeniedHandler;
import net.crystalapps.permission.runtime.library.callbacks.PermissionFailureHandler;
import net.crystalapps.permission.runtime.library.callbacks.Request;

class ServiceMethod {
    @NonNull
    private final Queue<Permit> permitQueue;
    @NonNull
    private final List<Permit> failurePermissionList;
    @NonNull
    private final Request request;
    @NonNull
    private final PermanentDeniedHandler permanentDeniedHandler;
    @Nullable
    private final PermissionFailureHandler permissionFailureHandler;
    @NonNull
    private final Method method;

    ServiceMethod(@NonNull Queue<Permit> permitQueue, @NonNull List<Permit> failurePermissionList, @NonNull Request request, @NonNull PermanentDeniedHandler permanentDeniedHandler, @Nullable PermissionFailureHandler permissionFailureHandler, @NonNull Method method) {
        this.permitQueue = permitQueue;
        this.failurePermissionList = failurePermissionList;
        this.request = request;
        this.permanentDeniedHandler = permanentDeniedHandler;
        this.permissionFailureHandler = permissionFailureHandler;
        this.method = method;
    }

    @NonNull
    Queue<Permit> getPermitQueue() {
        return this.permitQueue;
    }

    @NonNull
    List<Permit> getFailurePermissionList() {
        return this.failurePermissionList;
    }

    @NonNull
    Request getRequest() {
        return this.request;
    }

    @NonNull
    PermanentDeniedHandler getPermanentDeniedHandler() {
        return this.permanentDeniedHandler;
    }

    @Nullable
    PermissionFailureHandler getPermissionFailureHandler() {
        return this.permissionFailureHandler;
    }

    @NonNull
    public Method getMethod() {
        return this.method;
    }

    void addToFailureList(@NonNull Permit permit) {
        this.failurePermissionList.add(permit);
    }

    void removeToFailureList(@NonNull Permit permit) {
        this.failurePermissionList.remove(permit);
    }
}

