/*
 * Decompiled with CFR 0.152.
 */
package net.crystalapps.permission.runtime.library.core;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import net.crystalapps.permission.runtime.library.callbacks.PermissionCallback;
import net.crystalapps.permission.runtime.library.callbacks.PermissionSettingCallback;
import net.crystalapps.permission.runtime.library.core.AppSettingFragment;
import net.crystalapps.permission.runtime.library.core.PermsFragment;
import net.crystalapps.permission.runtime.library.models.Perm;
import net.crystalapps.permission.runtime.library.utils.ObjectUtil;
import net.crystalapps.permission.runtime.library.utils.PersistentUtil;
import net.crystalapps.permission.runtime.library.utils.ProxyUtil;

public class RuntimePermission {
    public static boolean isPermissionRequired() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public static boolean hasPermission(@NonNull Context context, String perm) {
        return !RuntimePermission.isPermissionRequired() || ContextCompat.checkSelfPermission((Context)context, (String)perm) == 0;
    }

    public static <T extends Fragment> void requestPermission(@NonNull T caller, String permType, @NonNull PermissionCallback<T> callback) {
        RuntimePermission.requestPermission(caller, permType, 1947, callback);
    }

    public static <T extends Fragment> void requestPermission(@NonNull T caller, String permType, int requestCode, @NonNull PermissionCallback<T> callback) {
        RuntimePermission.requestPermission(caller.getActivity(), caller, permType, 1947, callback);
    }

    public static <T extends FragmentActivity> void requestPermission(@NonNull T caller, String permType, @NonNull PermissionCallback<T> callback) {
        RuntimePermission.requestPermission(caller, permType, 1947, callback);
    }

    public static <T extends FragmentActivity> void requestPermission(@NonNull T caller, @NonNull String permType, int requestCode, @NonNull PermissionCallback<T> callback) {
        RuntimePermission.requestPermission(caller, caller, permType, requestCode, callback);
    }

    private static <T> void requestPermission(@NonNull FragmentActivity activity, @NonNull T caller, @NonNull String permType, int requestCode, @NonNull PermissionCallback<T> callback) {
        ObjectUtil.requireNonNull(caller, "caller cannot be null");
        ObjectUtil.requireNonNull(permType, "permission cannot be null");
        ObjectUtil.requireNonNull(callback, "callback cannot be null");
        Perm<T> perm = ProxyUtil.getProxy(permType, requestCode, caller);
        if (RuntimePermission.isPermissionRequired() && !RuntimePermission.hasPermission((Context)activity, permType)) {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)perm.getType()) && !PersistentUtil.isCameFirst((Context)activity, perm.getType())) {
                callback.onPermanentDenied(perm);
            } else {
                FragmentManager fragmentManager = activity.getSupportFragmentManager();
                PermsFragment fragment = PermsFragment.getInstance(perm, callback);
                fragmentManager.beginTransaction().add((Fragment)fragment, "PERMS_FRAGMENT").commitNow();
                fragment.requestPermissions(new String[]{perm.getType()}, perm.getRequestCode());
            }
        } else {
            callback.onGranted(perm);
        }
    }

    public static <T extends Fragment> void openAppSettingIntent(@NonNull T caller, @NonNull String permType, @NonNull PermissionSettingCallback<T> callback) {
        RuntimePermission.openAppSettingIntent(caller, permType, 148, callback);
    }

    public static <T extends Fragment> void openAppSettingIntent(@NonNull T caller, @NonNull String permType, int requestCode, @NonNull PermissionSettingCallback<T> callback) {
        RuntimePermission.openAppSettingIntent(caller.getActivity(), caller, permType, requestCode, callback);
    }

    public static <T extends FragmentActivity> void openAppSettingIntent(@NonNull T caller, @NonNull String permType, @NonNull PermissionSettingCallback<T> callback) {
        RuntimePermission.openAppSettingIntent(caller, permType, 148, callback);
    }

    public static <T extends FragmentActivity> void openAppSettingIntent(@NonNull T caller, @NonNull String permType, int requestCode, @NonNull PermissionSettingCallback<T> callback) {
        RuntimePermission.openAppSettingIntent(caller, caller, permType, requestCode, callback);
    }

    private static <T> void openAppSettingIntent(@NonNull FragmentActivity activity, @NonNull T caller, @NonNull String permType, int requestCode, @NonNull PermissionSettingCallback<T> callback) {
        ObjectUtil.requireNonNull(caller, "caller cannot be null");
        ObjectUtil.requireNonNull(permType, "permission cannot be null");
        ObjectUtil.requireNonNull(callback, "callback cannot be null");
        Perm<T> perm = ProxyUtil.getProxy(permType, requestCode, caller);
        if (RuntimePermission.isPermissionRequired()) {
            FragmentManager fragmentManager = activity.getSupportFragmentManager();
            AppSettingFragment fragment = AppSettingFragment.getInstance(perm, callback);
            fragmentManager.beginTransaction().add((Fragment)fragment, "APP_SETTING_FRAGMENT").commitNow();
            Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts((String)"package", (String)activity.getPackageName(), null));
            fragment.startActivityForResult(intent, perm.getRequestCode());
        } else {
            callback.onGranted(perm);
        }
    }

    public static <T extends Fragment, S> S ask(@NonNull T caller, @NonNull Class<S> service) {
        return RuntimePermission.ask(caller.getActivity(), service);
    }

    public static <T extends FragmentActivity, S> S ask(@NonNull T caller, @NonNull Class<S> service) {
        return ProxyUtil.getDynamicProxy(caller, service);
    }
}

