/*
 * Decompiled with CFR 0.152.
 */
package net.crystalapps.permission.runtime.library.core;

import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import java.util.Objects;
import net.crystalapps.permission.runtime.library.callbacks.PermissionSettingCallback;
import net.crystalapps.permission.runtime.library.core.RuntimePermission;
import net.crystalapps.permission.runtime.library.models.Perm;

public class AppSettingFragment<T>
extends Fragment {
    private Perm<T> perm;
    private PermissionSettingCallback<T> callback;

    public void onSaveInstanceState(@NonNull Bundle outState) {
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (RuntimePermission.hasPermission(Objects.requireNonNull(this.getContext()), this.perm.getType())) {
            this.callback.onGranted(this.perm);
        } else {
            this.callback.onDenied(this.perm);
        }
        FragmentManager fragmentManager = this.getFragmentManager();
        if (fragmentManager != null) {
            fragmentManager.beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
        }
    }

    public static <T> AppSettingFragment getInstance(@NonNull Perm<T> perm, @NonNull PermissionSettingCallback<T> callback) {
        AppSettingFragment<T> fragment = new AppSettingFragment<T>();
        fragment.perm = perm;
        fragment.callback = callback;
        return fragment;
    }
}

