/*
 * Decompiled with CFR 0.152.
 */
package net.cpacm.moneyview;

import android.text.TextUtils;
import java.text.DecimalFormat;

public class SplitText {
    private String text;
    private boolean isNumber;
    private int startPosition;
    private int pointPosition;

    public SplitText(String text) {
        this.text = text;
        this.isNumber = this.judgeNumber();
    }

    public SplitText(String text, boolean isNumber) {
        this.text = text;
        this.isNumber = isNumber;
    }

    public int length() {
        if (TextUtils.isEmpty((CharSequence)this.text)) {
            return 0;
        }
        return this.text.length();
    }

    public boolean judgeNumber() {
        this.pointPosition = -1;
        int point = 0;
        for (int i = 0; i < this.length(); ++i) {
            if (this.text.charAt(i) == '.') {
                this.pointPosition = i;
                ++point;
                continue;
            }
            if (Character.isDigit(this.text.charAt(i))) continue;
            return false;
        }
        if (point > 1) {
            this.pointPosition = -1;
            return false;
        }
        return true;
    }

    public int getPointPosition() {
        this.pointPosition = -1;
        for (int i = 0; i < this.length(); ++i) {
            if (this.text.charAt(i) != '.') continue;
            this.pointPosition = i;
            break;
        }
        return this.pointPosition;
    }

    public String format(String format) {
        if (this.isNumber && !TextUtils.isEmpty((CharSequence)format)) {
            DecimalFormat decimalFormat = new DecimalFormat(format);
            decimalFormat.applyPattern(format);
            this.text = decimalFormat.format(Double.valueOf(this.text));
        }
        return this.text;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setIsNumber(boolean isNumber) {
        this.isNumber = isNumber;
    }

    public boolean isNumber() {
        return this.isNumber;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int startPosition) {
        this.startPosition = startPosition;
    }
}

