/*
 * Decompiled with CFR 0.152.
 */
package net.cpacm.moneyview;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.TypefaceSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import net.cpacm.library.R;
import net.cpacm.moneyview.SplitText;

public class MoneyTextView
extends TextView {
    private Context mContext;
    CustomTypefaceSpan customTypefaceSpan;
    private float moneyRate;
    private int moneyColor;
    private MoneyFormat moneyFormat;
    private MoneyMode moneyMode;
    private String moneyText;
    private String moneyFont;
    private String symbol;
    private float symbolRate;
    private float decimalRate;
    private List<SplitText> textList;

    private MoneyTextView(Context context) {
        super(context);
        this.init(context, null);
    }

    public MoneyTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MoneyTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public void init(Context context, AttributeSet attrs) {
        this.mContext = context;
        this.textList = new ArrayList<SplitText>();
        TypedArray typeArray = context.obtainStyledAttributes(attrs, R.styleable.MoneyTextView);
        this.moneyColor = typeArray.getColor(R.styleable.MoneyTextView_moneyColor, this.getTextColors().getDefaultColor());
        this.moneyRate = typeArray.getFloat(R.styleable.MoneyTextView_moneyRate, 1.0f);
        this.moneyMode = MoneyMode.getModeById(typeArray.getInteger(R.styleable.MoneyTextView_moneyMode, 0));
        this.moneyFormat = MoneyFormat.getFormatById(typeArray.getInteger(R.styleable.MoneyTextView_moneyFormat, 0));
        this.moneyText = typeArray.getString(R.styleable.MoneyTextView_moneyText);
        this.moneyFont = typeArray.getString(R.styleable.MoneyTextView_moneyFont);
        this.symbol = typeArray.getString(R.styleable.MoneyTextView_symbol);
        if (TextUtils.isEmpty((CharSequence)this.symbol)) {
            this.symbol = "";
        }
        this.symbolRate = typeArray.getFloat(R.styleable.MoneyTextView_symbolRate, this.moneyRate);
        this.decimalRate = typeArray.getFloat(R.styleable.MoneyTextView_decimalRate, this.moneyRate);
        if (TextUtils.isEmpty((CharSequence)this.moneyText)) {
            this.moneyText = this.getText().toString();
        }
        typeArray.recycle();
        this.setMoneyText(this.moneyText);
    }

    public void setText(String text) {
        SpannableString spanText = this.dealMoney(text);
        super.setText((CharSequence)spanText);
    }

    public void setMoneyText(String moneyText) {
        this.moneyText = moneyText;
        this.setText(moneyText);
    }

    private SpannableString dealMoney(CharSequence text) {
        SpannableString richStr = new SpannableString((CharSequence)"");
        if (TextUtils.isEmpty((CharSequence)text)) {
            return richStr;
        }
        String str = this.dealText(text.toString());
        switch (this.moneyMode) {
            case ALL: {
                richStr = new SpannableString((CharSequence)str);
                for (SplitText splitText : this.textList) {
                    richStr = this.setTextFontFamilySpan(richStr, splitText.getStartPosition(), splitText.getStartPosition() + splitText.length());
                    richStr = this.setTextColorSpan(richStr, splitText.getStartPosition(), splitText.getStartPosition() + splitText.length(), this.moneyColor);
                    int length = this.symbol.length();
                    if (length > 0 && splitText.isNumber()) {
                        richStr = this.setRelativeSpan(richStr, splitText.getStartPosition(), splitText.getStartPosition() + length, this.symbolRate);
                        richStr = this.setRelativeSpan(richStr, splitText.getStartPosition() + length, splitText.getStartPosition() + splitText.length(), this.moneyRate);
                    } else {
                        richStr = this.setRelativeSpan(richStr, splitText.getStartPosition(), splitText.getStartPosition() + splitText.length(), this.moneyRate);
                    }
                    if (splitText.getPointPosition() < 0 || splitText.length() <= 0 || !splitText.isNumber()) continue;
                    int dec = splitText.getPointPosition();
                    richStr = this.setRelativeSpan(richStr, splitText.getStartPosition() + dec, splitText.getStartPosition() + splitText.length(), this.decimalRate);
                }
                break;
            }
            case DIGIT: {
                richStr = new SpannableString((CharSequence)str);
                for (SplitText splitText : this.textList) {
                    if (!splitText.isNumber()) continue;
                    richStr = this.setTextFontFamilySpan(richStr, splitText.getStartPosition(), splitText.getStartPosition() + splitText.length());
                    richStr = this.setTextColorSpan(richStr, splitText.getStartPosition(), splitText.getStartPosition() + splitText.length(), this.moneyColor);
                    int length = this.symbol.length();
                    if (length > 0) {
                        richStr = this.setRelativeSpan(richStr, splitText.getStartPosition(), splitText.getStartPosition() + length, this.symbolRate);
                        richStr = this.setRelativeSpan(richStr, splitText.getStartPosition() + length, splitText.getStartPosition() + splitText.length(), this.moneyRate);
                    } else {
                        richStr = this.setRelativeSpan(richStr, splitText.getStartPosition(), splitText.getStartPosition() + splitText.length(), this.moneyRate);
                    }
                    if (splitText.getPointPosition() < 0 || splitText.length() <= 0 || !splitText.isNumber()) continue;
                    int dec = splitText.getPointPosition();
                    richStr = this.setRelativeSpan(richStr, splitText.getStartPosition() + dec, splitText.getStartPosition() + splitText.length(), this.decimalRate);
                }
                break;
            }
        }
        return richStr;
    }

    private String dealText(String text) {
        this.textList.clear();
        String str = "";
        boolean isNum = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isDigit(c) || c == '.') {
                if (!isNum) {
                    isNum = true;
                    if (!TextUtils.isEmpty((CharSequence)str)) {
                        this.textList.add(new SplitText(str, false));
                    }
                    str = "";
                }
                str = str + String.valueOf(c);
                continue;
            }
            if (isNum) {
                isNum = false;
                if (!TextUtils.isEmpty((CharSequence)str)) {
                    this.textList.add(new SplitText(str));
                }
                str = "";
            }
            str = str + String.valueOf(c);
        }
        if (!TextUtils.isEmpty((CharSequence)str)) {
            this.textList.add(new SplitText(str));
        }
        str = "";
        int startPosition = 0;
        for (SplitText splitText : this.textList) {
            splitText.format(this.moneyFormat.getFormat());
            splitText.setStartPosition(startPosition);
            if (splitText.isNumber()) {
                splitText.setText(this.symbol + splitText.getText());
            }
            str = str + splitText.getText();
            startPosition += splitText.length();
        }
        return str;
    }

    public void setMoneyMode(MoneyMode mode) {
        this.moneyMode = mode;
        this.setMoneyText(this.moneyText);
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
        this.setMoneyText(this.moneyText);
    }

    public void setMoneyColor(int color) {
        this.moneyColor = color;
        this.setMoneyText(this.moneyText);
    }

    public void setMoneyRate(float rate) {
        this.moneyRate = rate;
        this.setMoneyText(this.moneyText);
    }

    public void setSymbolRate(float rate) {
        this.symbolRate = rate;
        this.setMoneyText(this.moneyText);
    }

    public void setDecimalRate(float rate) {
        this.decimalRate = rate;
        this.setMoneyText(this.moneyText);
    }

    public void setMoneyFormat(MoneyFormat moneyFormat) {
        this.moneyFormat = moneyFormat;
        this.setMoneyText(this.moneyText);
    }

    public void setMoneyFont(String moneyFont) {
        this.moneyFont = moneyFont;
        this.setMoneyText(this.moneyText);
    }

    public void setMoneyText(float text) {
        this.moneyText = String.valueOf(text);
        this.setText(this.moneyText);
    }

    public void setMoneyText(int text) {
        this.moneyText = String.valueOf(text);
        this.setText(this.moneyText);
    }

    public SpannableString setRelativeSpan(SpannableString spannable, int start, int end, float rate) {
        spannable.setSpan((Object)new RelativeSizeSpan(rate), start, end, 33);
        return spannable;
    }

    public SpannableString setTextFontFamilySpan(SpannableString spannable, int start, int end) {
        if (!TextUtils.isEmpty((CharSequence)this.moneyFont)) {
            AssetManager assertMgr = this.mContext.getAssets();
            try {
                Typeface fontType = Typeface.createFromAsset((AssetManager)assertMgr, (String)this.moneyFont);
                this.customTypefaceSpan = new CustomTypefaceSpan("sans-serif", fontType);
                spannable.setSpan((Object)this.customTypefaceSpan, start, end, 33);
                System.gc();
            }
            catch (RuntimeException e) {
                Log.e((String)"MoneyTextView", (String)"can't find font file from assets");
            }
        }
        return spannable;
    }

    public SpannableString setTextColorSpan(SpannableString spannable, int start, int end, int color) {
        spannable.setSpan((Object)new ForegroundColorSpan(color), start, end, 33);
        return spannable;
    }

    public class CustomTypefaceSpan
    extends TypefaceSpan {
        private final Typeface newType;

        public CustomTypefaceSpan(String family, Typeface type) {
            super(family);
            this.newType = type;
        }

        public void updateDrawState(TextPaint ds) {
            this.applyCustomTypeFace((Paint)ds, this.newType);
        }

        public void updateMeasureState(TextPaint paint) {
            this.applyCustomTypeFace((Paint)paint, this.newType);
        }

        private void applyCustomTypeFace(Paint paint, Typeface tf) {
            Typeface old = paint.getTypeface();
            int oldStyle = old == null ? 0 : old.getStyle();
            int fake = oldStyle & ~tf.getStyle();
            if ((fake & 1) != 0) {
                paint.setFakeBoldText(true);
            }
            if ((fake & 2) != 0) {
                paint.setTextSkewX(-0.25f);
            }
            paint.setTypeface(tf);
        }
    }

    public static enum MoneyMode {
        ALL(0),
        DIGIT(1);

        private int id;

        private MoneyMode(int id) {
            this.id = id;
        }

        public static MoneyMode getModeById(int id) {
            switch (id) {
                case 0: {
                    return ALL;
                }
                case 1: {
                    return DIGIT;
                }
            }
            return ALL;
        }
    }

    public static enum MoneyFormat {
        FORMAT_DISABLE(0, ""),
        FORMAT_INTEGER(1, "#,###"),
        FORMAT_FLOAT(2, "###,##0.00");

        private int id;
        private String format;

        private MoneyFormat(int id, String format) {
            this.id = id;
            this.format = format;
        }

        public static MoneyFormat getFormatById(int id) {
            switch (id) {
                case 0: {
                    return FORMAT_DISABLE;
                }
                case 1: {
                    return FORMAT_INTEGER;
                }
                case 2: {
                    return FORMAT_FLOAT;
                }
            }
            return FORMAT_DISABLE;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }
    }
}

