/*
 * Decompiled with CFR 0.152.
 */
import com.sun.jmx.mbeanserver.JmxMBeanServer;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.Permission;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.RandomAccess;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import sun.management.Agent;
import sun.misc.VMSupport;

public class Capsule
implements Runnable,
InvocationHandler {
    public static final String VERSION = "1.0";
    private static final long START = System.nanoTime();
    private static final Map<String, Object[]> OPTIONS = new LinkedHashMap<String, Object[]>(20);
    private static final Map<String, Object[]> ATTRIBS = new LinkedHashMap<String, Object[]>(60);
    private static Properties PROPERTIES = new Properties(System.getProperties());
    private static final String PROP_JAVA_VERSION = "java.version";
    private static final String PROP_JAVA_HOME = "java.home";
    private static final String PROP_OS_NAME = "os.name";
    private static final String PROP_USER_HOME = "user.home";
    private static final String PROP_JAVA_LIBRARY_PATH = "java.library.path";
    private static final String PROP_FILE_SEPARATOR = "file.separator";
    private static final String PROP_PATH_SEPARATOR = "path.separator";
    private static final String PROP_JAVA_SECURITY_POLICY = "java.security.policy";
    private static final String PROP_JAVA_SECURITY_MANAGER = "java.security.manager";
    private static final String PROP_TMP_DIR = "java.io.tmpdir";
    private static final String ATTR_MANIFEST_VERSION = "Manifest-Version";
    private static final String ATTR_PREMAIN_CLASS = "Premain-Class";
    private static final String ATTR_MAIN_CLASS = "Main-Class";
    private static final String ATTR_CLASS_PATH = "Class-Path";
    private static final String ATTR_IMPLEMENTATION_VERSION = "Implementation-Version";
    private static final String ATTR_IMPLEMENTATION_TITLE = "Implementation-Title";
    private static final String ATTR_IMPLEMENTATION_VENDOR = "Implementation-Vendor";
    private static final String ATTR_IMPLEMENTATION_URL = "Implementation-URL";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final char FILE_SEPARATOR_CHAR = FILE_SEPARATOR.charAt(0);
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static final String OS_WINDOWS = "windows";
    private static final String OS_MACOS = "macos";
    private static final String OS_LINUX = "linux";
    private static final String OS_SOLARIS = "solaris";
    private static final String OS_BSD = "bsd";
    private static final String OS_AIX = "aix";
    private static final String OS_HP_UX = "hp-ux";
    private static final String OS_UNIX = "unix";
    private static final String OS_POSIX = "posix";
    private static final String OS_VMS = "vms";
    private static final String OS = Capsule.getProperty("os.name").toLowerCase();
    private static final Set<String> PLATFORMS = Capsule.immutableSet("windows", "macos", "linux", "solaris", "bsd", "aix", "posix", "unix", "posix", "vms");
    private static final String PLATFORM = Capsule.getOS();
    private static final String ENV_CACHE_DIR = "CAPSULE_CACHE_DIR";
    private static final String ENV_CACHE_NAME = "CAPSULE_CACHE_NAME";
    private static final String CAPSULE_PROP_PREFIX = "capsule.";
    private static final String CACHE_DEFAULT_NAME = "capsule";
    private static final String APP_CACHE_NAME = "apps";
    private static final String LOCK_FILE_NAME = ".lock";
    private static final String TIMESTAMP_FILE_NAME = ".extracted";
    private static final String CACHE_NONE = "NONE";
    private static final String SEPARATOR_DOT = "\\.";
    private static final Path WINDOWS_PROGRAM_FILES_1 = Paths.get("C:", "Program Files");
    private static final Path WINDOWS_PROGRAM_FILES_2 = Paths.get("C:", "Program Files (x86)");
    private static final int WINDOWS_MAX_CMD = 32500;
    private static final ClassLoader MY_CLASSLOADER = Capsule.class.getClassLoader();
    private static final Permission PERM_UNSAFE_OVERRIDE = new RuntimePermission("unsafeOverride");
    private static final int SOCKET_TIMEOUT = 30000;
    private static final int STAGE_NONE = 0;
    private static final int STAGE_LAUNCH = 1;
    private static final int STAGE_LIFTOFF = 2;
    private static final int OPTION_DEFAULT = 0;
    private static final int OPTION_METHOD = 1;
    private static final int OPTION_WRAPPER_ONLY = 2;
    private static final int OPTION_DESC = 3;
    private static final int ATTRIB_TYPE = 0;
    private static final int ATTRIB_DEFAULT = 1;
    private static final int ATTRIB_MODAL = 2;
    private static final int ATTRIB_DESC = 3;
    private static final int MESSAGE_EXIT = 1;
    private static final int MESSAGE_START_JMX = 2;
    private static final int MESSAGE_JMX_URL = 3;
    private static final String PROP_VERSION = Capsule.OPTION("capsule.version", "false", "printVersion", "Prints the capsule and application versions.");
    private static final String PROP_MODES = Capsule.OPTION("capsule.modes", "false", "printModes", "Prints all available capsule modes.");
    private static final String PROP_PRINT_JRES = Capsule.OPTION("capsule.jvms", "false", "printJVMs", "Prints a list of all JVM installations found.");
    private static final String PROP_MERGE = Capsule.OPTION("capsule.merge", null, "mergeCapsules", true, "Merges a wrapper capsule with a wrapped capsule.");
    private static final String PROP_HELP = Capsule.OPTION("capsule.help", "false", "printHelp", "Prints this help message.");
    private static final String PROP_MODE = Capsule.OPTION("capsule.mode", null, null, "Picks the capsule mode to run.");
    private static final String PROP_RESET = Capsule.OPTION("capsule.reset", "false", null, "Resets the capsule cache before launching. The capsule to be re-extracted (if applicable), and other possibly cached files will be recreated.");
    private static final String PROP_LOG_LEVEL = Capsule.OPTION("capsule.log", "quiet", null, "Picks a log level. Must be one of none, quiet, verbose, or debug.");
    private static final String PROP_CAPSULE_JAVA_HOME = Capsule.OPTION("capsule.java.home", null, null, "Sets the location of the Java home (JVM installation directory) to use; If 'current' forces the use of the JVM that launched the capsule.");
    private static final String PROP_CAPSULE_JAVA_CMD = Capsule.OPTION("capsule.java.cmd", null, null, "Sets the path to the Java executable to use.");
    private static final String PROP_JVM_ARGS = Capsule.OPTION("capsule.jvm.args", null, null, "Sets additional JVM arguments to use when running the application.");
    private static final String PROP_PORT = "capsule.port";
    private static final String PROP_ADDRESS = "capsule.address";
    private static final String PROP_TRAMPOLINE = "capsule.trampoline";
    private static final String PROP_PROFILE = "capsule.profile";
    protected static final Map.Entry<String, String> ATTR_APP_NAME = Capsule.ATTRIBUTE("Application-Name", Capsule.T_STRING(), null, false, "The application's name");
    protected static final Map.Entry<String, String> ATTR_APP_ID = Capsule.ATTRIBUTE("Application-Id", Capsule.T_STRING(), null, false, "The application's name");
    protected static final Map.Entry<String, String> ATTR_APP_VERSION = Capsule.ATTRIBUTE("Application-Version", Capsule.T_STRING(), null, false, "The application's version string");
    protected static final Map.Entry<String, List<String>> ATTR_CAPLETS = Capsule.ATTRIBUTE("Caplets", Capsule.T_LIST(Capsule.T_STRING()), null, false, "A list of names of caplet classes -- if embedded in the capsule -- or Maven coordinates of caplet artifacts that will be applied to the capsule in the order they are listed");
    private static final Map.Entry<String, String> ATTR_LOG_LEVEL = Capsule.ATTRIBUTE("Capsule-Log-Level", Capsule.T_STRING(), null, false, "The capsule's default log level");
    private static final Map.Entry<String, String> ATTR_MODE_DESC = Capsule.ATTRIBUTE("Description", Capsule.T_STRING(), null, true, "Contains the description of its respective mode");
    protected static final Map.Entry<String, String> ATTR_APP_CLASS = Capsule.ATTRIBUTE("Application-Class", Capsule.T_STRING(), null, true, "The main application class");
    protected static final Map.Entry<String, String> ATTR_APP_ARTIFACT = Capsule.ATTRIBUTE("Application", Capsule.T_STRING(), null, true, "The Maven coordinates of the application's main JAR or the path of the main JAR within the capsule");
    protected static final Map.Entry<String, Object> ATTR_SCRIPT = Capsule.ATTRIBUTE("Application-Script", Capsule.T_FILE(), null, true, "A startup script to be run *instead* of `Application-Class`, given as a path relative to the capsule's root");
    protected static final Map.Entry<String, String> ATTR_MIN_JAVA_VERSION = Capsule.ATTRIBUTE("Min-Java-Version", Capsule.T_STRING(), null, true, "The lowest Java version required to run the application");
    protected static final Map.Entry<String, String> ATTR_JAVA_VERSION = Capsule.ATTRIBUTE("Java-Version", Capsule.T_STRING(), null, true, "The highest version of the Java installation required to run the application");
    protected static final Map.Entry<String, Map<String, String>> ATTR_MIN_UPDATE_VERSION = Capsule.ATTRIBUTE("Min-Update-Version", Capsule.T_MAP(Capsule.T_STRING(), Capsule.T_STRING(), null), null, true, "A space-separated key-value ('=' separated) list mapping Java versions to the minimum update version required");
    protected static final Map.Entry<String, Boolean> ATTR_JDK_REQUIRED = Capsule.ATTRIBUTE("JDK-Required", Capsule.T_BOOL(), false, true, "Whether or not a JDK is required to launch the application");
    protected static final Map.Entry<String, Boolean> ATTR_AGENT = Capsule.ATTRIBUTE("Capsule-Agent", Capsule.T_BOOL(), false, true, "Whether this capsule should inject itself as an agent into the application.");
    private static final Map.Entry<String, List<String>> ATTR_ARGS = Capsule.ATTRIBUTE("Args", Capsule.T_LIST(Capsule.T_STRING()), null, true, "A list of command line arguments to be passed to the application; the UNIX shell-style special variables (`$*`, `$1`, `$2`, ...) can refer to the actual arguments passed on the capsule's command line; if no special var is used, the listed values will be prepended to the supplied arguments (i.e., as if `$*` had been listed last).");
    private static final Map.Entry<String, Map<String, String>> ATTR_ENV = Capsule.ATTRIBUTE("Environment-Variables", Capsule.T_MAP(Capsule.T_STRING(), Capsule.T_STRING(), null), null, true, "A list of environment variables that will be put in the applications environment; formatted \"var=value\" or \"var\"");
    protected static final Map.Entry<String, List<String>> ATTR_JVM_ARGS = Capsule.ATTRIBUTE("JVM-Args", Capsule.T_LIST(Capsule.T_STRING()), null, true, "A list of JVM arguments that will be used to launch the application's Java process");
    protected static final Map.Entry<String, Map<String, String>> ATTR_SYSTEM_PROPERTIES = Capsule.ATTRIBUTE("System-Properties", Capsule.T_MAP(Capsule.T_STRING(), Capsule.T_STRING(), ""), null, true, "A list of system properties that will be defined in the applications JVM; formatted \"prop=value\" or \"prop\"");
    protected static final Map.Entry<String, List<Object>> ATTR_APP_CLASS_PATH = Capsule.ATTRIBUTE("App-Class-Path", Capsule.T_LIST(Capsule.T_FILE()), null, true, "A list of JARs, relative to the capsule root, that will be put on the application's classpath, in the order they are listed");
    protected static final Map.Entry<String, Boolean> ATTR_CAPSULE_IN_CLASS_PATH = Capsule.ATTRIBUTE("Capsule-In-Class-Path", Capsule.T_BOOL(), true, true, "Whether or not the capsule JAR itself is on the application's classpath");
    protected static final Map.Entry<String, List<Object>> ATTR_BOOT_CLASS_PATH = Capsule.ATTRIBUTE("Boot-Class-Path", Capsule.T_LIST(Capsule.T_FILE()), null, true, "A list of JARs, dependencies, and/or directories, relative to the capsule root, that will be used as the application's boot classpath");
    protected static final Map.Entry<String, List<Object>> ATTR_BOOT_CLASS_PATH_A = Capsule.ATTRIBUTE("Boot-Class-Path-A", Capsule.T_LIST(Capsule.T_FILE()), null, true, "A list of JARs dependencies, and/or directories, relative to the capsule root, that will be appended to the applications default boot classpath");
    protected static final Map.Entry<String, List<Object>> ATTR_BOOT_CLASS_PATH_P = Capsule.ATTRIBUTE("Boot-Class-Path-P", Capsule.T_LIST(Capsule.T_FILE()), null, true, "A list of JARs dependencies, and/or directories, relative to the capsule root, that will be prepended to the applications default boot classpath");
    protected static final Map.Entry<String, List<Object>> ATTR_LIBRARY_PATH_A = Capsule.ATTRIBUTE("Library-Path-A", Capsule.T_LIST(Capsule.T_FILE()), null, true, "A list of JARs and/or directories, relative to the capsule root, to be appended to the default native library path");
    protected static final Map.Entry<String, List<Object>> ATTR_LIBRARY_PATH_P = Capsule.ATTRIBUTE("Library-Path-P", Capsule.T_LIST(Capsule.T_FILE()), null, true, "a list of JARs and/or directories, relative to the capsule root, to be prepended to the default native library path");
    protected static final Map.Entry<String, String> ATTR_SECURITY_MANAGER = Capsule.ATTRIBUTE("Security-Manager", Capsule.T_STRING(), null, true, "The name of a class that will serve as the application's security-manager");
    protected static final Map.Entry<String, String> ATTR_SECURITY_POLICY = Capsule.ATTRIBUTE("Security-Policy", Capsule.T_STRING(), null, true, "A security policy file, relative to the capsule root, that will be used as the security policy");
    protected static final Map.Entry<String, String> ATTR_SECURITY_POLICY_A = Capsule.ATTRIBUTE("Security-Policy-A", Capsule.T_STRING(), null, true, "A security policy file, relative to the capsule root, that will be appended to the default security policy");
    protected static final Map.Entry<String, Map<Object, String>> ATTR_JAVA_AGENTS = Capsule.ATTRIBUTE("Java-Agents", Capsule.T_MAP(Capsule.T_FILE(), Capsule.T_STRING(), ""), null, true, "A list of Java agents used by the application; formatted \"agent\" or \"agent=arg1,arg2...\", where agent is either the path to a JAR relative to the capsule root, or a Maven coordinate of a dependency");
    protected static final Map.Entry<String, Map<Object, String>> ATTR_NATIVE_AGENTS = Capsule.ATTRIBUTE("Native-Agents", Capsule.T_MAP(Capsule.T_FILE(Capsule.getNativeLibExtension()), Capsule.T_STRING(), ""), null, true, "A list of native JVMTI agents used by the application; formatted \"agent\" or \"agent=arg1,arg2...\", where agent is either the path to a native library, without the platform-specific suffix, relative to the capsule root. The native library file(s) can be embedded in the capsule or listed as Maven native dependencies using the Native-Dependencies-... attributes.");
    protected static final Map.Entry<String, List<Object>> ATTR_DEPENDENCIES = Capsule.ATTRIBUTE("Dependencies", Capsule.T_LIST(Capsule.T_FILE()), null, true, "A list of Maven dependencies given as groupId:artifactId:version[(excludeGroupId:excludeArtifactId,...)]");
    protected static final Map.Entry<String, Map<Object, String>> ATTR_NATIVE_DEPENDENCIES = Capsule.ATTRIBUTE("Native-Dependencies", Capsule.T_MAP(Capsule.T_FILE(Capsule.getNativeLibExtension()), Capsule.T_STRING(), ""), null, true, "A list of Maven dependencies consisting of native library artifacts; each item can be a comma separated pair, with the second component being a new name to give the download artifact");
    private static final String VAR_CAPSULE_APP = "CAPSULE_APP";
    private static final String VAR_CAPSULE_DIR = "CAPSULE_DIR";
    private static final String VAR_CAPSULE_JAR = "CAPSULE_JAR";
    private static final String VAR_CLASSPATH = "CLASSPATH";
    private static final String VAR_JAVA_HOME = "JAVA_HOME";
    private static final String PROP_CAPSULE_JAR = "capsule.jar";
    private static final String PROP_CAPSULE_DIR = "capsule.dir";
    private static final String PROP_CAPSULE_APP = "capsule.app";
    private static final String PROP_CAPSULE_APP_PID = "capsule.app.pid";
    private static final String LOG_PREFIX = "CAPSULE: ";
    private static final String LOG_AGENT_PREFIX = "CAPSULE AGENT: ";
    protected static final int LOG_NONE = 0;
    protected static final int LOG_QUIET = 1;
    protected static final int LOG_VERBOSE = 2;
    protected static final int LOG_DEBUG = 3;
    private static final int PROFILE = Capsule.emptyOrTrue(System.getProperty("capsule.profile")) ? 1 : 3;
    protected static final PrintStream STDOUT = System.out;
    protected static final PrintStream STDERR = System.err;
    private static volatile Integer LOG_LEVEL;
    private static Path CACHE_DIR;
    private static Capsule CAPSULE;
    private static boolean AGENT;
    private static Map<String, List<Path>> JAVA_HOMES;
    private final Map<String, String> threads = new HashMap<String, String>();
    private Capsule oc;
    private Capsule cc;
    private Capsule sup;
    private Capsule _ct;
    private final boolean wrapper;
    private final Manifest manifest;
    private Path jarFile;
    private String appId;
    private String mode;
    private String nonCapsuleTarget;
    private Path javaHome;
    private String javaVersion;
    private Path cacheDir;
    private Path appDir;
    private Path writableAppCache;
    private boolean plainCache;
    private boolean cacheUpToDate;
    private FileLock appCacheLock;
    private int lifecycleStage;
    private String appArtifactMainClass;
    private List<String> jvmArgs_;
    private List<String> args_;
    private List<Path> tmpFiles = new ArrayList<Path>();
    private Process child;
    private boolean agentCalled;
    private MBeanServer origMBeanServer;
    private MBeanServerConnection jmxConnection;
    private static final ThreadLocal<String> contextType_;
    private static final ThreadLocal<String> contextKey_;
    private static final ThreadLocal<String> contextValue_;
    private Object socket;
    private InetAddress address;
    private int port;
    private ObjectInput socketInput;
    private ObjectOutput socketOutput;
    private static final Pattern PAT_JAVA_SPECIFIC_SECTION;
    private static final Attributes EMPTY_ATTRIBUTES;
    private static final Pattern PAT_DEPENDENCY;
    private static Map<Path, List<String>> jarEntriesCache;
    private static final int[] ZIP_HEADER;
    private static final Pattern PAT_JAVA_VERSION_LINE;
    private static final Pattern PAT_JAVA_VERSION;
    private static final Pattern PAT_VAR;

    static final Capsule myCapsule(List<String> args) {
        if (CAPSULE == null) {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(MY_CLASSLOADER);
                Capsule capsule = Capsule.newCapsule(MY_CLASSLOADER, Capsule.findOwnJarFile());
                Capsule.clearContext();
                if ((AGENT || capsule.isEmptyCapsule()) && args != null && !args.isEmpty()) {
                    Capsule.processCmdLineOptions(args, ManagementFactory.getRuntimeMXBean().getInputArguments());
                    if (capsule.isEmptyCapsule()) {
                        capsule = capsule.setTarget(args.remove(0));
                    }
                } else {
                    Capsule.processOptions();
                }
                CAPSULE = capsule.oc;
            }
            finally {
                Thread.currentThread().setContextClassLoader(ccl);
            }
        }
        return CAPSULE;
    }

    public static final void main(String[] args) {
        System.exit(Capsule.main0(args));
    }

    private static int main0(String[] args0) {
        List<String> args = new ArrayList<String>(Arrays.asList(args0));
        Capsule capsule = null;
        try {
            capsule = Capsule.myCapsule(args);
            args = Collections.unmodifiableList(args);
            if (Capsule.isWrapperFactoryCapsule(capsule)) {
                capsule = null;
                return Capsule.runOtherCapsule(args);
            }
            if (Capsule.runActions(capsule, args)) {
                return 0;
            }
            return capsule.launch(args);
        }
        catch (Throwable t) {
            if (capsule != null) {
                capsule.cleanup1();
                capsule.onError(t);
            } else {
                Capsule.printError(t, capsule);
            }
            return 1;
        }
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        AGENT = true;
        PROPERTIES = new Properties(System.getProperties());
        Capsule capsule = null;
        try {
            Capsule.processOptions();
            capsule = Capsule.myCapsule((List<String>)(agentArgs != null ? new ArrayList<String>(Capsule.split(agentArgs, "\\s+")) : null));
            Capsule c = capsule.cc;
            while (c != null) {
                c.agent(inst);
                c = c.sup;
            }
        }
        catch (Throwable t) {
            if (capsule != null) {
                capsule.cleanup1();
                capsule.onError(t);
            }
            Capsule.printError(1, t);
        }
    }

    public static Object getCapsule(String capletClassName) {
        return Capsule.CAPSULE.cc.sup(capletClassName);
    }

    private static void printError(int level, Throwable t) {
        if (!Capsule.isLogging(level)) {
            return;
        }
        STDERR.print((AGENT ? "CAPSULE AGENT" : "CAPSULE") + " EXCEPTION: " + t.getMessage());
        if (Capsule.hasContext() && (t.getMessage() == null || t.getMessage().length() < 50)) {
            STDERR.print(" while processing " + Capsule.getContext());
        }
        if (Capsule.getLogLevel(Capsule.getProperty0(PROP_LOG_LEVEL)) >= 2) {
            STDERR.println();
            Capsule.deshadow(t).printStackTrace(STDERR);
        } else {
            STDERR.println(" (for stack trace, run with -D" + PROP_LOG_LEVEL + "=verbose)");
        }
    }

    private static void printError(Throwable t, Capsule capsule) {
        Capsule.printError(1, t);
        if (!AGENT && t instanceof IllegalArgumentException) {
            Capsule.printUsage(capsule);
        }
    }

    private static void printUsage(Capsule capsule) {
        Capsule.printHelp(capsule != null ? capsule.isWrapperCapsule() : true);
    }

    private static boolean isWrapperFactoryCapsule(Capsule capsule) {
        return capsule.isFactoryCapsule() && capsule.isWrapperCapsule() && capsule.getJarFile() != null;
    }

    private static int runOtherCapsule(List<String> args) {
        Path jar = CAPSULE.getJarFile();
        CAPSULE = null;
        return Capsule.runMain(jar, args);
    }

    private static int runMain(Path jar, List<String> args) {
        String mainClass;
        try {
            mainClass = Capsule.getMainClass(jar);
            if (mainClass == null) {
                throw new IllegalArgumentException("JAR file " + jar + " is not an executable (does not have a main class)");
            }
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(jar + " does not exist or does appear to be a valid JAR", e);
        }
        try {
            Method main = Capsule.newClassLoader0(null, jar).loadClass(mainClass).getMethod("main", String[].class);
            try {
                main.invoke(null, new Object[]{args.toArray(new String[0])});
                return 0;
            }
            catch (Exception e) {
                Capsule.deshadow(e).printStackTrace(STDERR);
                return 1;
            }
        }
        catch (ReflectiveOperationException e) {
            throw Capsule.rethrow(e);
        }
    }

    protected static final String OPTION(String optionName, String defaultValue, String methodName, boolean wrapperOnly, String description) {
        if (!optionName.startsWith(CAPSULE_PROP_PREFIX)) {
            throw new IllegalArgumentException("Option name must start with capsule. but was " + optionName);
        }
        Object[] conf = new Object[]{defaultValue, methodName, wrapperOnly, description};
        Object[] old = OPTIONS.get(optionName);
        if (old != null && Arrays.asList(conf).subList(0, conf.length - 1).equals(Arrays.asList(old).subList(0, conf.length - 1))) {
            throw new IllegalStateException("Option " + optionName + " has a conflicting registration: " + Arrays.toString(old));
        }
        OPTIONS.put(optionName, conf);
        return optionName;
    }

    protected static final String OPTION(String optionName, String defaultValue, String methodName, String description) {
        return Capsule.OPTION(optionName, defaultValue, methodName, false, description);
    }

    private static boolean optionTakesArguments(String propertyName) {
        String defaultValue = (String)OPTIONS.get(propertyName)[0];
        return !"false".equals(defaultValue) && !"true".equals(defaultValue);
    }

    private static void processOptions() {
        for (Map.Entry<String, Object[]> entry : OPTIONS.entrySet()) {
            String option = entry.getKey();
            String defval = (String)entry.getValue()[0];
            if (Capsule.getProperty0(option) == null && defval != null && !defval.equals("false")) {
                Capsule.setProperty(option, defval);
                continue;
            }
            if (Capsule.optionTakesArguments(option) || !"".equals(Capsule.getProperty0(option))) continue;
            Capsule.setProperty(option, "true");
        }
    }

    private static void processCmdLineOptions(List<String> args, List<String> jvmArgs) {
        while (!args.isEmpty() && Capsule.first(args).startsWith("-")) {
            String option;
            String arg = args.remove(0);
            String optarg = null;
            if (arg.contains("=")) {
                optarg = Capsule.getAfter(arg, '=');
            }
            if ((option = Capsule.simpleToOption(Capsule.getBefore(arg, '='))) == null) {
                throw new IllegalArgumentException("Unrecognized option: " + arg);
            }
            boolean overridden = false;
            for (String x : jvmArgs) {
                if (!x.equals("-D" + option) && !x.startsWith("-D" + option + "=")) continue;
                overridden = true;
                break;
            }
            if (optarg == null) {
                String string = optarg = Capsule.optionTakesArguments(option) ? args.remove(0) : "";
            }
            if (overridden) continue;
            Capsule.setProperty(option, optarg);
        }
        Capsule.processOptions();
    }

    static final boolean runActions(Capsule capsule, List<String> args) {
        Capsule.verifyAgent(false);
        try {
            boolean found = false;
            for (Map.Entry<String, Object[]> entry : OPTIONS.entrySet()) {
                if (entry.getValue()[1] == null || !Capsule.systemPropertyEmptyOrNotFalse(entry.getKey())) continue;
                if (!capsule.isWrapperCapsule() && ((Boolean)entry.getValue()[2]).booleanValue()) {
                    throw new IllegalStateException("Action " + entry.getKey() + " is availbale for wrapper capsules only.");
                }
                Method m = Capsule.getMethod(capsule, (String)entry.getValue()[1], List.class);
                m.invoke(capsule.cc.sup(m.getDeclaringClass()), args);
                found = true;
            }
            if (found) {
                capsule.cleanup1();
            }
            return found;
        }
        catch (InvocationTargetException e) {
            throw Capsule.rethrow(e);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String optionToSimple(String option) {
        return "-" + Capsule.camelCaseToDashed(option.substring(CAPSULE_PROP_PREFIX.length())).replace('.', '-');
    }

    private static String simpleToOption(String simple) {
        if ("-h".equals(simple)) {
            return PROP_HELP;
        }
        for (String option : OPTIONS.keySet()) {
            if (!simple.equals(Capsule.optionToSimple(option))) continue;
            return option;
        }
        return null;
    }

    private static String camelCaseToDashed(String camel) {
        return camel.replaceAll("([A-Z][a-z]+)", "-$1").toLowerCase();
    }

    private static boolean isCapsuleOption(String propertyName) {
        return propertyName.startsWith(CAPSULE_PROP_PREFIX);
    }

    protected Capsule(Path jarFile) {
        Capsule.clearContext();
        Objects.requireNonNull(jarFile, "jarFile can't be null");
        this.oc = this;
        this.cc = this;
        this.sup = null;
        this.jarFile = Capsule.toAbsolutePath(jarFile);
        long start = System.nanoTime();
        try (JarInputStream jis = Capsule.openJarInputStream(jarFile);){
            this.manifest = jis.getManifest();
            if (this.manifest == null) {
                throw new RuntimeException("Capsule " + jarFile + " does not have a manifest");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read JAR file " + jarFile, e);
        }
        Capsule.setLogLevel(this.chooseLogLevel());
        Capsule.log(2, "Jar: " + jarFile);
        Capsule.log(2, "Platform: " + PLATFORM);
        this.wrapper = this.isEmptyCapsule();
        this.loadCaplets();
        Capsule.setLogLevel(this.chooseLogLevel());
        Capsule.time("Load class " + this.getClass().getName(), START, start);
        Capsule.time("Read JAR in constructor", start);
        if (!this.wrapper) {
            this.finalizeCapsule();
        } else if (this.isFactoryCapsule()) {
            this.jarFile = null;
        }
        Capsule.clearContext();
    }

    protected Capsule(Capsule pred) {
        this.oc = pred.oc;
        this.cc = this;
        Capsule.time("Load class " + this.getClass().getName(), START);
        Capsule.clearContext();
        this.wrapper = pred.wrapper;
        this.manifest = pred.manifest;
        this.jarFile = pred.jarFile;
    }

    final Capsule setTarget(String target) {
        Path jar;
        this.verifyCanCallSetTarget();
        Path path = jar = Capsule.isDependency(target) ? Capsule.firstOrNull(this.resolve(this.lookup(target, ATTR_APP_ARTIFACT))) : Capsule.toAbsolutePath(this.path(target, new String[0]));
        if (jar == null) {
            throw new RuntimeException(target + " not found.");
        }
        if (jar.equals(this.getJarFile())) {
            throw new RuntimeException("Capsule wrapping loop detected with capsule " + this.getJarFile());
        }
        if (this.isFactoryCapsule()) {
            this.jarFile = jar;
            return this;
        }
        boolean isCapsule = false;
        long start = Capsule.clock();
        try (JarInputStream jis = Capsule.openJarInputStream(jar);){
            JarEntry entry;
            Manifest man = jis.getManifest();
            if (man == null || man.getMainAttributes().getValue(ATTR_MAIN_CLASS) == null) {
                throw new IllegalArgumentException(jar + " is not a capsule or an executable JAR");
            }
            while ((entry = jis.getNextJarEntry()) != null) {
                if (!entry.getName().equals(Capsule.class.getName() + ".class")) continue;
                isCapsule = true;
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read JAR file " + jar, e);
        }
        Capsule.time("Read JAR in setTarget", start);
        if (!isCapsule) {
            this.oc.nonCapsuleTarget = target;
        } else {
            Capsule.log(2, "Wrapping capsule " + jar);
            this.insertAfter(this.loadTargetCapsule((ClassLoader)this.cc.getClass().getClassLoader(), (Path)jar).cc);
        }
        this.finalizeCapsule();
        return this;
    }

    protected void finalizeCapsule() {
        this._ct = this.getCallTarget(Capsule.class);
        if (this._ct != null) {
            this._ct.finalizeCapsule();
        } else {
            this.finalizeCapsule0();
        }
        Capsule.clearContext();
    }

    private void finalizeCapsule0() {
        this.validateManifest(this.oc.manifest);
        Capsule.setLogLevel(this.chooseLogLevel());
        this.oc.mode = this.chooseMode1();
        this.initAppId();
        if (this.getAppId() == null && (!this.hasAttribute(ATTR_APP_ARTIFACT) || Capsule.isDependency(this.getAttribute(ATTR_APP_ARTIFACT)))) {
            throw new IllegalArgumentException("Could not determine app ID. Capsule jar " + this.getJarFile() + " should have the " + ATTR_APP_NAME + " manifest attribute.");
        }
    }

    private void verifyCanCallSetTarget() {
        if (this.getAppId() != null) {
            throw new IllegalStateException("Capsule is finalized");
        }
        if (!this.isEmptyCapsule()) {
            throw new IllegalStateException("Capsule " + this.getJarFile() + " isn't empty");
        }
    }

    private void loadCaplets() {
        for (String caplet : this.getAttribute(ATTR_CAPLETS)) {
            this.loadCaplet(caplet, this.cc).insertAfter(this.cc);
        }
    }

    private void initAppId() {
        if (this.oc.appId != null) {
            return;
        }
        Capsule.log(2, "Initializing app ID");
        String name = this.getAppIdNoVer();
        if (name == null) {
            return;
        }
        String version = this.getAttribute(ATTR_APP_VERSION);
        this.oc.appId = name + (version != null ? "_" + version : "");
        Capsule.log(2, "Initialized app ID: " + this.oc.appId);
    }

    protected final boolean isEmptyCapsule() {
        return !this.hasAttribute(ATTR_APP_ARTIFACT) && !this.hasAttribute(ATTR_APP_CLASS) && !this.hasAttribute(ATTR_SCRIPT);
    }

    private void setStage(int stage) {
        this.oc.lifecycleStage = stage;
    }

    private void verifyAtStage(int stage) {
        if (this.oc.lifecycleStage != stage) {
            throw new IllegalStateException("This operation is not available at this stage in the capsule's lifecycle.");
        }
    }

    protected final void verifyAfterStage(int stage) {
        if (this.oc.lifecycleStage <= stage) {
            throw new IllegalStateException("This operation is not available at this stage in the capsule's lifecycle.");
        }
    }

    private static void clearCaches() {
        jarEntriesCache.clear();
    }

    private Capsule loadCaplet(String caplet, Capsule pred) {
        Capsule.log(2, "Loading caplet: " + caplet);
        if (Capsule.isDependency(caplet) || caplet.endsWith(".jar")) {
            List<Path> jars = this.resolve(this.lookup(caplet, ATTR_CAPLETS));
            if (jars.size() != 1) {
                throw new RuntimeException("The caplet " + caplet + " has transitive dependencies.");
            }
            return this.newCapsule(Capsule.first(jars), pred);
        }
        return Capsule.newCapsule(caplet, pred);
    }

    private void insertAfter(Capsule pred) {
        Capsule.log(2, "Applying caplet " + this.getClass().getName());
        if (this.sup == pred) {
            return;
        }
        if (pred != null) {
            if (this.sup != null) {
                throw new IllegalStateException("Caplet " + this + " is already in the chain (after " + this.sup + ")");
            }
            if (!this.wrapper && pred.hasCaplet(this.getClass().getName())) {
                Capsule.log(2, "Caplet " + this.getClass().getName() + " has already been applied.");
                return;
            }
            this.sup = pred;
            this.oc = this.sup.oc;
            Capsule c = this.cc;
            while (c != this) {
                c.oc = this.oc;
                c = c.sup;
            }
            if (this.sup.cc == this.sup) {
                c = this.sup;
                while (c != null) {
                    c.cc = this.cc;
                    c = c.sup;
                }
            } else {
                throw new IllegalArgumentException("Caplet cannot be inserted in the middle of the hierarchy");
            }
        }
    }

    protected final boolean hasCaplet(String name) {
        Capsule c = this.cc;
        while (c != null) {
            for (Class<?> cls = c.getClass(); cls != null; cls = cls.getSuperclass()) {
                if (!name.equals(cls.getName())) continue;
                return true;
            }
            c = c.sup;
        }
        return false;
    }

    protected final <T extends Capsule> T sup(Class<T> caplet) {
        Capsule c = this;
        while (c != null) {
            if (caplet.isInstance(c)) {
                return (T)((Capsule)caplet.cast(c));
            }
            c = c.sup;
        }
        return null;
    }

    protected final Capsule sup(String ClassName) {
        Capsule c = this;
        while (c != null) {
            for (Class<?> cls = c.getClass(); cls != null; cls = cls.getSuperclass()) {
                if (!ClassName.equals(cls.getName())) continue;
                return c;
            }
            c = c.sup;
        }
        return null;
    }

    final List<Class<? extends Capsule>> getCaplets() {
        ArrayList<Class<? extends Capsule>> caplets = new ArrayList<Class<? extends Capsule>>();
        Capsule c = this.cc;
        while (c != null) {
            caplets.add(c.getClass());
            c = c.sup;
        }
        Collections.reverse(caplets);
        return caplets;
    }

    protected final <T extends Capsule> T getCallTarget(Class<T> clazz) {
        Capsule target = null;
        if ((this.sup == null || this.sup.sup(clazz) == null || this.jarFile != ((Capsule)this.sup.sup(clazz)).jarFile) && this.cc != this) {
            StackTraceElement[] st = new Throwable().getStackTrace();
            if (st == null || st.length < 3) {
                throw new AssertionError((Object)"No debug information in Capsule class");
            }
            boolean c1 = true;
            if (!st[1].getClassName().equals(clazz.getName())) {
                throw new RuntimeException("Illegal access. Method can only be called by the " + clazz.getName() + " class");
            }
            int c2 = 2;
            while (Capsule.isStream(st[c2].getClassName())) {
                ++c2;
            }
            if (st[1].getLineNumber() <= 0 || st[c2].getLineNumber() <= 0) {
                throw new AssertionError((Object)"No debug information in Capsule class");
            }
            if (!st[c2].getMethodName().equals(st[1].getMethodName()) || st[c2].getClassName().equals(clazz.getName()) && Math.abs(st[c2].getLineNumber() - st[1].getLineNumber()) > 3) {
                target = this.cc;
            }
        }
        if (target == null) {
            target = this.sup;
        }
        return target != null ? (T)target.sup(clazz) : null;
    }

    private boolean isWrapperOfNonCapsule() {
        return this.nonCapsuleTarget != null;
    }

    private boolean isFactoryCapsule() {
        if (!this.getClass().equals(Capsule.class) || !this.wrapper) {
            return false;
        }
        for (Object attr : this.manifest.getMainAttributes().keySet()) {
            if (!ATTRIBS.containsKey(attr.toString())) continue;
            return false;
        }
        for (Attributes atts : this.manifest.getEntries().values()) {
            for (Object attr : atts.keySet()) {
                if (!ATTRIBS.containsKey(attr.toString())) continue;
                return false;
            }
        }
        Capsule.log(3, "Factory (unchanged) capsule");
        return true;
    }

    protected final boolean isWrapperCapsule() {
        Capsule c = this.cc;
        while (c != null) {
            if (c.wrapper) {
                return true;
            }
            c = c.sup;
        }
        return false;
    }

    protected final String getMode() {
        return this.oc.mode;
    }

    protected final String getPlatform() {
        return PLATFORM;
    }

    protected final Path getJarFile() {
        return this.oc.jarFile;
    }

    protected final String getAppId() {
        return this.oc.appId;
    }

    public boolean isAgent() {
        return AGENT;
    }

    private static Path findJarFile(Class<? extends Capsule> capsuleClass) {
        assert (capsuleClass != null);
        URL url = MY_CLASSLOADER.getResource(capsuleClass.getName().replace('.', '/') + ".class");
        if (url == null) {
            throw new IllegalStateException("The " + capsuleClass + " class must be in a JAR file, but was not found");
        }
        if (!"jar".equals(url.getProtocol())) {
            throw new IllegalStateException("The " + capsuleClass + " class must be in a JAR file, but was loaded from: " + url);
        }
        String path = url.getPath();
        if (path == null) {
            throw new IllegalStateException("The " + capsuleClass + " class must be in a local JAR file, but was loaded from: " + url);
        }
        try {
            URI jarUri = new URI(path.substring(0, path.indexOf(33)));
            return Paths.get(jarUri);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Path findOwnJarFile() {
        return Capsule.findJarFile(Capsule.class);
    }

    private String toJarUrl(String relPath) {
        return "jar:file:" + this.getJarFile().toAbsolutePath() + "!/" + relPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isExecutable(Path path) {
        if (!Files.isExecutable(path)) {
            return false;
        }
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), "UTF-8");){
            int c = ((Reader)reader).read();
            if (c < 0 || (char)c != '#') {
                boolean bl = false;
                return bl;
            }
            c = ((Reader)reader).read();
            if (c < 0 || (char)c != '!') {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw Capsule.rethrow(e);
        }
    }

    void printVersion(List<String> args) {
        if (this.getAppId() != null) {
            STDOUT.println("CAPSULE: Application " + this.getAppId());
            if (this.hasAttribute(ATTR_APP_NAME)) {
                STDOUT.println(LOG_PREFIX + this.getAttribute(ATTR_APP_NAME));
            }
            if (this.hasAttribute(ATTR_APP_VERSION)) {
                STDOUT.println("CAPSULE: Version: " + this.getAttribute(ATTR_APP_VERSION));
            }
            for (String attr : Arrays.asList(ATTR_IMPLEMENTATION_VENDOR, ATTR_IMPLEMENTATION_URL)) {
                if (this.getManifestAttribute(attr) == null) continue;
                STDOUT.println(LOG_PREFIX + this.getManifestAttribute(attr));
            }
        }
        STDOUT.println("CAPSULE: Capsule Version 1.0");
    }

    void printModes(List<String> args) {
        this.verifyNonEmpty("Cannot print modes of a wrapper capsule.");
        STDOUT.println("CAPSULE: Application " + this.getAppId());
        STDOUT.println("Available modes:");
        Set<String> modes = this.getModes();
        if (modes.isEmpty()) {
            STDOUT.println("Default mode only");
        } else {
            for (String m : modes) {
                String desc = this.getModeDescription(m);
                STDOUT.println("* " + m + (desc != null ? ": " + desc : ""));
            }
        }
    }

    void printJVMs(List<String> args) {
        Map<String, List<Path>> jres = Capsule.getJavaHomes();
        if (jres == null) {
            Capsule.println("No detected Java installations");
        } else {
            STDOUT.println("CAPSULE: Detected Java installations:");
            for (Map.Entry<String, List<Path>> j : jres.entrySet()) {
                for (Path home : j.getValue()) {
                    STDOUT.println(j.getKey() + (Capsule.isJDK(home) ? " (JDK)" : "") + (j.getKey().length() < 8 ? "\t\t" : "\t") + home);
                }
            }
        }
        Path jhome = this.getJavaHome();
        STDOUT.println("CAPSULE: selected " + (jhome != null ? jhome : Capsule.getProperty(PROP_JAVA_HOME) + " (current)"));
    }

    void mergeCapsules(List<String> args) {
        if (!this.isWrapperCapsule()) {
            throw new IllegalStateException("This is not a wrapper capsule");
        }
        try {
            Path outCapsule = this.path(Capsule.getProperty(PROP_MERGE), new String[0]);
            Path wr = this.cc.jarFile;
            Path wd = this.oc.jarFile;
            Capsule.log(1, "Merging " + wr + (!Objects.deepEquals(wr, wd) ? " + " + wd : "") + " -> " + outCapsule);
            this.mergeCapsule(wr, wd, outCapsule);
        }
        catch (Exception e) {
            throw new RuntimeException("Capsule merge failed.", e);
        }
    }

    void printHelp(List<String> args) {
        Capsule.printHelp(this.wrapper);
    }

    private static void printHelp(boolean simple) {
        Path myJar = Capsule.toFriendlyPath(Capsule.findOwnJarFile());
        boolean executable = Capsule.isExecutable(myJar);
        StringBuilder usage = new StringBuilder();
        if (!executable) {
            usage.append("java ");
        }
        if (simple) {
            if (!executable) {
                usage.append("-jar ");
            }
            usage.append(myJar).append(' ');
        }
        usage.append("<options> ");
        if (!simple && !executable) {
            usage.append("-jar ");
        }
        if (simple) {
            usage.append("<path or Maven coords of application JAR/capsule>");
        } else {
            usage.append(myJar);
        }
        STDERR.println("USAGE: " + usage);
        for (boolean actions : new boolean[]{true, false}) {
            STDERR.println("\n" + (actions ? "Actions:" : "Options:"));
            for (Map.Entry<String, Object[]> entry : OPTIONS.entrySet()) {
                if (entry.getValue()[3] == null || entry.getValue()[1] != null != actions || !simple && ((Boolean)entry.getValue()[2]).booleanValue()) continue;
                String option = entry.getKey();
                String defaultValue = (String)entry.getValue()[0];
                if (simple && !Capsule.optionTakesArguments(option) && defaultValue.equals("true")) continue;
                StringBuilder sb = new StringBuilder();
                sb.append(simple ? Capsule.optionToSimple(option) : option);
                if (Capsule.optionTakesArguments(option) || defaultValue.equals("true")) {
                    sb.append(simple ? (char)' ' : '=').append("<value>");
                    if (defaultValue != null) {
                        sb.append(" (default: ").append(defaultValue).append(")");
                    }
                }
                sb.append(" - ").append(entry.getValue()[3]);
                STDERR.println("  " + sb);
            }
        }
    }

    private int launch(List<String> args) throws IOException, InterruptedException {
        Capsule.verifyAgent(false);
        this.setStage(1);
        this.verifyNonEmpty("Cannot launch a wrapper capsule.");
        List<String> jvmArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
        ProcessBuilder pb = this.prepareForLaunch(jvmArgs, args);
        if (pb == null) {
            Capsule.log(2, "Nothing to run");
            return 0;
        }
        Capsule.clearContext();
        Capsule.time("Total", START);
        Capsule.log(2, Capsule.join(pb.command(), " ") + (pb.directory() != null ? " (Running in " + pb.directory() + ")" : ""));
        Capsule.clearContext();
        return this.launch(pb);
    }

    private void verifyNonEmpty(String message) {
        if (this.isEmptyCapsule()) {
            throw new IllegalArgumentException(message);
        }
    }

    private Thread startThread(String name, String method) {
        if (this.threads.containsKey(name)) {
            throw new IllegalStateException("A thread by the name " + name + " has already been registered.");
        }
        this.threads.put(name, method);
        Thread t = new Thread((Runnable)this, name);
        t.setDaemon(true);
        t.start();
        return t;
    }

    @Override
    public final void run() {
        String threadName = Thread.currentThread().getName();
        try {
            String methodName = this.threads.get(threadName);
            if (methodName != null) {
                try {
                    Capsule.getMethod(Capsule.class, methodName, new Class[0]).invoke((Object)this, new Object[0]);
                    return;
                }
                catch (ReflectiveOperationException e) {
                    throw Capsule.rethrow(e);
                }
            }
            this.cleanup1();
        }
        catch (Throwable e) {
            Capsule.log(1, "Exception on thread " + threadName + ": " + e.getMessage());
            Capsule.printError(1, e);
            throw Capsule.rethrow(e);
        }
    }

    final ProcessBuilder prepareForLaunch(List<String> jvmArgs, List<String> args) {
        Capsule.verifyAgent(false);
        this.oc.jvmArgs_ = Capsule.nullToEmpty(jvmArgs);
        this.oc.args_ = Capsule.nullToEmpty(jvmArgs);
        Capsule.log(2, "Launching app " + this.getAppId() + (this.getMode() != null ? " in mode " + this.getMode() : ""));
        long start = Capsule.clock();
        this.lookupAllDependencies();
        ProcessBuilder pb = this.prelaunch(Capsule.nullToEmpty(jvmArgs), Capsule.nullToEmpty(args));
        Capsule.time("prepareForLaunch", start);
        return pb;
    }

    protected int launch(ProcessBuilder pb) throws IOException, InterruptedException {
        this._ct = this.unsafe(this.getCallTarget(Capsule.class));
        return this._ct != null ? this._ct.launch(pb) : this.launch0(pb);
    }

    private int launch0(ProcessBuilder pb) throws IOException, InterruptedException {
        if (Capsule.isTrampoline()) {
            STDOUT.println(this.trampolineString(pb));
        } else {
            Runtime.getRuntime().addShutdownHook(new Thread((Runnable)this, "cleanup"));
            this.overridePlatformMBeanServer();
            if (!Capsule.isInheritIoBug()) {
                pb.inheritIO();
            }
            this.oc.child = pb.start();
            this.oc.child = this.postlaunch(this.oc.child);
            if (this.oc.child == null) {
                return 0;
            }
            this.setStage(2);
            int pid = Capsule.getPid(this.oc.child);
            if (pid > 0) {
                System.setProperty(PROP_CAPSULE_APP_PID, Integer.toString(pid));
            }
            if (Capsule.isInheritIoBug()) {
                this.pipeIoStreams();
            }
            if (this.oc.socket != null) {
                this.startServer();
            }
            this.liftoff();
            this.oc.child.waitFor();
        }
        return this.oc.child != null ? this.oc.child.exitValue() : 0;
    }

    private String trampolineString(ProcessBuilder pb) {
        if (this.hasAttribute(ATTR_ENV)) {
            throw new RuntimeException("Capsule cannot trampoline because manifest defines the " + ATTR_ENV + " attribute.");
        }
        ArrayList<String> cmdline = new ArrayList<String>(pb.command());
        cmdline.remove("-Dcapsule.trampoline");
        for (int i = 0; i < cmdline.size(); ++i) {
            cmdline.set(i, "\"" + (String)cmdline.get(i) + "\"");
        }
        return Capsule.join(cmdline, " ");
    }

    private void cleanup1() {
        Capsule.log(2, "Cleanup");
        Capsule.log(3, new Exception("Stack trace"));
        this.cleanup();
    }

    protected void cleanup() {
        this._ct = this.getCallTarget(Capsule.class);
        if (this._ct != null) {
            this._ct.cleanup();
        } else {
            this.cleanup0();
        }
    }

    private void cleanup0() {
        try {
            if (this.oc.child != null) {
                this.killChild();
                this.oc.child.waitFor();
            }
            this.oc.child = null;
        }
        catch (Exception t) {
            Capsule.deshadow(t).printStackTrace(STDERR);
        }
        for (Path p : this.oc.tmpFiles) {
            try {
                Capsule.delete(p);
            }
            catch (Exception t) {
                Capsule.log(2, t.getMessage());
            }
        }
        this.oc.tmpFiles.clear();
    }

    private void killChild() {
        if (Capsule.isWindows()) {
            if (!this.send(1, 1)) {
                this.oc.child.destroy();
            }
        } else {
            this.oc.child.destroy();
        }
    }

    private boolean isChildAlive() {
        Process c = this.oc.child;
        return c != null && Capsule.isAlive(c);
    }

    protected final Path addTempFile(Path p) {
        Capsule.log(2, "Creating temp file/dir " + p);
        this.oc.tmpFiles.add(p);
        return p;
    }

    private String chooseMode1() {
        String m = this.chooseMode();
        if (m != null && !this.hasMode(m)) {
            throw new IllegalArgumentException("Capsule " + this.getJarFile() + " does not have mode " + m);
        }
        return m;
    }

    protected String chooseMode() {
        this._ct = this.getCallTarget(Capsule.class);
        return this._ct != null ? this._ct.chooseMode() : this.chooseMode0();
    }

    private String chooseMode0() {
        return Capsule.emptyToNull(Capsule.getProperty(PROP_MODE));
    }

    protected ProcessBuilder prelaunch(List<String> jvmArgs, List<String> args) {
        this._ct = this.unsafe(this.getCallTarget(Capsule.class));
        return this._ct != null ? this._ct.prelaunch(jvmArgs, args) : this.prelaunch0(jvmArgs, args);
    }

    private ProcessBuilder prelaunch0(List<String> jvmArgs, List<String> args) {
        try {
            if (!Capsule.isTrampoline() && this.getAttribute(ATTR_AGENT).booleanValue()) {
                this.prepareServer();
            }
            ProcessBuilder pb = this.buildProcess();
            this.buildEnvironmentVariables(pb);
            pb.command().addAll(this.buildArgs(args));
            this.cleanupCache(null);
            return pb;
        }
        catch (Throwable t) {
            this.cleanupCache(t);
            throw t;
        }
    }

    protected ProcessBuilder buildProcess() {
        this._ct = this.unsafe(this.getCallTarget(Capsule.class));
        return this._ct != null ? this._ct.buildProcess() : this.buildProcess0();
    }

    private ProcessBuilder buildProcess0() {
        if (this.oc.jvmArgs_ == null) {
            throw new IllegalStateException("Capsule has not been prepared for launch!");
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        if (!this.buildScriptProcess(pb)) {
            this.buildJavaProcess(pb, this.oc.jvmArgs_);
        }
        return pb;
    }

    protected List<String> buildArgs(List<String> args) {
        this._ct = this.getCallTarget(Capsule.class);
        return this._ct != null ? this._ct.buildArgs(args) : this.buildArgs0(args);
    }

    private List<String> buildArgs0(List<String> args) {
        return Capsule.expandArgs(this.getAttribute(ATTR_ARGS), args);
    }

    static List<String> expandArgs(List<String> args0, List<String> args) {
        ArrayList<String> args1 = new ArrayList<String>();
        boolean expanded = false;
        for (String a : args0) {
            if (a.startsWith("$")) {
                if (a.equals("$*")) {
                    args1.addAll(args);
                    expanded = true;
                    continue;
                }
                try {
                    int i = Integer.parseInt(a.substring(1));
                    args1.add(args.get(i - 1));
                    expanded = true;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            args1.add(a);
        }
        if (!expanded) {
            args1.addAll(args);
        }
        return args1;
    }

    private void buildEnvironmentVariables(ProcessBuilder pb) {
        Map<String, String> env = new HashMap<String, String>(pb.environment());
        env = this.buildEnvironmentVariables(env);
        pb.environment().clear();
        pb.environment().putAll(env);
    }

    protected Map<String, String> buildEnvironmentVariables(Map<String, String> env) {
        this._ct = this.getCallTarget(Capsule.class);
        return this._ct != null ? this._ct.buildEnvironmentVariables(env) : this.buildEnvironmentVariables0(env);
    }

    private Map<String, String> buildEnvironmentVariables0(Map<String, String> env) {
        Map<String, String> jarEnv = this.getAttribute(ATTR_ENV);
        for (Map.Entry<String, String> e : jarEnv.entrySet()) {
            boolean overwrite = false;
            String var = e.getKey();
            if (var.endsWith(":")) {
                overwrite = true;
                var = var.substring(0, var.length() - 1);
            }
            if (!overwrite && env.containsKey(var)) continue;
            env.put(var, e.getValue() != null ? e.getValue() : "");
        }
        if (this.getAppId() != null) {
            if (this.getAppDir() != null) {
                env.put(VAR_CAPSULE_DIR, this.processOutgoingPath(this.getAppDir()));
            }
            env.put(VAR_CAPSULE_JAR, this.processOutgoingPath(this.getJarFile()));
            env.put(VAR_CAPSULE_APP, this.getAppId());
        }
        return env;
    }

    private static boolean isTrampoline() {
        return Capsule.systemPropertyEmptyOrTrue(PROP_TRAMPOLINE);
    }

    protected Process postlaunch(Process child) {
        this._ct = this.getCallTarget(Capsule.class);
        return this._ct != null ? this._ct.postlaunch(child) : this.postlaunch0(child);
    }

    private Process postlaunch0(Process child) {
        return child;
    }

    protected void liftoff() {
        this._ct = this.getCallTarget(Capsule.class);
        if (this._ct != null) {
            this._ct.liftoff();
        } else {
            this.liftoff0();
        }
    }

    private void liftoff0() {
    }

    private static void verifyAgent(boolean isAgent) {
        if (AGENT != isAgent) {
            throw new IllegalStateException("This operation is only available when " + (isAgent ? "agent" : "non-agent"));
        }
    }

    protected void agent(Instrumentation inst) {
        if (this.oc.agentCalled) {
            return;
        }
        this.oc.agentCalled = true;
        if (Capsule.getProperty(PROP_ADDRESS) != null || Capsule.getProperty(PROP_PORT) != null) {
            this.startClient();
        }
    }

    private <T> T agentAttributes(Map.Entry<String, T> attr, T value) {
        if (ATTR_AGENT == attr) {
            return value;
        }
        if (!this.getAttribute(ATTR_AGENT).booleanValue()) {
            return value;
        }
        if (ATTR_JAVA_AGENTS == attr) {
            LinkedHashMap<Object, String> agents = new LinkedHashMap<Object, String>(Capsule.cast(ATTR_JAVA_AGENTS, value));
            Path ownJar = null;
            try {
                ownJar = Capsule.findOwnJarFile();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (ownJar != null) {
                agents.put(this.processOutgoingPath(ownJar), this.isWrapperCapsule() ? this.processOutgoingPath(this.getJarFile()) : "");
            }
            return (T)agents;
        }
        if (ATTR_SYSTEM_PROPERTIES == attr && this.oc.address != null) {
            HashMap<String, String> props = new HashMap<String, String>(Capsule.cast(ATTR_SYSTEM_PROPERTIES, value));
            props.put(PROP_ADDRESS, this.oc.address.getHostAddress());
            props.put(PROP_PORT, Integer.toString(this.oc.port));
            props.put(PROP_LOG_LEVEL, Integer.toString(Capsule.getLogLevel()));
            return (T)props;
        }
        return value;
    }

    private void prepareServer() {
        try {
            Capsule.log(2, "Starting capsule server.");
            InetSocketAddress sa = this.getLocalAddress();
            ServerSocket server = new ServerSocket(sa.getPort(), 5, sa.getAddress());
            sa = (InetSocketAddress)server.getLocalSocketAddress();
            this.oc.address = sa.getAddress();
            this.oc.port = sa.getPort();
            this.oc.socket = server;
            Capsule.log(2, "Binding capsule server at: " + this.oc.address.getHostAddress() + ":" + this.oc.port);
        }
        catch (IOException e) {
            throw Capsule.rethrow(e);
        }
    }

    private void startServer() throws IOException {
        block14: {
            try (ServerSocket server = (ServerSocket)this.oc.socket;){
                server.setSoTimeout(30000);
                Capsule.log(2, "Waiting for client to connect...");
                Socket s = server.accept();
                this.openSocketStreams(s);
                this.oc.socket = s;
                Capsule.log(2, "Client connected");
            }
            catch (IOException e) {
                if (!this.isChildAlive()) break block14;
                Capsule.log(1, "Client connection failed.");
                Capsule.printError(1, e);
                this.closeComm();
            }
        }
    }

    private void startClient() {
        Capsule.log(2, "Starting capsule client: " + Capsule.getProperty(PROP_ADDRESS) + ":" + Capsule.getProperty(PROP_PORT));
        if (Capsule.getProperty(PROP_ADDRESS) == null || Capsule.getProperty(PROP_PORT) == null) {
            throw new IllegalStateException("Comm channel not defined");
        }
        try {
            this.oc.address = InetAddress.getByName(Capsule.getProperty(PROP_ADDRESS));
            this.oc.port = Integer.valueOf(Capsule.getProperty(PROP_PORT));
            Socket s = new Socket();
            s.connect(new InetSocketAddress(this.oc.address, this.oc.port), 30000);
            this.openSocketStreams(s);
            this.oc.socket = s;
            Capsule.log(2, "Client connected,");
            this.startThread("capsule-comm", "receiveLoop");
        }
        catch (IOException e) {
            Capsule.log(2, "Client connection failed.");
            Capsule.printError(2, e);
            this.closeComm();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openSocketStreams(Socket s) throws IOException {
        Capsule capsule = this.oc;
        synchronized (capsule) {
            try {
                s.setSoTimeout(30000);
                this.oc.socketOutput = new ObjectOutputStream(s.getOutputStream());
                this.oc.socketOutput.flush();
                this.oc.socketInput = new ObjectInputStream(s.getInputStream());
                s.setSoTimeout(0);
            }
            catch (IOException e) {
                if (e instanceof SocketTimeoutException) {
                    Capsule.log(2, "Socket timed out");
                }
                Capsule.close(s);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeComm() {
        Capsule capsule = this.oc;
        synchronized (capsule) {
            Capsule.log(2, "Closing comm");
            if (this.oc.socket != null) {
                Capsule.close(this.oc.socket);
            }
            this.oc.socket = null;
            this.oc.address = null;
            this.oc.port = 0;
            this.oc.socketOutput = null;
            this.oc.socketInput = null;
        }
    }

    private void receiveLoop() {
        try {
            while (this.receive()) {
            }
        }
        catch (IOException e) {
            try {
                Process p = this.child;
                if (p != null && !Capsule.waitFor(p, 100L)) {
                    Capsule.printError(1, e);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private boolean send(int message, Object payload) {
        if (!AGENT) {
            this.verifyAfterStage(1);
        }
        if (this.oc.socketOutput == null) {
            return false;
        }
        try {
            this.send0(message, payload);
            return true;
        }
        catch (IOException e) {
            Capsule.log(2, "Sending of message " + message + ": " + payload + " failed - " + e.getMessage());
            Capsule.log(3, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send0(int message, Object payload) throws IOException {
        Capsule capsule = this.oc;
        synchronized (capsule) {
            if (this.oc.socketOutput == null) {
                throw new IOException("comm channel not defined");
            }
            Capsule.log(2, "Sending message " + message + " : " + payload);
            this.oc.socketOutput.writeInt(message);
            this.oc.socketOutput.writeObject(payload);
            this.oc.socketOutput.flush();
        }
    }

    private boolean receive() throws IOException {
        Capsule capsule = this.oc;
        synchronized (capsule) {
            if (!AGENT) {
                this.verifyAfterStage(1);
            }
            if (this.oc.socket == null) {
                return false;
            }
            try {
                int message = this.oc.socketInput.readInt();
                Object payload = this.oc.socketInput.readObject();
                Capsule.log(2, "Message received " + message + " : " + payload);
                this.receive(message, payload);
                return true;
            }
            catch (EOFException e) {
                Capsule.log(2, "Received EOF");
                Capsule.log(2, e);
                return false;
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }
    }

    private void receive(int message, Object payload) {
        switch (message) {
            case 1: {
                System.exit((Integer)payload);
                break;
            }
            case 2: {
                JMXServiceURL jmxurl;
                if (!AGENT || (jmxurl = this.startJMXServer()) == null) break;
                this.send(3, jmxurl);
                break;
            }
            case 3: {
                if (AGENT) break;
                this.connectToJMX((JMXServiceURL)payload);
            }
        }
    }

    protected InetSocketAddress getLocalAddress() {
        this._ct = this.getCallTarget(Capsule.class);
        return this._ct != null ? this._ct.getLocalAddress() : this.getLocalAddress0();
    }

    private InetSocketAddress getLocalAddress0() {
        return new InetSocketAddress(0);
    }

    private String getAppIdNoVer() {
        String id = this.getAttribute(ATTR_APP_ID);
        if (Capsule.isEmpty(id)) {
            id = this.getAttribute(ATTR_APP_NAME);
        }
        if (id == null && (id = this.getAttribute(ATTR_APP_CLASS)) != null && this.hasModalAttribute(ATTR_APP_CLASS)) {
            throw new IllegalArgumentException("App ID-related attribute " + ATTR_APP_CLASS + " is defined in a modal section of the manifest.  In this case, you must add the " + ATTR_APP_ID + " attribute to the manifest's main section.");
        }
        return id;
    }

    static String getAppArtifactId(String coords) {
        if (coords == null) {
            return null;
        }
        String[] cs = coords.split(":");
        return cs[0] + "." + cs[1];
    }

    static String getAppArtifactVersion(String coords) {
        if (coords == null) {
            return null;
        }
        String[] cs = coords.split(":");
        if (cs.length < 3) {
            return null;
        }
        return cs[2];
    }

    protected final Path getCacheDir() {
        if (this.oc.cacheDir == null) {
            Path cache = CACHE_DIR;
            if (cache != null) {
                cache = this.initCacheDir(cache);
            } else {
                String cacheDirEnv = System.getenv(ENV_CACHE_DIR);
                if (cacheDirEnv != null) {
                    if (cacheDirEnv.equalsIgnoreCase(CACHE_NONE)) {
                        return null;
                    }
                    cache = this.initCacheDir(Paths.get(cacheDirEnv, new String[0]));
                    if (cache == null) {
                        throw new RuntimeException("Could not initialize cache directory " + Paths.get(cacheDirEnv, new String[0]));
                    }
                } else {
                    String name = Capsule.getCacheName();
                    cache = this.initCacheDir(Capsule.getCacheHome().resolve(name));
                    if (cache == null) {
                        try {
                            cache = this.addTempFile(Files.createTempDirectory(Capsule.getTempDir(), "capsule-", new FileAttribute[0]));
                        }
                        catch (IOException e) {
                            Capsule.log(2, "Could not create directory: " + cache + " -- " + e.getMessage());
                            cache = null;
                        }
                    }
                }
            }
            Capsule.log(2, "Cache directory: " + cache);
            this.oc.cacheDir = cache;
        }
        return this.oc.cacheDir;
    }

    private static String getCacheName() {
        String cacheNameEnv = System.getenv(ENV_CACHE_NAME);
        String cacheName = cacheNameEnv != null ? cacheNameEnv : CACHE_DEFAULT_NAME;
        return (Capsule.isWindows() ? "" : ".") + cacheName;
    }

    private Path initCacheDir(Path cache) {
        try {
            if (!Files.exists(cache, new LinkOption[0])) {
                Files.createDirectories(cache, Capsule.getPermissions(Capsule.getExistingAncestor(cache)));
            }
            return cache;
        }
        catch (IOException e) {
            Capsule.log(2, "Could not create directory: " + cache + " -- " + e.getMessage());
            return null;
        }
    }

    private static Path getCacheHome() {
        Path cacheHome;
        Path userHome = Paths.get(Capsule.getProperty(PROP_USER_HOME), new String[0]);
        if (!Capsule.isWindows()) {
            cacheHome = userHome;
        } else {
            Path localData;
            String localAppData = Capsule.getenv("LOCALAPPDATA");
            if (localAppData != null) {
                localData = Paths.get(localAppData, new String[0]);
                if (!Files.isDirectory(localData, new LinkOption[0])) {
                    throw new RuntimeException("%LOCALAPPDATA% set to nonexistent directory " + localData);
                }
            } else {
                localData = userHome.resolve(Paths.get("AppData", "Local"));
                if (!Files.isDirectory(localData, new LinkOption[0])) {
                    localData = userHome.resolve(Paths.get("Local Settings", "Application Data"));
                }
                if (!Files.isDirectory(localData, new LinkOption[0])) {
                    throw new RuntimeException("%LOCALAPPDATA% is undefined, and neither " + userHome.resolve(Paths.get("AppData", "Local")) + " nor " + userHome.resolve(Paths.get("Local Settings", "Application Data")) + " have been found");
                }
            }
            cacheHome = localData;
        }
        return cacheHome;
    }

    protected final Path getAppDir() {
        return this.oc.appDir;
    }

    private Path getOrCreateAppDir() {
        if (this.oc.appDir == null) {
            this.oc.appDir = this.buildAppCacheDir();
        }
        return this.oc.appDir;
    }

    protected final Path appDir() {
        Path dir = this.getOrCreateAppDir();
        if (dir == null) {
            String message = "Capsule not extracted.";
            if (this.getAppId() == null) {
                message = this.isEmptyCapsule() ? message + " This is a wrapper capsule and the wrapped capsule hasn't been set (yet)" : message + " App ID has not been determined yet.";
            }
            throw new IllegalStateException(message);
        }
        return dir;
    }

    protected final Path getWritableAppCache() {
        if (this.oc.writableAppCache == null) {
            Path cache = this.getOrCreateAppDir();
            if (cache == null || !Files.isWritable(cache)) {
                try {
                    cache = this.addTempFile(Files.createTempDirectory(Capsule.getTempDir(), "capsule-", new FileAttribute[0]));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.oc.writableAppCache = cache;
        }
        return this.oc.writableAppCache;
    }

    private boolean hasWritableAppCache() {
        return this.oc.writableAppCache != null && !this.oc.writableAppCache.equals(this.getAppDir());
    }

    protected Path buildAppCacheDir() {
        this._ct = this.unsafe(this.getCallTarget(Capsule.class));
        return this._ct != null ? this._ct.buildAppCacheDir() : this.buildAppCacheDir0();
    }

    private Path buildAppCacheDir0() {
        this.initAppId();
        if (this.getAppId() == null) {
            return null;
        }
        this.oc.plainCache = true;
        try {
            long start = Capsule.clock();
            Path dir = Capsule.toAbsolutePath(this.getCacheDir().resolve(APP_CACHE_NAME).resolve(this.getAppId()));
            Files.createDirectories(dir, Capsule.getPermissions(Capsule.getExistingAncestor(dir)));
            this.oc.cacheUpToDate = this.isAppCacheUpToDate1(dir);
            if (!this.oc.cacheUpToDate) {
                this.resetAppCache(dir);
                this.extractCapsule(dir);
            } else {
                Capsule.log(2, "App cache " + dir + " is up to date.");
            }
            Capsule.time("buildAppCacheDir", start);
            return dir;
        }
        catch (IOException e) {
            Capsule.log(2, "IOException while creating app cache: " + e.getMessage());
            Capsule.log(2, e);
            return null;
        }
    }

    private void resetAppCache(Path dir) throws IOException {
        try {
            Capsule.log(3, "(Re)Creating cache for " + this.getJarFile() + " in " + dir.toAbsolutePath());
            Path lockFile = dir.resolve(LOCK_FILE_NAME);
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(dir);){
                for (Path f : ds) {
                    if (lockFile.equals(f)) continue;
                    Capsule.delete(f);
                }
            }
        }
        catch (IOException e) {
            throw new IOException("Exception while clearing app cache directory " + dir.toAbsolutePath(), e);
        }
    }

    private boolean isAppCacheUpToDate1(Path dir) throws IOException {
        boolean res = this.testAppCacheUpToDate(dir);
        if (!res) {
            this.lockAppCache(dir);
            res = this.testAppCacheUpToDate(dir);
            if (res) {
                this.unlockAppCache(dir);
            }
        }
        return res;
    }

    private boolean testAppCacheUpToDate(Path dir) throws IOException {
        if (Capsule.systemPropertyEmptyOrTrue(PROP_RESET)) {
            return false;
        }
        Path extractedFile = dir.resolve(TIMESTAMP_FILE_NAME);
        if (!Files.exists(extractedFile, new LinkOption[0])) {
            return false;
        }
        FileTime jarTime = Files.getLastModifiedTime(this.getJarFile(), new LinkOption[0]);
        FileTime extractedTime = Files.getLastModifiedTime(extractedFile, new LinkOption[0]);
        boolean fresh = extractedTime.compareTo(jarTime) >= 0;
        Capsule.log(3, "JAR timestamp: " + jarTime + " Cache timestamp: " + extractedTime + " (" + (fresh ? "fresh" : "stale") + ")");
        return fresh;
    }

    private void extractCapsule(Path dir) throws IOException {
        try {
            Capsule.log(2, "Extracting " + this.getJarFile() + " to app cache directory " + dir.toAbsolutePath());
            Capsule.log(3, new Exception("Stack trace"));
            Capsule.extractJar(Capsule.openJarInputStream(this.getJarFile()), dir);
        }
        catch (IOException e) {
            throw new IOException("Exception while extracting jar " + this.getJarFile() + " to app cache directory " + dir.toAbsolutePath(), e);
        }
    }

    private void cleanupCache(Throwable exception) {
        try {
            try {
                if (exception == null) {
                    this.markCache();
                }
            }
            finally {
                this.unlockAppCache();
            }
        }
        catch (IOException e) {
            throw Capsule.rethrow(e);
        }
    }

    private void markCache() throws IOException {
        if (!this.oc.plainCache || this.oc.appDir == null || this.oc.cacheUpToDate) {
            return;
        }
        if (Files.isWritable(this.oc.appDir)) {
            Files.createFile(this.oc.appDir.resolve(TIMESTAMP_FILE_NAME), new FileAttribute[0]);
        }
    }

    private void lockAppCache(Path dir) throws IOException {
        Path lockFile = this.addTempFile(dir.resolve(LOCK_FILE_NAME));
        Capsule.log(2, "Locking " + lockFile);
        FileChannel c = FileChannel.open(lockFile, new HashSet<StandardOpenOption>(Arrays.asList(StandardOpenOption.CREATE, StandardOpenOption.WRITE)), Capsule.getPermissions(dir));
        if (this.appCacheLock != null) {
            Capsule.log(1, "Attempting to double lock (ignoring, but this is most likely a bug in CAPSULE)");
            c.close();
        } else {
            this.appCacheLock = c.lock();
        }
    }

    private void unlockAppCache(Path dir) throws IOException {
        if (this.appCacheLock != null) {
            Capsule.log(2, "Unlocking " + dir.resolve(LOCK_FILE_NAME));
            this.appCacheLock.release();
            this.appCacheLock.acquiredBy().close();
            this.appCacheLock = null;
        }
    }

    private void unlockAppCache() throws IOException {
        if (!this.oc.plainCache || this.oc.appDir == null) {
            return;
        }
        this.unlockAppCache(this.oc.appDir);
    }

    private boolean buildScriptProcess(ProcessBuilder pb) {
        Object script = this.getAttribute(ATTR_SCRIPT);
        if (script == null) {
            return false;
        }
        this.setJavaHomeEnv(pb, this.getJavaHome());
        List<Object> classPath = this.getAttribute(ATTR_APP_CLASS_PATH);
        this.resolveNativeDependencies();
        pb.environment().put(VAR_CLASSPATH, this.compileClassPath(this.resolve(classPath)));
        pb.command().add(this.processOutgoingPath(script));
        return true;
    }

    private Path setJavaHomeEnv(ProcessBuilder pb, Path javaHome) {
        if (javaHome == null) {
            return null;
        }
        pb.environment().put(VAR_JAVA_HOME, this.processOutgoingPath(javaHome));
        return javaHome;
    }

    private boolean buildJavaProcess(ProcessBuilder pb, List<String> cmdLine) {
        List<String> command = pb.command();
        command.add(this.processOutgoingPath(this.getJavaExecutable()));
        command.addAll(this.buildJVMArgs(cmdLine));
        Capsule.addOption(command, "-Xbootclasspath:", this.compileClassPath(this.resolve(this.buildBootClassPath(cmdLine))));
        Capsule.addOption(command, "-Xbootclasspath/p:", this.compileClassPath(this.resolve(this.getAttribute(ATTR_BOOT_CLASS_PATH_P))));
        Capsule.addOption(command, "-Xbootclasspath/a:", this.compileClassPath(this.resolve(this.getAttribute(ATTR_BOOT_CLASS_PATH_A))));
        command.addAll(this.compileAgents("-javaagent:", this.buildAgents(true)));
        command.addAll(this.compileAgents("-agentpath:", this.buildAgents(false)));
        List<Path> classPath = this.resolve(this.getAttribute(ATTR_APP_CLASS_PATH));
        String mainClass = this.getMainClass(classPath);
        command.addAll(Capsule.compileSystemProperties(this.buildSystemProperties(cmdLine)));
        String cpstr = this.compileClassPath(this.handleLongClasspath(classPath, mainClass.length(), command, this.oc.args_));
        if (cpstr != null) {
            command.add("-classpath");
            command.add(cpstr);
        }
        command.add(mainClass);
        return true;
    }

    private void lookupAllDependencies() {
        long start = Capsule.clock();
        this.getAttribute(ATTR_APP_ARTIFACT);
        for (Map.Entry<String, Object[]> attr : ATTRIBS.entrySet()) {
            if (!Capsule.hasFILE_T(attr.getValue()[0])) continue;
            this.getAttribute(Capsule.attr(attr.getKey()));
        }
        Capsule.time("lookupAllDependencies", start);
    }

    protected Path getJavaExecutable() {
        this._ct = this.getCallTarget(Capsule.class);
        return this._ct != null ? this._ct.getJavaExecutable() : this.getJavaExecutable0();
    }

    private Path getJavaExecutable0() {
        String javaCmd = Capsule.emptyToNull(Capsule.getProperty(PROP_CAPSULE_JAVA_CMD));
        if (javaCmd != null) {
            return this.path(javaCmd, new String[0]);
        }
        return Capsule.getJavaExecutable(this.getJavaHome());
    }

    protected static final Path getJavaExecutable(Path javaHome) {
        return Capsule.getJavaExecutable0(javaHome);
    }

    private static List<String> compileSystemProperties(Map<String, String> ps) {
        ArrayList<String> command = new ArrayList<String>();
        for (Map.Entry<String, String> entry : ps.entrySet()) {
            command.add("-D" + entry.getKey() + (entry.getValue() != null && !entry.getValue().isEmpty() ? "=" + entry.getValue() : ""));
        }
        return command;
    }

    private String compileClassPath(List<Path> cp) {
        if (Capsule.isEmpty(cp)) {
            return null;
        }
        return Capsule.join(cp, PATH_SEPARATOR);
    }

    private List<String> compileAgents(String clo, Map<Path, String> agents) {
        ArrayList<String> command = new ArrayList<String>();
        for (Map.Entry<Path, String> agent : Capsule.nullToEmpty(agents).entrySet()) {
            command.add(clo + Capsule.first(this.resolve(agent.getKey())) + (agent.getValue().isEmpty() ? "" : "=" + agent.getValue()));
        }
        return command;
    }

    private static void addOption(List<String> cmdLine, String prefix, String value) {
        if (value == null) {
            return;
        }
        cmdLine.add(prefix + value);
    }

    private List<Object> buildClassPath0(List<Object> classPath0) {
        long start = Capsule.clock();
        ArrayList<Object> classPath = new ArrayList<Object>();
        if (!this.isWrapperOfNonCapsule() && this.getAttribute(ATTR_CAPSULE_IN_CLASS_PATH).booleanValue()) {
            this.addCapsuleJars(classPath);
        }
        if (this.hasAttribute(ATTR_APP_ARTIFACT)) {
            String artifact = this.getAttribute(ATTR_APP_ARTIFACT);
            if (Capsule.isGlob(artifact)) {
                throw new IllegalArgumentException("Glob pattern not allowed in " + ATTR_APP_ARTIFACT + " attribute.");
            }
            Object app = this.lookup(this.isWrapperOfNonCapsule() && !Capsule.isDependency(artifact) ? Capsule.toAbsolutePath(this.path(artifact, new String[0])).toString() : this.sanitize(artifact), ATTR_APP_ARTIFACT);
            classPath.add(app);
        }
        Capsule.addAllIfAbsent(classPath, classPath0);
        classPath.add(this.lookup("*.jar", ATTR_APP_CLASS_PATH));
        classPath.addAll(Capsule.nullToEmpty(this.getAttribute(ATTR_DEPENDENCIES)));
        if (!this.isWrapperOfNonCapsule() && Capsule.isDeepEmpty(classPath)) {
            this.addCapsuleJars(classPath);
        }
        ArrayList<Object> ret = new ArrayList<Object>(new LinkedHashSet<Object>(classPath));
        Capsule.time("buildClassPath", start);
        return ret;
    }

    private void addCapsuleJars(List<Object> classPath) {
        Capsule c = this.cc;
        do {
            Path p = null;
            try {
                p = Capsule.findJarFile(c.getClass());
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (p == null || classPath.contains(p)) continue;
            classPath.add(p);
        } while ((c = this.sup) != null);
        classPath.add(this.getJarFile());
    }

    private List<?> buildBootClassPath(List<String> cmdLine) {
        String option = null;
        for (String o : cmdLine) {
            if (!o.startsWith("-Xbootclasspath:")) continue;
            option = o.substring("-Xbootclasspath:".length());
        }
        return option != null ? this.toPath(Arrays.asList(option.split(PATH_SEPARATOR))) : this.getAttribute(ATTR_BOOT_CLASS_PATH);
    }

    private Map<String, String> buildSystemProperties(List<String> cmdLine) {
        Map<String, String> systemProperties = this.buildSystemProperties();
        for (String option : cmdLine) {
            if (!option.startsWith("-D") || Capsule.isCapsuleOption(option.substring(2)) && !this.getAttribute(ATTR_AGENT).booleanValue()) continue;
            Capsule.addSystemProperty(option.substring(2), systemProperties);
        }
        return systemProperties;
    }

    private Map<String, String> buildSystemProperties() {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> pv : this.getAttribute(ATTR_SYSTEM_PROPERTIES).entrySet()) {
            systemProperties.put(pv.getKey(), pv.getValue());
        }
        List<Path> libraryPath = this.buildNativeLibraryPath();
        systemProperties.put(PROP_JAVA_LIBRARY_PATH, this.compileClassPath(libraryPath));
        if (this.hasAttribute(ATTR_SECURITY_POLICY) || this.hasAttribute(ATTR_SECURITY_POLICY_A)) {
            systemProperties.put(PROP_JAVA_SECURITY_MANAGER, "");
            if (this.hasAttribute(ATTR_SECURITY_POLICY_A)) {
                systemProperties.put(PROP_JAVA_SECURITY_POLICY, this.toJarUrl(this.getAttribute(ATTR_SECURITY_POLICY_A)));
            }
            if (this.hasAttribute(ATTR_SECURITY_POLICY)) {
                systemProperties.put(PROP_JAVA_SECURITY_POLICY, "=" + this.toJarUrl(this.getAttribute(ATTR_SECURITY_POLICY)));
            }
        }
        if (this.hasAttribute(ATTR_SECURITY_MANAGER)) {
            systemProperties.put(PROP_JAVA_SECURITY_MANAGER, this.getAttribute(ATTR_SECURITY_MANAGER));
        }
        if (this.getAppId() != null) {
            if (this.getAppDir() != null) {
                systemProperties.put(PROP_CAPSULE_DIR, this.processOutgoingPath(this.getAppDir()));
            }
            systemProperties.put(PROP_CAPSULE_JAR, this.processOutgoingPath(this.getJarFile()));
            systemProperties.put(PROP_CAPSULE_APP, this.getAppId());
        }
        return systemProperties;
    }

    private static void addSystemProperty(String p, Map<String, String> ps) {
        try {
            String name = Capsule.getBefore(p, '=');
            String value = Capsule.getAfter(p, '=');
            ps.put(name, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Illegal system property definition: " + p);
        }
    }

    private List<Path> buildNativeLibraryPath() {
        ArrayList<Path> libraryPath = new ArrayList<Path>(this.getPlatformNativeLibraryPath());
        this.resolveNativeDependencies();
        libraryPath.addAll(0, this.resolve(this.getAttribute(ATTR_LIBRARY_PATH_P)));
        libraryPath.addAll(this.resolve(this.getAttribute(ATTR_LIBRARY_PATH_A)));
        if (!this.listJar(this.getJarFile(), "*." + Capsule.getNativeLibExtension(), true).isEmpty()) {
            this.appDir();
        }
        if (this.getAppDir() != null) {
            libraryPath.add(this.getAppDir());
        }
        if (this.hasWritableAppCache()) {
            libraryPath.add(this.getWritableAppCache());
        }
        return libraryPath;
    }

    protected List<Path> getPlatformNativeLibraryPath() {
        this._ct = this.getCallTarget(Capsule.class);
        return this._ct != null ? this._ct.getPlatformNativeLibraryPath() : this.getPlatformNativeLibraryPath0();
    }

    private List<Path> getPlatformNativeLibraryPath0() {
        List<String> ps = Capsule.split(Capsule.getProperty(PROP_JAVA_LIBRARY_PATH), PATH_SEPARATOR);
        ps.remove(".");
        return this.toPath(ps);
    }

    private void resolveNativeDependencies() {
        this.resolve(this.getAttribute(ATTR_NATIVE_DEPENDENCIES).keySet());
    }

    private List<String> buildJVMArgs(List<String> cmdLine) {
        LinkedHashMap<String, String> jvmArgs = new LinkedHashMap<String, String>();
        for (String option : this.buildJVMArgs()) {
            Capsule.addJvmArg(option, jvmArgs);
        }
        for (String option : Capsule.nullToEmpty(Capsule.parseCommandLineArguments(Capsule.getProperty(PROP_JVM_ARGS)))) {
            Capsule.addJvmArg(option, jvmArgs);
        }
        for (String option : cmdLine) {
            if (option.startsWith("-D") || option.startsWith("-Xbootclasspath:")) continue;
            Capsule.addJvmArg(option, jvmArgs);
        }
        return new ArrayList<String>(jvmArgs.values());
    }

    private List<String> buildJVMArgs() {
        LinkedHashMap<String, String> jvmArgs = new LinkedHashMap<String, String>();
        for (String a : this.getAttribute(ATTR_JVM_ARGS)) {
            if ((a = a.trim()).isEmpty() || a.startsWith("-Xbootclasspath:") || a.startsWith("-javaagent:")) continue;
            Capsule.addJvmArg(Capsule.toNativePath(this.expand(a)), jvmArgs);
        }
        return new ArrayList<String>(jvmArgs.values());
    }

    private static void addJvmArg(String a, Map<String, String> args) {
        args.put(Capsule.getJvmArgKey(a), a);
    }

    private static String getJvmArgKey(String a) {
        if (a.equals("-client") || a.equals("-server")) {
            return "compiler";
        }
        if (a.equals("-enablesystemassertions") || a.equals("-esa") || a.equals("-disablesystemassertions") || a.equals("-dsa")) {
            return "systemassertions";
        }
        if (a.equals("-jre-restrict-search") || a.equals("-no-jre-restrict-search")) {
            return "-jre-restrict-search";
        }
        if (a.startsWith("-Xloggc:")) {
            return "-Xloggc";
        }
        if (a.startsWith("-Xss")) {
            return "-Xss";
        }
        if (a.startsWith("-Xmx")) {
            return "-Xmx";
        }
        if (a.startsWith("-Xms")) {
            return "-Xms";
        }
        if (a.startsWith("-XX:+") || a.startsWith("-XX:-")) {
            return "-XX:" + a.substring("-XX:+".length());
        }
        if (a.contains("=")) {
            return a.substring(0, a.indexOf(61));
        }
        return a;
    }

    private Map<Path, String> buildAgents(boolean java) {
        long start = Capsule.clock();
        Map<Object, String> agents0 = this.getAttribute(java ? ATTR_JAVA_AGENTS : ATTR_NATIVE_AGENTS);
        LinkedHashMap<Path, String> agents = new LinkedHashMap<Path, String>(agents0.size());
        for (Map.Entry<Object, String> agent : agents0.entrySet()) {
            Object agentName = agent.getKey();
            String agentOptions = agent.getValue();
            Path agentPath = Capsule.first(this.resolve(agentName));
            agents.put(agentPath, agentOptions != null && !agentOptions.isEmpty() ? agentOptions : "");
        }
        Capsule.time("buildAgents (" + (java ? "java" : "native") + ")", start);
        return Capsule.emptyToNull(agents);
    }

    private String getMainClass(List<Path> classPath) {
        Capsule.log(3, "getMainClass: " + classPath);
        String mainClass = this.getAttribute(ATTR_APP_CLASS);
        if (mainClass == null && this.hasAttribute(ATTR_APP_ARTIFACT)) {
            mainClass = this.oc.appArtifactMainClass;
        }
        if (mainClass == null) {
            throw new RuntimeException("Jar " + Capsule.first(classPath).toAbsolutePath() + " does not have a main class defined in the manifest.");
        }
        return mainClass;
    }

    protected final Path getJavaHome() {
        if (this.oc.javaHome == null) {
            Map.Entry<String, Path> jhome = this.chooseJavaHome();
            if (jhome == null) {
                jhome = Capsule.entry(Capsule.getProperty(PROP_JAVA_VERSION), Paths.get(Capsule.getProperty(PROP_JAVA_HOME), new String[0]));
            }
            this.oc.javaVersion = jhome.getKey();
            this.oc.javaHome = jhome.getValue();
            Capsule.log(2, "Using JVM: " + this.oc.javaHome);
        }
        return this.oc.javaHome;
    }

    protected Map.Entry<String, Path> chooseJavaHome() {
        this._ct = this.getCallTarget(Capsule.class);
        return this._ct != null ? this._ct.chooseJavaHome() : this.chooseJavaHome0();
    }

    private Map.Entry<String, Path> chooseJavaHome0() {
        long start = Capsule.clock();
        String propJHome = Capsule.emptyToNull(Capsule.getProperty(PROP_CAPSULE_JAVA_HOME));
        Map.Entry<String, Path> jhome = null;
        if (!"current".equals(propJHome)) {
            Map.Entry<String, Path> entry = jhome = propJHome != null ? Capsule.entry(Capsule.getJavaVersion(Paths.get(propJHome, new String[0])), Paths.get(propJHome, new String[0])) : null;
            if (jhome == null && !this.isMatchingJavaVersion(Capsule.getProperty(PROP_JAVA_VERSION), Capsule.isJDK(Paths.get(Capsule.getProperty(PROP_JAVA_HOME), new String[0])))) {
                boolean jdk = this.getAttribute(ATTR_JDK_REQUIRED);
                jhome = this.findJavaHome(jdk);
                if (Capsule.isLogging(2)) {
                    Capsule.log(2, "Finding JVM: " + (System.nanoTime() - start) / 1000000L + "ms");
                }
                if (jhome == null) {
                    throw new RuntimeException("Could not find Java installation for requested version [Min. Java version: " + this.getAttribute(ATTR_MIN_JAVA_VERSION) + " JavaVersion: " + this.getAttribute(ATTR_JAVA_VERSION) + " Min. update version: " + this.getAttribute(ATTR_MIN_UPDATE_VERSION) + ']' + " (JDK required: " + jdk + "). You can override the used Java version with the -D" + PROP_CAPSULE_JAVA_HOME + " flag.");
                }
            }
        }
        Capsule.time("chooseJavaHome", start);
        return jhome;
    }

    private Map.Entry<String, Path> findJavaHome(boolean jdk) {
        Map<String, List<Path>> homes = Capsule.nullToEmpty(Capsule.getJavaHomes());
        Path bestPath = null;
        String bestVersion = null;
        for (Map.Entry<String, List<Path>> e : homes.entrySet()) {
            for (Path home : e.getValue()) {
                String v = e.getKey();
                Capsule.log(3, "Trying JVM: " + e.getValue() + " (version " + v + ")");
                if (!this.isMatchingJavaVersion(v, Capsule.isJDK(home))) continue;
                Capsule.log(3, "JVM " + e.getValue() + " (version " + v + ") matches");
                if (bestVersion != null && Capsule.compareVersions(v, bestVersion) <= 0) continue;
                Capsule.log(3, "JVM " + e.getValue() + " (version " + v + ") is best so far");
                bestVersion = v;
                bestPath = home;
            }
        }
        return bestVersion != null ? Capsule.entry(bestVersion, bestPath) : null;
    }

    private boolean isMatchingJavaVersion(String javaVersion, boolean jdk) {
        boolean jdkRequired = this.getAttribute(ATTR_JDK_REQUIRED);
        if (jdkRequired && !jdk) {
            Capsule.log(3, "Java version " + javaVersion + " fails to match because JDK required and this is not a JDK");
            return false;
        }
        if (this.hasAttribute(ATTR_MIN_JAVA_VERSION) && Capsule.compareVersions(javaVersion, this.getAttribute(ATTR_MIN_JAVA_VERSION)) < 0) {
            Capsule.log(3, "Java version " + javaVersion + " fails to match due to " + ATTR_MIN_JAVA_VERSION + ": " + this.getAttribute(ATTR_MIN_JAVA_VERSION));
            return false;
        }
        if (this.hasAttribute(ATTR_JAVA_VERSION) && Capsule.compareVersions(javaVersion, Capsule.shortJavaVersion(this.getAttribute(ATTR_JAVA_VERSION)), 3) > 0) {
            Capsule.log(3, "Java version " + javaVersion + " fails to match due to " + this.name(ATTR_JAVA_VERSION) + ": " + this.getAttribute(ATTR_JAVA_VERSION));
            return false;
        }
        if (this.getMinUpdateFor(javaVersion) > Capsule.parseJavaVersion(javaVersion)[3]) {
            Capsule.log(3, "Java version " + javaVersion + " fails to match due to " + this.name(ATTR_MIN_UPDATE_VERSION) + ": " + this.getAttribute(ATTR_MIN_UPDATE_VERSION) + " (" + this.getMinUpdateFor(javaVersion) + ")");
            return false;
        }
        Capsule.log(3, "Java version " + javaVersion + " matches");
        return true;
    }

    private int getMinUpdateFor(String version) {
        Map<String, String> m = this.getAttribute(ATTR_MIN_UPDATE_VERSION);
        int[] ver = Capsule.parseJavaVersion(version);
        for (Map.Entry<String, String> entry : m.entrySet()) {
            if (!Capsule.equals(ver, Capsule.toInt(Capsule.shortJavaVersion(entry.getKey()).split(SEPARATOR_DOT)), 3)) continue;
            return Integer.parseInt(entry.getValue());
        }
        return 0;
    }

    private <T> T attribute0(Map.Entry<String, T> attr) {
        List<Object> value;
        if (ATTR_APP_ID == attr) {
            String id = this.attribute00(ATTR_APP_ID);
            if (id == null && this.getManifestAttribute(ATTR_IMPLEMENTATION_TITLE) != null) {
                id = this.getManifestAttribute(ATTR_IMPLEMENTATION_TITLE);
            }
            if (id == null && this.hasAttribute(ATTR_APP_ARTIFACT) && Capsule.isDependency(this.getAttribute(ATTR_APP_ARTIFACT))) {
                id = Capsule.getAppArtifactId(this.getAttribute(ATTR_APP_ARTIFACT));
            }
            value = id;
        } else if (ATTR_APP_ARTIFACT == attr) {
            String artifact = this.attribute00(ATTR_APP_ARTIFACT);
            if (artifact == null && this.oc.nonCapsuleTarget != null) {
                artifact = this.oc.nonCapsuleTarget;
            }
            value = artifact;
        } else if (ATTR_APP_NAME == attr) {
            String name = this.attribute00(ATTR_APP_NAME);
            if (name == null) {
                name = this.getManifestAttribute(ATTR_IMPLEMENTATION_TITLE);
            }
            value = name;
        } else if (ATTR_APP_VERSION == attr) {
            String ver = this.attribute00(ATTR_APP_VERSION);
            if (ver == null && this.getManifestAttribute(ATTR_IMPLEMENTATION_VERSION) != null) {
                ver = this.getManifestAttribute(ATTR_IMPLEMENTATION_VERSION);
            }
            if (ver == null && this.hasAttribute(ATTR_APP_ARTIFACT) && Capsule.isDependency(this.getAttribute(ATTR_APP_ARTIFACT))) {
                ver = Capsule.getAppArtifactVersion(this.getAttribute(ATTR_APP_ARTIFACT));
            }
            value = ver;
        } else {
            value = ATTR_APP_CLASS_PATH == attr ? this.buildClassPath0(this.attribute00(ATTR_APP_CLASS_PATH)) : this.attribute00(attr);
        }
        value = this.windowsAttributes(attr, value);
        value = this.agentAttributes(attr, value);
        return (T)value;
    }

    protected static final <T> Map.Entry<String, T> ATTRIBUTE(String attrName, T type, T defaultValue, boolean allowModal, String description) {
        if (!Capsule.isValidType(type)) {
            throw new IllegalArgumentException("Type " + type + " is not supported for attributes");
        }
        Object[] conf = new Object[]{type, defaultValue, allowModal, description};
        Object[] old = ATTRIBS.get(attrName);
        if (old != null && Arrays.asList(conf).subList(0, conf.length - 1).equals(Arrays.asList(old).subList(0, conf.length - 1))) {
            throw new IllegalStateException("Attribute " + attrName + " has a conflicting registration: " + Arrays.toString(old));
        }
        ATTRIBS.put(attrName, conf);
        return Capsule.attr(attrName);
    }

    private static <T> Map.Entry<String, T> attr(String name) {
        return Capsule.entry(name, null);
    }

    protected final <T> T getAttribute(Map.Entry<String, T> attr) {
        if (this.name(ATTR_CAPLETS).equals(this.name(attr))) {
            return this.attribute0(attr);
        }
        try {
            T value = this.cc.attribute(attr);
            if (Capsule.hasFILE_T(this.type(attr))) {
                value = this.lookupInAttribute(value, attr);
            }
            Capsule.setContext("attribute", this.name(attr), value);
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while getting attribute " + this.name(attr), e);
        }
    }

    private static <T> T cast(Map.Entry<String, T> attr, Object value) {
        return (T)value;
    }

    protected final String name(Map.Entry<String, ?> attribute) {
        if (attribute == null) {
            return null;
        }
        return attribute.getKey();
    }

    private <T> T type(Map.Entry<String, T> attribute) {
        Object[] conf = ATTRIBS.get(this.name(attribute));
        return (T)(conf != null ? conf[0] : Capsule.T_STRING());
    }

    private static boolean isLegalModeName(String name) {
        return !name.contains("/") && !name.endsWith(".class") && !name.endsWith(".jar") && !Capsule.isJavaVersionSpecific(name) && !Capsule.isOsSpecific(name);
    }

    private void validateManifest(Manifest manifest) {
        String mainClass = manifest.getMainAttributes().getValue(ATTR_MAIN_CLASS);
        if (manifest.getMainAttributes().getValue(ATTR_CLASS_PATH) != null) {
            throw new IllegalStateException("Capsule manifest contains a Class-Path attribute. Use " + ATTR_APP_CLASS_PATH + " and/or " + ATTR_DEPENDENCIES + " instead.");
        }
        this.validateNonModalAttributes(manifest);
        if (!this.hasAttribute(ATTR_APP_NAME) && this.hasModalAttribute(ATTR_APP_ARTIFACT)) {
            throw new IllegalArgumentException("App ID-related attribute " + ATTR_APP_ARTIFACT + " is defined in a modal section of the manifest.  In this case, you must add the " + ATTR_APP_NAME + " attribute to the manifest's main section.");
        }
        HashSet<String> sectionsLowercase = new HashSet<String>();
        for (String section : manifest.getEntries().keySet()) {
            if (sectionsLowercase.add(section.toLowerCase())) continue;
            throw new IllegalArgumentException("Manifest in JAR " + this.jarFile + " contains a case-insensitive duplicate of section " + section);
        }
    }

    private void validateNonModalAttributes(Manifest manifest) {
        for (Map.Entry<String, Attributes> entry : manifest.getEntries().entrySet()) {
            for (Object attr : entry.getValue().keySet()) {
                if (this.allowsModal(attr.toString())) continue;
                throw new IllegalStateException("Manifest section " + entry.getKey() + " contains non-modal attribute " + attr);
            }
        }
    }

    private boolean hasModalAttribute(Map.Entry<String, ?> attr) {
        Attributes.Name key = new Attributes.Name(this.name(attr));
        for (Map.Entry<String, Attributes> entry : this.oc.manifest.getEntries().entrySet()) {
            if (!entry.getValue().containsKey(key)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMode(String mode) {
        if (!Capsule.isLegalModeName(mode)) {
            throw new IllegalArgumentException(mode + " is an illegal mode name");
        }
        return this.oc.manifest.getAttributes(mode) != null;
    }

    protected final Set<String> getModes() {
        HashSet<String> modes = new HashSet<String>();
        for (Map.Entry<String, Attributes> entry : this.oc.manifest.getEntries().entrySet()) {
            if (!Capsule.isLegalModeName(entry.getKey()) || Capsule.isDigest(entry.getValue())) continue;
            modes.add(entry.getKey());
        }
        return Collections.unmodifiableSet(modes);
    }

    private String getManifestAttribute(String attr) {
        return this.oc.manifest.getMainAttributes().getValue(attr);
    }

    protected final String getModeDescription(String mode) {
        if (!Capsule.isLegalModeName(mode)) {
            throw new IllegalArgumentException(mode + " is an illegal mode name");
        }
        if (this.oc.manifest != null && this.oc.manifest.getAttributes(mode) != null) {
            return this.oc.manifest.getAttributes(mode).getValue(this.name(ATTR_MODE_DESC));
        }
        return null;
    }

    private static boolean isDigest(Attributes attrs) {
        for (Object name : attrs.keySet()) {
            if (name.toString().toLowerCase().endsWith("-digest") || name.toString().equalsIgnoreCase("Magic")) continue;
            return false;
        }
        return true;
    }

    private static boolean isOsSpecific(String section) {
        if (PLATFORMS.contains(section = section.toLowerCase())) {
            return true;
        }
        for (String os : PLATFORMS) {
            if (!section.endsWith("-" + os)) continue;
            return true;
        }
        return false;
    }

    private static boolean isJavaVersionSpecific(String section) {
        return PAT_JAVA_SPECIFIC_SECTION.matcher(section.toLowerCase()).find();
    }

    protected <T> T attribute(Map.Entry<String, T> attr) {
        return this.sup != null ? this.sup.attribute(attr) : this.attribute0(attr);
    }

    private <T> T attribute00(Map.Entry<String, T> attr) {
        Object[] conf = ATTRIBS.get(this.name(attr));
        T type = this.type(attr);
        T value = this.oc.getAttribute0(this.name(attr), type);
        if (Capsule.isEmpty(value)) {
            value = this.defaultValue(type, conf != null ? conf[1] : null);
        }
        Capsule.setContext("attribute", attr.getKey(), value);
        return value;
    }

    private <T> T parseAttribute(String attr, T type, String s) {
        try {
            return Capsule.parse(this.expand(s), type, this);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Error parsing attribute " + attr + ". Expected " + Capsule.typeString(type) + " but was: " + s, e);
        }
    }

    private <T> T getAttribute0(String attr, T type) {
        Object value = null;
        String majorJavaVersion = Capsule.majorJavaVersion(this.oc.javaVersion);
        if (this.manifest != null) {
            value = Capsule.merge(value, this.parseAttribute(attr, type, Capsule.getAttributes(this.manifest, null, null).getValue(attr)));
            if (majorJavaVersion != null) {
                value = Capsule.merge(value, this.parseAttribute(attr, type, Capsule.getAttributes(this.manifest, null, "java-" + majorJavaVersion).getValue(attr)));
            }
            value = Capsule.merge(value, this.parseAttribute(attr, type, this.getPlatformAttribute(null, attr)));
            if (this.getMode() != null && this.allowsModal(attr)) {
                value = Capsule.merge(value, this.parseAttribute(attr, type, Capsule.getAttributes(this.manifest, this.mode, null).getValue(attr)));
                if (majorJavaVersion != null) {
                    value = Capsule.merge(value, this.parseAttribute(attr, type, Capsule.getAttributes(this.manifest, this.mode, "java-" + majorJavaVersion).getValue(attr)));
                }
                value = Capsule.merge(value, this.parseAttribute(attr, type, this.getPlatformAttribute(this.getMode(), attr)));
            }
            Capsule.setContext("attribute of " + this.jarFile, attr, value);
        }
        return value;
    }

    private String getPlatformAttribute(String mode, String attr) {
        if (PLATFORM == null) {
            return null;
        }
        String value = null;
        if (value == null) {
            value = Capsule.getAttributes(this.manifest, mode, PLATFORM).getValue(attr);
        }
        if (value == null && Capsule.isUnix()) {
            value = Capsule.getAttributes(this.manifest, mode, OS_UNIX).getValue(attr);
        }
        if (value == null && (Capsule.isUnix() || Capsule.isMac())) {
            value = Capsule.getAttributes(this.manifest, mode, OS_POSIX).getValue(attr);
        }
        return value;
    }

    private static Attributes getAttributes(Manifest manifest, String mode, String platform) {
        if (Capsule.emptyToNull(mode) == null && Capsule.emptyToNull(platform) == null) {
            return manifest.getMainAttributes();
        }
        if (Capsule.emptyToNull(mode) == null) {
            return Capsule.getAttributes(manifest, platform);
        }
        if (Capsule.emptyToNull(platform) == null) {
            return Capsule.getAttributes(manifest, mode);
        }
        return Capsule.getAttributes(manifest, mode + "-" + platform);
    }

    protected final boolean hasAttribute(Map.Entry<String, ?> attr) {
        return !Capsule.isEmpty(this.getAttribute(attr));
    }

    private boolean allowsModal(String attr) {
        Object[] vals = ATTRIBS.get(attr);
        return vals != null ? (Boolean)vals[2] : true;
    }

    protected static final String T_STRING() {
        return "";
    }

    protected static final Object T_FILE() {
        return Capsule.T_FILE("");
    }

    protected static final Object T_FILE(String type) {
        return new AtomicReference<String>(type);
    }

    protected static final Boolean T_BOOL() {
        return false;
    }

    protected static final Long T_LONG() {
        return 0L;
    }

    protected static final Double T_DOUBLE() {
        return 0.0;
    }

    protected static final <E> List<E> T_LIST(E type) {
        return Collections.singletonList(type);
    }

    protected static final <E> Set<E> T_SET(E type) {
        return Collections.singleton(type);
    }

    protected static final <K, V> Map<K, V> T_MAP(K keyType, V valType, V defaultValue) {
        if (defaultValue != null) {
            LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
            map.put(keyType, valType);
            map.put(null, Capsule.promote(defaultValue, valType));
            return map;
        }
        return Collections.singletonMap(keyType, valType);
    }

    private static boolean isValidType(Object type) {
        if (type == null) {
            return false;
        }
        Object etype = null;
        if (type instanceof Collection) {
            if (!(type instanceof List) && !(type instanceof Set)) {
                return false;
            }
            etype = ((Collection)type).iterator().next();
        } else if (type instanceof Map) {
            Map.Entry desc = ((Map)type).entrySet().iterator().next();
            etype = desc.getValue();
        } else if (type instanceof AtomicReference) {
            return ((AtomicReference)type).get() instanceof String;
        }
        if (etype != null) {
            if (etype instanceof Collection || etype instanceof Map) {
                return false;
            }
            return Capsule.isValidType(etype);
        }
        return ((Collection)Arrays.asList(String.class, Boolean.class, Long.class, Double.class)).contains(type.getClass());
    }

    private static String typeString(Object type) {
        if (type instanceof Collection) {
            Object etype = ((Collection)type).iterator().next();
            String collType = type instanceof Set ? "Set" : "List";
            return collType + " of " + Capsule.typeString(etype) + " in the form \"v1 v2 ...\"";
        }
        if (type instanceof Map) {
            Map.Entry desc = ((Map)type).entrySet().iterator().next();
            Object ktype = desc.getKey();
            Object vtype = desc.getValue();
            return "map of " + Capsule.typeString(ktype) + " to " + Capsule.typeString(vtype) + " in the form \"k1=v1 k2=v2 ...\"";
        }
        return type instanceof AtomicReference ? "path or dependency" : type.getClass().getSimpleName();
    }

    private <T> T defaultValue(T type, T d) {
        if (d == null) {
            if (type instanceof List) {
                return (T)Collections.emptyList();
            }
            if (type instanceof Set) {
                return (T)Collections.emptySet();
            }
            if (type instanceof Map) {
                return (T)Collections.emptyMap();
            }
        }
        return d;
    }

    static <T> T parse(String s, T type, Capsule capsule) {
        if (s == null) {
            return null;
        }
        if (type instanceof Collection) {
            Object etype = ((Collection)type).iterator().next();
            List<String> slist = Capsule.parse(s);
            AbstractCollection coll = type instanceof Set ? new LinkedHashSet() : new ArrayList();
            for (String se : slist) {
                coll.add(Capsule.parse(se, etype, capsule));
            }
            return (T)coll;
        }
        if (type instanceof Map) {
            Iterator it = ((Map)type).entrySet().iterator();
            Map.Entry desc = it.next();
            Object ktype = desc.getKey();
            Object vtype = desc.getValue();
            Object defaultValue = it.hasNext() ? (Object)it.next().getValue() : null;
            String sdefaultValue = defaultValue != null ? defaultValue.toString() : null;
            Map<String, String> smap = Capsule.parse(s, sdefaultValue);
            HashMap map = new HashMap();
            for (Map.Entry<String, String> se : smap.entrySet()) {
                map.put(Capsule.parsePrimitive(se.getKey(), ktype, capsule), Capsule.parsePrimitive(se.getValue(), vtype, capsule));
            }
            return (T)map;
        }
        return Capsule.parsePrimitive(s, type, capsule);
    }

    private static <T> T parsePrimitive(String s, T type, Capsule capsule) {
        if (s == null) {
            return null;
        }
        if (type instanceof AtomicReference) {
            return (T)capsule.sanitize(s);
        }
        if (type instanceof String) {
            return (T)s;
        }
        if (type instanceof Boolean) {
            return (T)Boolean.valueOf(Boolean.parseBoolean(s));
        }
        if (type instanceof Long) {
            return (T)Long.valueOf(Long.parseLong(s));
        }
        if (type instanceof Double) {
            return (T)Double.valueOf(Double.parseDouble(s));
        }
        throw new IllegalArgumentException("Unsupported primitive attribute type: " + type.getClass().getName());
    }

    private static <T> T promote(Object x, T type) {
        if (!(x instanceof Number) || !(type instanceof Number)) {
            return (T)x;
        }
        if (x instanceof Integer) {
            if (type instanceof Long) {
                x = (long)((Integer)x).intValue();
            } else if (type instanceof Double) {
                x = (double)((Integer)x).intValue();
            }
        }
        return (T)x;
    }

    private static List<String> parse(String value) {
        return Capsule.split(value, "\\s+");
    }

    private static Map<String, String> parse(String value, String defaultValue) {
        return Capsule.split(value, '=', "\\s+", defaultValue);
    }

    private static boolean hasFILE_T(Object type) {
        if (type instanceof Collection) {
            Object etype = ((Collection)type).iterator().next();
            return Capsule.hasFILE_T(etype);
        }
        if (type instanceof Map) {
            Map.Entry desc = ((Map)type).entrySet().iterator().next();
            Object ktype = desc.getKey();
            Object vtype = desc.getValue();
            return Capsule.hasFILE_T(ktype) || Capsule.hasFILE_T(vtype);
        }
        return type instanceof AtomicReference;
    }

    private <T> T lookupInAttribute(T value, Map.Entry<String, T> attrib) {
        return this.lookupInAttribute(value, this.type(attrib), attrib, value);
    }

    private <T, T1> T lookupInAttribute(Object o, T type, Map.Entry<String, T1> attrib, T1 value) {
        if (o == null) {
            return null;
        }
        if (type instanceof Collection) {
            Object etype = ((Collection)type).iterator().next();
            Collection coll0 = (Collection)o;
            AbstractCollection coll = type instanceof Set ? new LinkedHashSet() : new ArrayList();
            for (Object e : coll0) {
                coll.add(e instanceof String ? this.lookupInAttribute(e, etype, attrib, value) : e);
            }
            return (T)coll;
        }
        if (type instanceof Map) {
            Iterator it = ((Map)type).entrySet().iterator();
            Map.Entry desc = it.next();
            Object ktype = desc.getKey();
            Object vtype = desc.getValue();
            Map map0 = (Map)o;
            HashMap map = new HashMap();
            for (Map.Entry e : map0.entrySet()) {
                map.put(this.lookupInAttribute(e.getKey(), ktype, attrib, value), this.lookupInAttribute(e.getValue(), vtype, attrib, value));
            }
            return (T)map;
        }
        if (type instanceof AtomicReference) {
            return (T)(o instanceof String ? this.lookup((String)o, (String)((AtomicReference)type).get(), attrib, value instanceof Map ? ((Map)value).get(o) : null) : o);
        }
        return (T)o;
    }

    private static Attributes getAttributes(Manifest manifest, String name) {
        for (Map.Entry<String, Attributes> entry : manifest.getEntries().entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(name)) continue;
            return entry.getValue();
        }
        return EMPTY_ATTRIBUTES;
    }

    private static boolean isDependency(String lib) {
        return lib.contains(":") && !lib.contains(":\\");
    }

    private Path dependencyToLocalJar(Path jar, String dep, String type, Map.Entry<String, ?> attrContext) {
        String res = Capsule.dependencyToLocalJar0(jar, dep, type, attrContext);
        return res != null ? this.path(Capsule.toNativePath(res), new String[0]) : null;
    }

    private static String dependencyToLocalJar0(Path jar, String dep, String type, Map.Entry<String, ?> attrContext) {
        Matcher m = PAT_DEPENDENCY.matcher(dep);
        if (!m.matches()) {
            throw new IllegalArgumentException("Could not parse dependency: " + dep);
        }
        String group = Capsule.emptyToNull(m.group("groupId"));
        String artifact = Capsule.emptyToNull(m.group("artifactId"));
        String version = Capsule.emptyToNull(m.group("version"));
        String classifier = Capsule.emptyToNull(m.group("classifier"));
        boolean caplet = ATTR_CAPLETS.equals(attrContext);
        String libdir = caplet ? CACHE_DEFAULT_NAME : "lib";
        String filename = artifact + (version != null ? '-' + version : "") + (classifier != null ? '-' + classifier : "") + "." + type;
        ArrayList<String> names = new ArrayList<String>();
        if (group != null) {
            names.add(libdir + '/' + group + '/' + filename);
            names.add(libdir + '/' + group + '-' + filename);
        }
        names.add(libdir + '/' + filename);
        if (group != null) {
            names.add(group + "/" + filename);
            names.add(group + '-' + filename);
        }
        names.add(filename);
        Collections.reverse(names);
        int index = -1;
        try {
            for (String entry : Capsule.cachedEntries(jar)) {
                index = Math.max(index, names.indexOf(entry));
            }
        }
        catch (IOException e) {
            throw Capsule.rethrow(e);
        }
        return index >= 0 ? (String)names.get(index) : null;
    }

    protected final Object lookup(String x, String type, Map.Entry<String, ?> attrContext, Object context) {
        Object res = this.cc.lookup0(x, Capsule.nullToEmpty(type), attrContext, context);
        Capsule.log(3, "lookup " + x + "(" + type + ", " + this.name(attrContext) + ") -> " + res);
        if (res == null) {
            throw new RuntimeException("Lookup for " + x + " has failed.");
        }
        return res;
    }

    protected final Object lookup(String x) {
        return this.lookup(x, null, null, null);
    }

    protected final Object lookup(String x, Map.Entry<String, ?> attrContext) {
        return this.lookup(x, null, attrContext, null);
    }

    protected Object lookup0(Object x, String type, Map.Entry<String, ?> attrContext, Object context) {
        this._ct = this.unsafe(this.getCallTarget(Capsule.class));
        String target = (this._ct != null ? this._ct.getClass().getName() : Capsule.class.getName()) + '@' + Integer.toHexString(System.identityHashCode(this._ct));
        Capsule.log(3, "lookup0 " + target + " " + x);
        Object res = this._ct != null ? this._ct.lookup0(x, type, attrContext, context) : this.lookup00(x, type, attrContext, context);
        Capsule.log(3, "lookup0 " + target + " " + x + " -> " + res);
        return res;
    }

    private Object lookup00(Object x, String type, Map.Entry<String, ?> attrContext, Object context) {
        if (x instanceof String) {
            String desc = (String)x;
            boolean isDependency = Capsule.isDependency(desc);
            if (!isDependency) {
                if (!desc.contains(".") && !type.isEmpty()) {
                    desc = desc + "." + type;
                }
                desc = Capsule.toNativePath(desc);
            }
            x = isDependency ? this.dependencyToLocalJar(this.getJarFile(), desc, type.isEmpty() ? "jar" : type, attrContext) : (Capsule.isGlob(desc) ? this.listJar(this.getJarFile(), desc, false) : this.path(desc, new String[0]));
        }
        if (x == null) {
            return null;
        }
        if (ATTR_NATIVE_DEPENDENCIES.equals(attrContext) && type != null && !"jar".equals(type)) {
            if (x instanceof Map.Entry) {
                x = ((Map.Entry)x).getValue();
            }
            x = new Object[]{x, context};
        }
        if (Arrays.asList(ATTR_APP_ARTIFACT, ATTR_SCRIPT, ATTR_NATIVE_DEPENDENCIES).contains(attrContext) && !(x instanceof Map.Entry)) {
            x = Capsule.mutableEntry(attrContext, x);
        }
        return x;
    }

    protected final List<Path> resolve(Object x) {
        List<Path> res = this.cc.resolve0(x);
        Capsule.log(3, "resolve " + x + " -> " + res);
        if (res == null) {
            throw new RuntimeException("Could not resolve " + x);
        }
        if (res.isEmpty()) {
            Capsule.log(2, "WARNING resolve " + x + " was empty");
        }
        return res;
    }

    private List<Path> resolve(List<Object> ps) {
        if (ps == null) {
            return null;
        }
        ArrayList<Path> res = new ArrayList<Path>(ps.size());
        for (Object p : ps) {
            Capsule.addAllIfAbsent(res, this.resolve(p));
        }
        return res;
    }

    protected List<Path> resolve0(Object x) {
        this._ct = this.unsafe(this.getCallTarget(Capsule.class));
        String target = (this._ct != null ? this._ct.getClass().getName() : Capsule.class.getName()) + '@' + Integer.toHexString(System.identityHashCode(this._ct));
        Capsule.log(3, "resolve0 " + target + " " + x);
        List<Path> res = this._ct != null ? this._ct.resolve0(x) : this.resolve00(x);
        Capsule.log(3, "resolve0 " + target + " " + x + " -> " + res);
        return res;
    }

    private List<Path> resolve00(Object x) {
        if (x == null) {
            return null;
        }
        if (x instanceof Collection) {
            ArrayList<Path> res = new ArrayList<Path>();
            for (Object xe : (Collection)x) {
                Capsule.addAllIfAbsent(res, this.resolve(xe));
            }
            return res;
        }
        if (x instanceof Map.Entry) {
            Map.Entry context = (Map.Entry)x;
            Map.Entry attr = (Map.Entry)context.getKey();
            x = context.getValue();
            if (x instanceof Collection) {
                ArrayList<Path> res = new ArrayList<Path>();
                for (Object xe : (Collection)x) {
                    Capsule.addAllIfAbsent(res, this.resolve(Capsule.mutableEntry(context, xe)));
                }
                return res;
            }
            if (ATTR_APP_ARTIFACT.equals(attr)) {
                List<Path> jars = x instanceof Path ? Arrays.asList((Path)x) : (x instanceof List && Capsule.firstOrNull((List)x) instanceof Path ? (List<Path>)x : this.resolve(x));
                Path jar = this.simpleResolve(Capsule.firstOrNull(jars));
                Manifest man = Capsule.getManifest(jar);
                this.oc.appArtifactMainClass = Capsule.getMainClass(man);
                List<Path> res = jars;
                x = res;
            } else if (ATTR_SCRIPT.equals(attr)) {
                Capsule.ensureExecutable(this.simpleResolve(x));
            } else if (ATTR_NATIVE_DEPENDENCIES.equals(attr)) {
                Object[] fileAndRename = (Object[])x;
                Path lib = Capsule.only(this.resolve(fileAndRename[0]));
                String rename = (String)fileAndRename[1];
                Path res = lib;
                if (rename != null && !lib.startsWith(this.getWritableAppCache())) {
                    try {
                        res = this.getWritableAppCache().resolve(rename);
                        Capsule.log(3, "Copying native lib " + lib + " to " + res);
                        Files.copy(lib, res, StandardCopyOption.REPLACE_EXISTING);
                        fileAndRename[0] = res;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Exception while copying native libs", e);
                    }
                }
                x = res;
            }
            return this.resolve(x);
        }
        if (x instanceof Path && ((Path)x).isAbsolute()) {
            Path p = ((Path)x).normalize();
            Path currentJavaHome = Paths.get(System.getProperty(PROP_JAVA_HOME), new String[0]);
            if (p.startsWith(Paths.get(System.getProperty(PROP_JAVA_HOME), new String[0]))) {
                p = Capsule.move(p, currentJavaHome, this.getJavaHome());
            }
            return Collections.singletonList(p);
        }
        Path p = this.simpleResolve(x);
        if (p != null) {
            return this.resolve(p);
        }
        throw new RuntimeException("Could not resolve item " + x);
    }

    private Path simpleResolve(Object x) {
        URL url;
        if (x instanceof Path) {
            Path p = (Path)x;
            p = p.isAbsolute() ? p : this.appDir().resolve(p);
            p = p.toAbsolutePath().normalize();
            return p;
        }
        if (x instanceof URL && "jar".equals((url = (URL)x).getProtocol())) {
            if (!this.path(Capsule.getBefore(url.getPath(), '!'), new String[0]).toAbsolutePath().equals(this.getJarFile())) {
                throw new AssertionError((Object)("URL " + url + " not pointing at capsule JAR " + this.getJarFile()));
            }
            return this.simpleResolve(this.path(Capsule.getAfter(url.getPath(), '!').substring(1), new String[0]));
        }
        return null;
    }

    private List<Path> resolveJar(Path jar, Manifest man) {
        if (man == null) {
            man = Capsule.getManifest(jar);
        }
        ArrayList<Path> res = new ArrayList<Path>();
        res.add(jar);
        jar = this.simpleResolve(jar);
        for (String e : Capsule.nullToEmpty(Capsule.parse(man.getMainAttributes().getValue(ATTR_CLASS_PATH)))) {
            Path p;
            try {
                p = this.path(new URL(e).toURI());
            }
            catch (MalformedURLException | URISyntaxException ex) {
                p = jar.getParent().resolve(this.path(Capsule.toNativePath(e), new String[0]));
            }
            if (res.contains(p)) continue;
            res.add(Capsule.toAbsolutePath(p));
        }
        return res;
    }

    private String processOutgoingPath(Object p) {
        return Capsule.toString(Capsule.firstOrNull(this.resolve(p)));
    }

    private static void extractJar(JarInputStream jar, Path targetDir) throws IOException {
        JarEntry entry;
        while ((entry = jar.getNextJarEntry()) != null) {
            if (entry.isDirectory() || !Capsule.shouldExtractFile(entry.getName())) continue;
            if (Files.exists(targetDir.resolve(entry.getName()), new LinkOption[0])) {
                Capsule.log(1, "Warning: duplicate file " + entry.getName() + " in capsule");
                continue;
            }
            Capsule.writeFile(targetDir, entry.getName(), jar);
        }
    }

    private static boolean shouldExtractFile(String fileName) {
        if (fileName.equals(Capsule.class.getName().replace('.', '/') + ".class") || fileName.startsWith(Capsule.class.getName().replace('.', '/') + "$") && fileName.endsWith(".class")) {
            return false;
        }
        if (fileName.endsWith(".class")) {
            return false;
        }
        if (fileName.startsWith("capsule/") && !fileName.endsWith(".jar")) {
            return false;
        }
        return !fileName.startsWith("META-INF/");
    }

    private List<Path> listJar(Path jar, String glob, boolean regular) {
        long start = Capsule.clock();
        ArrayList<Path> res = new ArrayList<Path>();
        Pattern p = Pattern.compile(Capsule.globToRegex(glob));
        try (JarInputStream zis = Capsule.openJarInputStream(jar);){
            ZipEntry entry;
            while ((entry = ((ZipInputStream)zis).getNextEntry()) != null) {
                if (regular && entry.isDirectory() || !p.matcher(entry.getName()).matches()) continue;
                res.add(this.path(entry.getName(), new String[0]));
            }
        }
        catch (IOException e) {
            throw Capsule.rethrow(e);
        }
        Capsule.time("listJar", start);
        return res;
    }

    /*
     * Exception decompiling
     */
    private Path mergeCapsule(Path wrapperCapsule, Path wrappedCapsule, Path outCapsule) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private FileSystem getFileSystem() {
        return this.cc.jarFile != null ? this.cc.jarFile.getFileSystem() : FileSystems.getDefault();
    }

    private Path path(String p, String ... more) {
        return this.getFileSystem().getPath(p, more);
    }

    private Path path(URI uri) {
        return this.getFileSystem().provider().getPath(uri);
    }

    private List<Path> toPath(List<String> ps) {
        if (ps == null) {
            return null;
        }
        ArrayList<Path> aps = new ArrayList<Path>(ps.size());
        for (String p : ps) {
            aps.add(this.path(p, new String[0]));
        }
        return aps;
    }

    private static Path toAbsolutePath(Path p) {
        return p != null ? p.toAbsolutePath().normalize() : null;
    }

    private static List<Path> resolve(Path root, List<String> ps) {
        if (ps == null) {
            return null;
        }
        ArrayList<Path> aps = new ArrayList<Path>(ps.size());
        for (String p : ps) {
            aps.add(root.resolve(p));
        }
        return aps;
    }

    private Path sanitize(Path p) {
        if (p == null) {
            return null;
        }
        Path path = p.normalize();
        if (p.isAbsolute()) {
            if (this.getAppDir() != null && path.startsWith(this.getAppDir())) {
                return path;
            }
            if (path.startsWith(this.getJavaHome()) || path.startsWith(Paths.get(System.getProperty(PROP_JAVA_HOME), new String[0]))) {
                return path;
            }
        } else if (!path.startsWith("..")) {
            return path;
        }
        throw new IllegalArgumentException("Path " + p + " is not local to app cache " + this.getAppDir());
    }

    private String sanitize(String p) {
        if (Capsule.isDependency(p)) {
            return p;
        }
        if (p.contains("/") || p.contains(FILE_SEPARATOR)) {
            p = Capsule.toNativePath(p);
            this.sanitize(Paths.get(p, new String[0]));
        }
        return p;
    }

    private static Path toFriendlyPath(Path p) {
        Path rel;
        if (p.isAbsolute() && (rel = p.getFileSystem().getPath("", new String[0]).toAbsolutePath().relativize(p)).normalize().equals(rel)) {
            return rel;
        }
        return p;
    }

    protected static Path move(Path what, Path fromDir, Path toDir) {
        if (!what.startsWith(fromDir)) {
            throw new IllegalArgumentException(what + " is not under " + fromDir);
        }
        return toDir.resolve(fromDir.relativize(what));
    }

    protected static final boolean isWindows() {
        return PLATFORM == OS_WINDOWS;
    }

    protected static final boolean isMac() {
        return PLATFORM == OS_MACOS;
    }

    protected static final boolean isUnix() {
        return PLATFORM == OS_LINUX || PLATFORM == OS_SOLARIS || PLATFORM == OS_BSD || PLATFORM == OS_AIX || PLATFORM == OS_HP_UX;
    }

    private static String getOS() {
        if (OS.startsWith(OS_WINDOWS)) {
            return OS_WINDOWS;
        }
        if (OS.startsWith("mac")) {
            return OS_MACOS;
        }
        if (OS.contains(OS_LINUX)) {
            return OS_LINUX;
        }
        if (OS.contains(OS_SOLARIS) || OS.contains("sunos") || OS.contains("illumos")) {
            return OS_SOLARIS;
        }
        if (OS.contains(OS_BSD)) {
            return OS_BSD;
        }
        if (OS.contains(OS_AIX)) {
            return OS_AIX;
        }
        if (OS.contains(OS_HP_UX)) {
            return OS_HP_UX;
        }
        if (OS.contains(OS_VMS)) {
            return OS_VMS;
        }
        Capsule.log(1, "WARNING Unrecognized OS: " + System.getProperty(PROP_OS_NAME));
        return null;
    }

    protected static final String getNativeLibExtension() {
        if (Capsule.isWindows()) {
            return "dll";
        }
        if (Capsule.isMac()) {
            return "dylib";
        }
        if (Capsule.isUnix()) {
            return "so";
        }
        throw new RuntimeException("Unsupported operating system: " + System.getProperty(PROP_OS_NAME));
    }

    private static long getMaxCommandLineLength() {
        if (Capsule.isWindows()) {
            return 32500L;
        }
        return Long.MAX_VALUE;
    }

    private static JarInputStream openJarInputStream(Path jar) throws IOException {
        return new JarInputStream(Capsule.skipToZipStart(Files.newInputStream(jar, new OpenOption[0]), null));
    }

    private static JarInputStream copyJarPrefix(InputStream is, OutputStream os) throws IOException {
        return new JarInputStream(Capsule.skipToZipStart(is, null));
    }

    protected static InputStream getEntryInputStream(Path jar, String name) throws IOException {
        return Capsule.getEntry(Capsule.openJarInputStream(jar), name);
    }

    private static InputStream getEntry(ZipInputStream zis, String name) throws IOException {
        ZipEntry entry;
        while ((entry = zis.getNextEntry()) != null) {
            if (!entry.getName().equals(name)) continue;
            return zis;
        }
        return null;
    }

    private static String getMainClass(Path jar) {
        return Capsule.getMainClass(Capsule.getManifest(jar));
    }

    private static String getMainClass(Manifest manifest) {
        if (manifest == null) {
            return null;
        }
        return manifest.getMainAttributes().getValue(ATTR_MAIN_CLASS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Manifest getManifest(Path jar) {
        try (JarInputStream jis = Capsule.openJarInputStream(jar);){
            Manifest manifest = jis.getManifest();
            return manifest;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading manifest from " + jar, e);
        }
    }

    private static Iterable<String> cachedEntries(Path jar) throws IOException {
        Map<Path, List<String>> cache = jarEntriesCache;
        if (cache != null && cache.containsKey(jar)) {
            return cache.get(jar);
        }
        ArrayList<String> entries = new ArrayList<String>();
        try (JarInputStream zis = Capsule.openJarInputStream(jar);){
            ZipEntry entry;
            while ((entry = ((ZipInputStream)zis).getNextEntry()) != null) {
                entries.add(entry.getName());
            }
        }
        if (cache != null) {
            cache.put(jar, entries);
        }
        return entries;
    }

    private static InputStream skipToZipStart(InputStream is, OutputStream os) throws IOException {
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        int state = 0;
        while (true) {
            int b;
            if (state == 0) {
                is.mark(ZIP_HEADER.length);
            }
            if ((b = is.read()) < 0) {
                throw new IllegalArgumentException("Not a JAR/ZIP file");
            }
            if (state >= 0 && b == ZIP_HEADER[state]) {
                if (++state == ZIP_HEADER.length) {
                    break;
                }
            } else {
                state = -1;
                if (b == 10 || b == 0) {
                    state = 0;
                }
            }
            if (os == null) continue;
            os.write(b);
        }
        is.reset();
        return is;
    }

    private static void writeFile(Path targetDir, String fileName, InputStream is) throws IOException {
        String dir = Capsule.getDirectory(fileName = Capsule.toNativePath(fileName));
        if (dir != null) {
            Files.createDirectories(targetDir.resolve(dir), new FileAttribute[0]);
        }
        Path targetFile = targetDir.resolve(fileName);
        Files.copy(is, targetFile, new CopyOption[0]);
    }

    private static String toNativePath(String filename) {
        if (filename.contains("://")) {
            return filename;
        }
        char ps = !filename.contains("/") && filename.contains("\\") ? (char)'\\' : '/';
        return ps != FILE_SEPARATOR_CHAR ? filename.replace(ps, FILE_SEPARATOR_CHAR) : filename;
    }

    private static String getDirectory(String filename) {
        int index = filename.lastIndexOf(FILE_SEPARATOR_CHAR);
        if (index < 0) {
            return null;
        }
        return filename.substring(0, index);
    }

    static void delete(Path path) throws IOException {
        Capsule.log(3, "Deleting " + path);
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(path);){
                for (Path f : ds) {
                    Capsule.delete(f);
                }
            }
        }
        Files.delete(path);
    }

    static void copy(Path source, Path target) throws IOException {
        Files.copy(source, target, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        if (Files.isDirectory(source, new LinkOption[0])) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(source);){
                for (Path f : ds) {
                    Capsule.copy(f, target.resolve(f.getFileName()));
                }
            }
        }
    }

    private static Path ensureExecutable(Path file) {
        if (!Files.isExecutable(file)) {
            try {
                Set<PosixFilePermission> perms = Files.getPosixFilePermissions(file, new LinkOption[0]);
                if (!perms.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
                    EnumSet<PosixFilePermission> newPerms = EnumSet.copyOf(perms);
                    newPerms.add(PosixFilePermission.OWNER_EXECUTE);
                    Files.setPosixFilePermissions(file, newPerms);
                }
            }
            catch (UnsupportedOperationException perms) {
            }
            catch (IOException e) {
                throw Capsule.rethrow(e);
            }
        }
        return file;
    }

    static void copy(InputStream is, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        while ((bytesRead = is.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        out.flush();
    }

    private static Path getTempDir() {
        try {
            return Paths.get(Capsule.getProperty(PROP_TMP_DIR), new String[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Path getExistingAncestor(Path p) {
        for (p = p.toAbsolutePath().getParent(); p != null && !Files.exists(p, new LinkOption[0]); p = p.getParent()) {
        }
        return p;
    }

    protected static FileAttribute<?>[] getPermissions(Path p) throws IOException {
        ArrayList<FileAttribute<Set<PosixFilePermission>>> attrs = new ArrayList<FileAttribute<Set<PosixFilePermission>>>();
        PosixFileAttributeView posix = Files.getFileAttributeView(p, PosixFileAttributeView.class, new LinkOption[0]);
        if (posix != null) {
            attrs.add(PosixFilePermissions.asFileAttribute(posix.readAttributes().permissions()));
        }
        return attrs.toArray(new FileAttribute[attrs.size()]);
    }

    private static boolean isGlob(String s) {
        return s.contains("*") || s.contains("?") || s.contains("{") || s.contains("[");
    }

    private static boolean isJDK(Path javaHome) {
        String name = javaHome.toString().toLowerCase();
        return !name.contains("jre") && (name.contains("jdk") || Files.exists(javaHome.resolve("include").resolve("jni.h"), new LinkOption[0]));
    }

    protected static Map<String, List<Path>> getJavaHomes() {
        if (JAVA_HOMES == null) {
            try {
                Map<String, List<Path>> homes;
                Path homesDir = null;
                for (Path d = Paths.get(Capsule.getProperty(PROP_JAVA_HOME), new String[0]); d != null; d = d.getParent()) {
                    if (d.getFileName() == null || Capsule.isJavaDir(d.getFileName().toString()) == null) continue;
                    homesDir = d.getParent();
                    break;
                }
                if ((homes = Capsule.getJavaHomes(homesDir)) != null && Capsule.isWindows()) {
                    homes = Capsule.windowsJavaHomesHeuristics(homesDir, homes);
                }
                JAVA_HOMES = homes;
            }
            catch (IOException e) {
                throw Capsule.rethrow(e);
            }
        }
        return JAVA_HOMES;
    }

    private static Map<String, List<Path>> windowsJavaHomesHeuristics(Path dir, Map<String, List<Path>> homes) throws IOException {
        Path dir2 = null;
        if (dir.startsWith(WINDOWS_PROGRAM_FILES_1)) {
            dir2 = WINDOWS_PROGRAM_FILES_2.resolve(WINDOWS_PROGRAM_FILES_1.relativize(dir));
        } else if (dir.startsWith(WINDOWS_PROGRAM_FILES_2)) {
            dir2 = WINDOWS_PROGRAM_FILES_1.resolve(WINDOWS_PROGRAM_FILES_2.relativize(dir));
        }
        if (dir2 != null) {
            HashMap<String, List<Path>> allHomes = new HashMap<String, List<Path>>(Capsule.nullToEmpty(homes));
            Capsule.multiputAll(allHomes, Capsule.nullToEmpty(Capsule.getJavaHomes(dir2)));
            return allHomes;
        }
        return homes;
    }

    private static Map<String, List<Path>> getJavaHomes(Path dir) throws IOException {
        if (dir == null || !Files.isDirectory(dir, new LinkOption[0])) {
            return null;
        }
        HashMap<String, List<Path>> dirs = new HashMap<String, List<Path>>();
        try (DirectoryStream<Path> fs = Files.newDirectoryStream(dir);){
            for (Path f : fs) {
                List<Path> homes;
                String ver;
                if (!Files.isDirectory(f, new LinkOption[0]) || (ver = Capsule.isJavaDir(f.getFileName().toString())) == null || (homes = Capsule.searchJavaHomeInDir(f)) == null || homes.size() <= 0) continue;
                if (Capsule.parseJavaVersion(ver)[3] == 0) {
                    ver = Capsule.getActualJavaVersion(Capsule.first(homes));
                }
                Capsule.multiput(dirs, ver, homes);
            }
        }
        return dirs;
    }

    private static String getJavaVersion(Path home) {
        if (home == null) {
            return null;
        }
        for (Path f = home; f != null && f.getNameCount() > 0; f = f.getParent()) {
            String ver = Capsule.isJavaDir(f.getFileName().toString());
            if (ver == null) continue;
            return ver;
        }
        return Capsule.getActualJavaVersion(home);
    }

    static String isJavaDir(String fileName) {
        if (((fileName = fileName.toLowerCase()).startsWith("java-") || fileName.startsWith("jdk-") || fileName.startsWith("jre-")) && (fileName.contains("-openjdk") || fileName.contains("-oracle"))) {
            Matcher m = Pattern.compile("^[^\\-]+-([0-9\\.]+)-").matcher(fileName);
            if (!m.find()) {
                throw new RuntimeException("Cannot parse Java directory name: " + fileName);
            }
            return Capsule.shortJavaVersion(m.group(1));
        }
        if (fileName.startsWith("jdk-") && (fileName.contains("-openjdk") || fileName.contains("-oracle"))) {
            Matcher m = Pattern.compile("java-([0-9]+)-").matcher(fileName);
            m.find();
            return Capsule.shortJavaVersion(m.group(1));
        }
        if (fileName.startsWith("jdk") || fileName.startsWith("jre") || fileName.endsWith(".jdk") || fileName.endsWith(".jre")) {
            if (fileName.startsWith("jdk-") || fileName.startsWith("jre-")) {
                fileName = fileName.substring(4);
            } else if (fileName.startsWith("jdk") || fileName.startsWith("jre")) {
                fileName = fileName.substring(3);
            }
            if (fileName.endsWith(".jdk") || fileName.endsWith(".jre")) {
                fileName = fileName.substring(0, fileName.length() - 4);
            }
            return Capsule.shortJavaVersion(fileName);
        }
        return null;
    }

    private static List<Path> searchJavaHomeInDir(Path dir) throws IOException {
        ArrayList<Path> homes = new ArrayList<Path>();
        boolean jdk = Capsule.isJDK(dir);
        if (Capsule.isJavaHome(dir)) {
            homes.add(dir.toAbsolutePath());
        }
        try (DirectoryStream<Path> fs = Files.newDirectoryStream(dir);){
            for (Path f : fs) {
                if (!Files.isDirectory(f, new LinkOption[0])) continue;
                if (Capsule.isJavaHome(f)) {
                    homes.add(f.toAbsolutePath());
                }
                if (homes.size() >= 2) break;
                if (homes.size() >= 1 && !jdk && !Capsule.isJDK(f)) {
                    break;
                }
                List<Path> rec = Capsule.searchJavaHomeInDir(f);
                if (rec == null) continue;
                homes.addAll(rec);
            }
        }
        return homes;
    }

    private static boolean isJavaHome(Path dir) {
        return Files.isRegularFile(dir.resolve("bin").resolve("java" + (Capsule.isWindows() ? ".exe" : "")), new LinkOption[0]);
    }

    private static Path getJavaExecutable0(Path javaHome) {
        String exec = Capsule.isWindows() && System.console() == null ? "javaw" : "java";
        return javaHome.resolve("bin").resolve(exec + (Capsule.isWindows() ? ".exe" : ""));
    }

    private static String getActualJavaVersion(Path javaHome) {
        try {
            String versionLine = Capsule.first(Capsule.exec(1, true, new ProcessBuilder(Arrays.asList(Capsule.getJavaExecutable0(javaHome).toString(), "-version"))));
            Matcher m = PAT_JAVA_VERSION_LINE.matcher(versionLine);
            if (!m.matches()) {
                throw new IllegalArgumentException("Could not parse version line: " + versionLine);
            }
            String version = m.group(1);
            return version;
        }
        catch (Exception e) {
            throw Capsule.rethrow(e);
        }
    }

    static String shortJavaVersion(String v) {
        try {
            String[] vs = v.split(SEPARATOR_DOT);
            if (vs.length == 1) {
                if (Integer.parseInt(vs[0]) < 5) {
                    throw new RuntimeException("Unrecognized major Java version: " + v);
                }
                v = "1." + v + ".0";
            }
            if (vs.length == 2) {
                v = v + ".0";
            }
            return v;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static String majorJavaVersion(String v) {
        if (v == null) {
            return null;
        }
        String[] vs = v.split(SEPARATOR_DOT);
        if (vs.length == 1) {
            return vs[0];
        }
        if (vs.length >= 2) {
            return vs[1];
        }
        throw new AssertionError((Object)"unreachable");
    }

    protected static final int compareVersions(String a, String b, int n) {
        return Capsule.compareVersions(Capsule.parseJavaVersion(a), Capsule.parseJavaVersion(b), n);
    }

    protected static final int compareVersions(String a, String b) {
        return Capsule.compareVersions(Capsule.parseJavaVersion(a), Capsule.parseJavaVersion(b));
    }

    private static int compareVersions(int[] a, int[] b) {
        return Capsule.compareVersions(a, b, 5);
    }

    private static int compareVersions(int[] a, int[] b, int n) {
        for (int i = 0; i < n; ++i) {
            if (a[i] == b[i]) continue;
            return a[i] - b[i];
        }
        return 0;
    }

    private static boolean equals(int[] a, int[] b, int n) {
        for (int i = 0; i < n; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    static int[] parseJavaVersion(String v) {
        String pre;
        Matcher m = PAT_JAVA_VERSION.matcher(v);
        if (!m.matches()) {
            throw new IllegalArgumentException("Could not parse version: " + v);
        }
        int[] ver = new int[5];
        ver[0] = Capsule.toInt(m.group("major"));
        ver[1] = Capsule.toInt(m.group("minor"));
        ver[2] = Capsule.toInt(m.group("patch"));
        ver[3] = Capsule.toInt(m.group("update"));
        if (ver[0] > 1 && ver[1] == 0) {
            ver[1] = ver[0];
            ver[0] = 1;
        }
        if ((pre = m.group("pre")) != null) {
            if (pre.startsWith("rc")) {
                ver[4] = -1;
            } else if (pre.startsWith("beta")) {
                ver[4] = -2;
            } else if (pre.startsWith("ea")) {
                ver[4] = -3;
            }
        }
        return ver;
    }

    static String toJavaVersionString(int[] version) {
        StringBuilder sb = new StringBuilder();
        sb.append(version[0]).append('.');
        sb.append(version[1]).append('.');
        sb.append(version[2]);
        if (version.length > 3 && version[3] > 0) {
            sb.append('_').append(version[3]);
        }
        if (version.length > 4 && version[4] != 0) {
            String pre;
            switch (version[4]) {
                case -1: {
                    pre = "rc";
                    break;
                }
                case -2: {
                    pre = "beta";
                    break;
                }
                case -3: {
                    pre = "ea";
                    break;
                }
                default: {
                    pre = "?";
                }
            }
            sb.append('-').append(pre);
        }
        return sb.toString();
    }

    private static int toInt(String s) {
        return s != null ? Integer.parseInt(s) : 0;
    }

    private static int[] toInt(String[] ss) {
        int[] res = new int[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            res[i] = ss[i] != null ? Integer.parseInt(ss[i]) : 0;
        }
        return res;
    }

    private String expand(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = PAT_VAR.matcher(str);
        while (m.find()) {
            m.appendReplacement(sb, Matcher.quoteReplacement(this.getVarValue(Capsule.xor(m.group(1), m.group(2)))));
        }
        m.appendTail(sb);
        str = sb.toString();
        return str;
    }

    protected String getVarValue(String var) {
        this._ct = this.getCallTarget(Capsule.class);
        return this._ct != null ? this._ct.getVarValue(var) : this.getVarValue0(var);
    }

    private String getVarValue0(String var) {
        String value = null;
        switch (var) {
            case "CAPSULE_DIR": {
                try {
                    value = this.processOutgoingPath(this.appDir());
                    break;
                }
                catch (IllegalStateException e) {
                    throw new IllegalStateException("Cannot resolve variable $" + var, e);
                }
            }
            case "CAPSULE_APP": {
                if (this.getAppId() == null) {
                    throw new RuntimeException("Cannot resolve variable $" + var + " in an empty capsule.");
                }
                value = this.getAppId();
                break;
            }
            case "CAPSULE_JAR": 
            case "0": {
                value = this.processOutgoingPath(this.getJarFile());
                break;
            }
            case "JAVA_HOME": {
                String jhome = this.processOutgoingPath(this.getJavaHome());
                if (jhome == null) {
                    throw new RuntimeException("Cannot resolve variable $" + var + "; Java home not set.");
                }
                value = jhome;
            }
        }
        if (value == null && (value = Capsule.getProperty(var)) != null) {
            Capsule.log(3, "Resolved variable $" + var + " with a property");
        }
        if (value == null && (value = Capsule.getenv(var)) != null) {
            Capsule.log(3, "Resolved variable $" + var + " with an environement variable");
        }
        if (value == null) {
            throw new RuntimeException("Cannot resolve variable $" + var);
        }
        return value;
    }

    private static String toString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Path) {
            return Capsule.toString((Path)o);
        }
        return o.toString();
    }

    private static String toString(Path p) {
        String s = p.toString();
        if (FILE_SEPARATOR_CHAR != '/' && Capsule.isUnix()) {
            s = s.replace(FILE_SEPARATOR_CHAR, '/');
        }
        return s;
    }

    private static List<String> split(String str, String separator) {
        if (str == null) {
            return null;
        }
        String[] es = str.split(separator);
        ArrayList<String> list = new ArrayList<String>(es.length);
        for (String e : es) {
            if ((e = e.trim()).isEmpty()) continue;
            list.add(e);
        }
        return list;
    }

    private static Map<String, String> split(String map, char kvSeparator, String separator, String defaultValue) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        for (String entry : Capsule.split(map, separator)) {
            String key = Capsule.getBefore(entry, kvSeparator);
            String value = Capsule.getAfter(entry, kvSeparator);
            if (value == null) {
                if (defaultValue != null) {
                    value = defaultValue;
                } else {
                    throw new IllegalArgumentException("Element " + entry + " in \"" + map + "\" is not a key-value entry separated with " + kvSeparator + " and no default value provided");
                }
            }
            m.put(key.trim(), value.trim());
        }
        return m;
    }

    private static String join(Collection<?> coll, String separator) {
        if (coll == null) {
            return null;
        }
        if (coll.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object e : coll) {
            if (e == null) continue;
            sb.append(Capsule.toString(e)).append(separator);
        }
        sb.delete(sb.length() - separator.length(), sb.length());
        return sb.toString();
    }

    private static String getBefore(String s, char separator) {
        int i = s.indexOf(separator);
        if (i < 0) {
            return s;
        }
        return s.substring(0, i);
    }

    private static String getAfter(String s, char separator) {
        int i = s.indexOf(separator);
        if (i < 0) {
            return null;
        }
        return s.substring(i + 1);
    }

    private static long getStringsLength(Collection<?> coll) {
        if (coll == null) {
            return 0L;
        }
        long len = 0L;
        for (Object o : coll) {
            len += (long)o.toString().length();
        }
        return len;
    }

    private static String nullToEmpty(String s) {
        return s != null ? s : "";
    }

    private static String emptyToNull(String s) {
        if (s == null) {
            return null;
        }
        return (s = s.trim()).isEmpty() ? null : s;
    }

    private static <T> T xor(T x, T y) {
        assert (x == null ^ y == null);
        return x != null ? x : y;
    }

    static List<String> parseCommandLineArguments(String str) {
        if (str == null || str.length() == 0) {
            return Collections.emptyList();
        }
        boolean NORMAL = false;
        boolean IN_QUOTE = true;
        int IN_DOUBLE_QUOTE = 2;
        StringTokenizer tok = new StringTokenizer(str, "\"'\\ ", true);
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        int state = 0;
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    result.add(current.toString());
                    current.setLength(0);
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            result.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new IllegalArgumentException("unbalanced quotes in " + str);
        }
        return result;
    }

    static String globToRegex(String pattern) {
        String DOT = "[^/]";
        StringBuilder sb = new StringBuilder(pattern.length());
        int inGroup = 0;
        int inClass = 0;
        int firstIndexInClass = -1;
        char[] arr = pattern.toCharArray();
        block16: for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            switch (ch) {
                case '\\': {
                    if (++i >= arr.length) {
                        sb.append('\\');
                        continue block16;
                    }
                    char next = arr[i];
                    switch (next) {
                        case ',': {
                            break;
                        }
                        case 'E': 
                        case 'Q': {
                            sb.append('\\');
                        }
                        default: {
                            sb.append('\\');
                        }
                    }
                    sb.append(next);
                    continue block16;
                }
                case '*': {
                    if (inClass == 0) {
                        sb.append("[^/]*");
                        continue block16;
                    }
                    sb.append('*');
                    continue block16;
                }
                case '?': {
                    if (inClass == 0) {
                        sb.append("[^/]");
                        continue block16;
                    }
                    sb.append('?');
                    continue block16;
                }
                case '[': {
                    ++inClass;
                    firstIndexInClass = i + 1;
                    sb.append('[');
                    continue block16;
                }
                case ']': {
                    --inClass;
                    sb.append(']');
                    continue block16;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    if (inClass == 0 || firstIndexInClass == i && ch == '^') {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    continue block16;
                }
                case '!': {
                    if (firstIndexInClass == i) {
                        sb.append('^');
                        continue block16;
                    }
                    sb.append('!');
                    continue block16;
                }
                case '{': {
                    ++inGroup;
                    sb.append('(');
                    continue block16;
                }
                case '}': {
                    --inGroup;
                    sb.append(')');
                    continue block16;
                }
                case ',': {
                    if (inGroup > 0) {
                        sb.append('|');
                        continue block16;
                    }
                    sb.append(',');
                    continue block16;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private static <T> List<T> nullToEmpty(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    private static <K, V> Map<K, V> nullToEmpty(Map<K, V> map) {
        return map != null ? map : Collections.emptyMap();
    }

    private static <T> List<T> emptyToNull(List<T> list) {
        return list != null && !list.isEmpty() ? list : null;
    }

    private static <K, V> Map<K, V> emptyToNull(Map<K, V> map) {
        return map != null && !map.isEmpty() ? map : null;
    }

    private static <K, V> Map<K, List<V>> multiput(Map<K, List<V>> map, K key, List<V> values) {
        if (values == null) {
            return map;
        }
        List<V> list = map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            map.put(key, list);
        }
        list.addAll(values);
        return map;
    }

    private static <K, V> Map<K, List<V>> multiputAll(Map<K, List<V>> map, Map<K, List<V>> map2) {
        for (Map.Entry<K, List<V>> entry : map2.entrySet()) {
            List<V> list = map.get(entry.getKey());
            if (list == null) {
                list = new ArrayList<V>();
                map.put(entry.getKey(), list);
            }
            list.addAll((Collection)entry.getValue());
        }
        return map;
    }

    private static boolean isEmpty(Iterable<?> c) {
        if (c instanceof Collection) {
            return ((Collection)c).isEmpty();
        }
        Iterator<?> it = c.iterator();
        return !it.hasNext();
    }

    private static boolean isDeepEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if ("".equals(o)) {
            return true;
        }
        if (o instanceof Path) {
            return false;
        }
        if (o instanceof Iterable) {
            for (Object x : (Iterable)o) {
                if (Capsule.isDeepEmpty(x)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static <T> T first(Iterable<T> c) {
        if (c == null || Capsule.isEmpty(c)) {
            throw new IllegalArgumentException("Not found");
        }
        return (T)(c instanceof List && c instanceof RandomAccess ? ((List)c).get(0) : c.iterator().next());
    }

    private static <T> T firstOrNull(Iterable<T> c) {
        if (c == null || Capsule.isEmpty(c)) {
            return null;
        }
        return (T)(c instanceof List && c instanceof RandomAccess ? ((List)c).get(0) : c.iterator().next());
    }

    private static <T> T only(List<T> c) {
        if (c == null || c.isEmpty()) {
            throw new IllegalArgumentException("Not found");
        }
        if (c.size() > 1) {
            throw new IllegalArgumentException("Expected a single element but found " + c.size() + ": " + c);
        }
        return c.get(0);
    }

    private static <C extends Collection<T>, T> C addAll(C c, Collection<T> c1) {
        if (c1 != null) {
            c.addAll(c1);
        }
        return c;
    }

    private static <C extends Collection<? super T>, T> C addAllIfAbsent(C c, Collection<T> c1) {
        if (c1 != null) {
            for (T e : c1) {
                if (c.contains(e)) continue;
                c.add(e);
            }
        }
        return c;
    }

    private static <M extends Map<K, V>, K, V> M putAllIfAbsent(M m, Map<K, V> m1) {
        for (Map.Entry<K, V> entry : m1.entrySet()) {
            if (m.containsKey(entry.getKey())) continue;
            m.put(entry.getKey(), entry.getValue());
        }
        return m;
    }

    private static <K, V> Map.Entry<K, V> entry(K k, V v) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(k, v);
    }

    private static <K, V> Map.Entry<K, V> mutableEntry(K k, V v) {
        return new AbstractMap.SimpleEntry<K, V>(k, v);
    }

    @SafeVarargs
    private static <T> Set<T> immutableSet(T ... elems) {
        return Collections.unmodifiableSet(new HashSet<T>(Arrays.asList(elems)));
    }

    private static boolean isEmpty(Object x) {
        if (x == null) {
            return true;
        }
        if (x instanceof String) {
            return ((String)x).isEmpty();
        }
        if (x instanceof Collection) {
            return ((Collection)x).isEmpty();
        }
        if (x instanceof Map) {
            return ((Map)x).isEmpty();
        }
        return false;
    }

    private static <T> T merge(T v1, T v2) {
        if (v2 == null) {
            return v1;
        }
        if (v1 instanceof Collection) {
            AbstractCollection cm;
            Collection c1 = (Collection)v1;
            Collection c2 = (Collection)v2;
            if (v1 instanceof List) {
                cm = new ArrayList(c1.size() + c2.size());
            } else if (v1 instanceof Set) {
                cm = new HashSet(c1.size() + c2.size());
            } else {
                throw new RuntimeException("Unhandled type: " + v1.getClass().getName());
            }
            cm.addAll(c1);
            Capsule.addAllIfAbsent(cm, c2);
            return (T)cm;
        }
        if (v1 instanceof Map) {
            HashMap mm = new HashMap();
            mm.putAll((Map)v1);
            mm.putAll((Map)v2);
            return (T)mm;
        }
        return v2;
    }

    private static Method getMethod(Capsule capsule, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Capsule c = capsule.cc;
        while (c != null) {
            try {
                return Capsule.getMethod(c.getClass(), name, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                c = c.sup;
            }
        }
        throw new NoSuchMethodException(name + "(" + Arrays.toString(parameterTypes) + ")");
    }

    private static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        try {
            return Capsule.accessible(clazz.getDeclaredMethod(name, parameterTypes));
        }
        catch (NoSuchMethodException e) {
            if (clazz.getSuperclass() == null) {
                throw new NoSuchMethodException(name + "(" + Arrays.toString(parameterTypes) + ")");
            }
            return Capsule.getMethod(clazz.getSuperclass(), name, parameterTypes);
        }
    }

    private static Method getMethod(Class<?> clazz, Method method) {
        if (clazz.equals(method.getDeclaringClass())) {
            return method;
        }
        try {
            return Capsule.getMethod(clazz, method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static <T extends AccessibleObject> T accessible(T obj) {
        if (obj == null) {
            return null;
        }
        obj.setAccessible(true);
        return obj;
    }

    private static ClassLoader newClassLoader0(ClassLoader parent, List<Path> ps) {
        try {
            ArrayList<URL> urls = new ArrayList<URL>(ps.size());
            for (Path p : ps) {
                urls.add(p.toUri().toURL());
            }
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static ClassLoader newClassLoader0(ClassLoader parent, Path ... ps) {
        return Capsule.newClassLoader0(parent, Arrays.asList(ps));
    }

    ClassLoader newClassLoader(ClassLoader parent, List<Path> ps) {
        return Capsule.newClassLoader0(parent, ps);
    }

    private ClassLoader newClassLoader(ClassLoader parent, Path ... ps) {
        return this.newClassLoader(parent, Arrays.asList(ps));
    }

    private static boolean isStream(String className) {
        return className.startsWith("java.util.stream") || className.contains("$$Lambda") || className.contains("Spliterator");
    }

    private static boolean isThrows(Method method, Throwable t) {
        for (Class<?> etype : method.getExceptionTypes()) {
            if (!etype.isInstance(t)) continue;
            return true;
        }
        return false;
    }

    private static String propertyOrEnv(String propName, String envVar) {
        String val = Capsule.getProperty(propName);
        if (val == null) {
            val = Capsule.emptyToNull(Capsule.getenv(envVar));
        }
        return val;
    }

    protected static final String getProperty(String propName) {
        String val = Capsule.getProperty0(propName);
        Capsule.setContext("system property", propName, val);
        return val;
    }

    private static String getProperty0(String propName) {
        return propName != null ? PROPERTIES.getProperty(propName) : null;
    }

    protected static final void setProperty(String propName, String value) {
        PROPERTIES.setProperty(propName, value);
    }

    protected static String getenv(String envName) {
        String val = envName != null ? System.getenv(envName) : null;
        Capsule.setContext("environment variable", envName, val);
        return val;
    }

    private static boolean systemPropertyEmptyOrTrue(String property) {
        return Capsule.emptyOrTrue(Capsule.getProperty0(property));
    }

    private static boolean emptyOrTrue(String value) {
        if (value == null) {
            return false;
        }
        return value.isEmpty() || Boolean.parseBoolean(value);
    }

    private static boolean systemPropertyEmptyOrNotFalse(String property) {
        String value = Capsule.getProperty0(property);
        if (value == null) {
            return false;
        }
        return value.isEmpty() || !"false".equalsIgnoreCase(value);
    }

    private static Throwable deshadow(Throwable t) {
        return Capsule.deshadow(CACHE_DEFAULT_NAME, t);
    }

    private static Throwable deshadow(String prefix, Throwable t) {
        prefix = prefix.endsWith(".") ? prefix : prefix + ".";
        StackTraceElement[] st = t.getStackTrace();
        for (int i = 0; i < st.length; ++i) {
            String className = st[i].getClassName();
            className = className != null && className.startsWith(prefix) && className.lastIndexOf(46) > prefix.length() ? className.substring(prefix.length()) : className;
            st[i] = new StackTraceElement(className, st[i].getMethodName(), st[i].getFileName(), st[i].getLineNumber());
        }
        t.setStackTrace(st);
        if (t.getCause() != null) {
            Capsule.deshadow(prefix, t.getCause());
        }
        return t;
    }

    private static RuntimeException rethrow(Throwable t) {
        while (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getTargetException();
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    private static void close(Object c) {
        try {
            ((AutoCloseable)c).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isAlive(Process p) {
        try {
            p.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    private static boolean waitFor(Process p, long millis) throws InterruptedException {
        long deadline = System.nanoTime() + millis * 1000000L;
        while (Capsule.isAlive(p)) {
            long sleep = Math.min((deadline - System.nanoTime()) / 1000000L, 20L);
            if (sleep <= 0L) {
                return false;
            }
            Thread.sleep(sleep);
        }
        return true;
    }

    protected static Iterable<String> exec(String ... cmd) throws IOException {
        return Capsule.exec(-1, cmd);
    }

    protected static Iterable<String> exec(int numLines, String ... cmd) throws IOException {
        return Capsule.exec(numLines, new ProcessBuilder(Arrays.asList(cmd)));
    }

    protected static Iterable<String> exec(ProcessBuilder pb) throws IOException {
        return Capsule.exec(-1, pb);
    }

    protected static Iterable<String> exec(int numLines, ProcessBuilder pb) throws IOException {
        return Capsule.exec(numLines, false, pb);
    }

    private static Iterable<String> exec(int numLines, boolean error, ProcessBuilder pb) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        Process p = pb.start();
        InputStream in = error ? p.getErrorStream() : p.getInputStream();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, Charset.defaultCharset()));){
            for (int i = 0; numLines < 0 || i < numLines; ++i) {
                String line = reader.readLine();
                if (line == null) {
                    break;
                }
                lines.add(line);
            }
        }
        try {
            int exitValue;
            if ((numLines < 0 || lines.size() < numLines) && (exitValue = p.waitFor()) != 0) {
                throw new RuntimeException("Command '" + Capsule.join(pb.command(), " ") + "' has returned " + exitValue);
            }
            return lines;
        }
        catch (InterruptedException e) {
            throw Capsule.rethrow(e);
        }
    }

    private static void setLogLevel(int level) {
        LOG_LEVEL = level;
    }

    protected static final int getLogLevel() {
        Integer level = LOG_LEVEL;
        return level != null ? level : 0;
    }

    protected int chooseLogLevel() {
        this._ct = this.getCallTarget(Capsule.class);
        return this._ct != null ? this._ct.chooseLogLevel() : this.chooseLogLevel0();
    }

    private int chooseLogLevel0() {
        String level = Capsule.getProperty(PROP_LOG_LEVEL);
        if (level == null && this.oc.manifest != null) {
            level = this.getAttribute(ATTR_LOG_LEVEL);
        }
        return Capsule.getLogLevel(level);
    }

    private static int getLogLevel(String level) {
        try {
            int l = Integer.parseInt(level);
            if (l < 0) {
                throw new IllegalArgumentException("Unrecognized log level: " + level);
            }
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            if (level == null || level.isEmpty()) {
                level = "QUIET";
            }
            switch (level.toUpperCase()) {
                case "NONE": {
                    return 0;
                }
                case "QUIET": {
                    return 1;
                }
                case "VERBOSE": {
                    return 2;
                }
                case "DEBUG": 
                case "ALL": {
                    return 3;
                }
            }
            throw new IllegalArgumentException("Unrecognized log level: " + level);
        }
    }

    protected static final boolean isLogging(int level) {
        return level <= Capsule.getLogLevel();
    }

    protected static final void log(int level, String str) {
        if (Capsule.isLogging(level)) {
            STDERR.println((AGENT ? LOG_AGENT_PREFIX : LOG_PREFIX) + str);
        }
    }

    protected static final void log(int level, Throwable t) {
        if (t != null && Capsule.isLogging(level)) {
            t.printStackTrace(STDERR);
        }
    }

    private static void println(String str) {
        Capsule.log(1, str);
    }

    private static boolean hasContext() {
        return contextType_ != null;
    }

    private static void clearContext() {
        Capsule.setContext(null, null, null);
    }

    private static void setContext(String type, String key, Object value) {
        if (contextType_ == null) {
            return;
        }
        contextType_.set(type);
        contextKey_.set(key);
        contextValue_.set(value != null ? value.toString() : null);
    }

    private static String getContext() {
        return contextType_.get() + " " + contextKey_.get() + ": " + contextValue_.get();
    }

    private static long clock() {
        return Capsule.isLogging(PROFILE) ? System.nanoTime() : 0L;
    }

    private static void time(String op, long start) {
        Capsule.time(op, start, Capsule.isLogging(PROFILE) ? System.nanoTime() : 0L);
    }

    private static void time(String op, long start, long stop) {
        if (Capsule.isLogging(PROFILE)) {
            Capsule.log(PROFILE, "PROFILE " + op + " " + (stop - start) / 1000000L + "ms");
        }
    }

    protected void onError(Throwable t) {
        this._ct = this.getCallTarget(Capsule.class);
        if (this._ct != null) {
            this._ct.onError(t);
        } else {
            this.onError0(t);
        }
    }

    private void onError0(Throwable t) {
        Capsule.printError(t, this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static <T> T trace(String label, T x) {
        String s;
        if (x == null) {
            s = "null";
        } else if (x.getClass().isArray()) {
            if (!x.getClass().getComponentType().isPrimitive()) {
                s = Arrays.deepToString((Object[])x);
            } else if (x.getClass().getComponentType().equals(Boolean.TYPE)) {
                s = Arrays.toString((boolean[])x);
            } else if (x.getClass().getComponentType().equals(Character.TYPE)) {
                s = Arrays.toString((char[])x);
            } else if (x.getClass().getComponentType().equals(Byte.TYPE)) {
                s = Arrays.toString((byte[])x);
            } else if (x.getClass().getComponentType().equals(Short.TYPE)) {
                s = Arrays.toString((short[])x);
            } else if (x.getClass().getComponentType().equals(Integer.TYPE)) {
                s = Arrays.toString((int[])x);
            } else if (x.getClass().getComponentType().equals(Long.TYPE)) {
                s = Arrays.toString((long[])x);
            } else if (x.getClass().getComponentType().equals(Float.TYPE)) {
                s = Arrays.toString((float[])x);
            } else {
                if (!x.getClass().getComponentType().equals(Double.TYPE)) throw new AssertionError();
                s = Arrays.toString((double[])x);
            }
        } else {
            s = x.toString();
        }
        System.err.println("TRACE " + label + ": " + s);
        return x;
    }

    private <T> T windowsAttributes(Map.Entry<String, T> attr, T value) {
        if (!Capsule.isWindows()) {
            return value;
        }
        if (ATTR_AGENT == attr) {
            return (T)Boolean.TRUE;
        }
        return value;
    }

    private List<Path> handleLongClasspath(List<Path> cp, int extra, List<?> ... args) {
        if (!Capsule.isWindows()) {
            return cp;
        }
        long len = (long)extra + Capsule.getStringsLength(cp) + (long)cp.size();
        for (List<?> list : args) {
            len += Capsule.getStringsLength(list) + (long)list.size();
        }
        if (len >= Capsule.getMaxCommandLineLength()) {
            Capsule.log(3, "Command line length: " + len);
            if (Capsule.isTrampoline()) {
                throw new RuntimeException("Command line too long and trampoline requested.");
            }
            Path pathingJar = this.addTempFile(Capsule.createPathingJar(Capsule.getTempDir(), cp));
            Capsule.log(2, "Writing classpath: " + cp + " to pathing JAR: " + pathingJar);
            return Collections.singletonList(pathingJar);
        }
        return cp;
    }

    static Path createPathingJar(Path dir, List<Path> cp) {
        try {
            dir = dir.toAbsolutePath();
            List<String> paths = Capsule.createPathingClassPath(dir, cp);
            Path pathingJar = Files.createTempFile(dir, "capsule_pathing_jar", ".jar", new FileAttribute[0]);
            Manifest man = new Manifest();
            man.getMainAttributes().putValue(ATTR_MANIFEST_VERSION, VERSION);
            man.getMainAttributes().putValue(ATTR_CLASS_PATH, Capsule.join(paths, " "));
            new JarOutputStream(Files.newOutputStream(pathingJar, new OpenOption[0]), man).close();
            return pathingJar;
        }
        catch (IOException e) {
            throw new RuntimeException("Pathing JAR creation failed", e);
        }
    }

    private static List<String> createPathingClassPath(Path dir, List<Path> cp) {
        boolean allPathsHaveSameRoot = true;
        for (Path p : cp) {
            if (dir.getRoot().equals(p.getRoot())) continue;
            allPathsHaveSameRoot = false;
        }
        ArrayList<String> paths = new ArrayList<String>(cp.size());
        for (Path p : cp) {
            if (allPathsHaveSameRoot) {
                paths.add(dir.relativize(p).toString());
                continue;
            }
            paths.add(p.toUri().toString());
        }
        return paths;
    }

    private static boolean isInheritIoBug() {
        return Capsule.isWindows() && Capsule.compareVersions(System.getProperty(PROP_JAVA_VERSION), "1.8.0") < 0;
    }

    private void pipeIoStreams() {
        this.startThread("pipe-out", "pipeStreamOut");
        this.startThread("pipe-err", "pipeStreamErr");
        this.startThread("pipe-in", "pipeStreamIn");
    }

    private void pipeStreamOut() throws IOException {
        this.pipe(this.child.getInputStream(), STDOUT);
    }

    private void pipeStreamErr() throws IOException {
        this.pipe(this.child.getErrorStream(), STDERR);
    }

    private void pipeStreamIn() throws IOException {
        this.pipe(System.in, this.child.getOutputStream());
    }

    private void pipe(InputStream in, OutputStream out) throws IOException {
        try (OutputStream out1 = out;){
            int read;
            byte[] buf = new byte[1024];
            while (-1 != (read = in.read(buf))) {
                out.write(buf, 0, read);
                out.flush();
            }
        }
    }

    private static int getPid(Process p) {
        try {
            Field pidField = p.getClass().getDeclaredField("pid");
            pidField.setAccessible(true);
            return pidField.getInt(p);
        }
        catch (Exception e) {
            return -1;
        }
    }

    protected JMXServiceURL startJMXServer() {
        String LOCAL_CONNECTOR_ADDRESS_PROP = "com.sun.management.jmxremote.localConnectorAddress";
        try {
            Capsule.log(2, "Starting JMXConnectorServer");
            Properties agentProps = VMSupport.getAgentProperties();
            if (agentProps.get("com.sun.management.jmxremote.localConnectorAddress") == null) {
                Capsule.log(2, "Starting management agent");
                Agent.agentmain(null);
            }
            JMXServiceURL url = new JMXServiceURL((String)agentProps.get("com.sun.management.jmxremote.localConnectorAddress"));
            Capsule.log(2, "JMXConnectorServer started JMX at " + url);
            return url;
        }
        catch (Exception e) {
            Capsule.log(2, "JMXConnectorServer failed: " + e.getMessage());
            Capsule.log(2, e);
            return null;
        }
    }

    private MBeanServerConnection connectToJMX(JMXServiceURL url) {
        try {
            Capsule.log(2, "Connecting to JMX server at: " + url);
            JMXConnector connect = JMXConnectorFactory.connect(url);
            MBeanServerConnection mbsc = connect.getMBeanServerConnection();
            Capsule.log(2, "JMX Connection successful");
            this.oc.jmxConnection = mbsc;
            return mbsc;
        }
        catch (Exception e) {
            Capsule.log(2, "JMX Connection failed: " + e.getMessage());
            Capsule.log(2, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final MBeanServerConnection getMBeanServerConnection() {
        Capsule.verifyAgent(false);
        this.verifyAfterStage(1);
        Capsule capsule = this.oc;
        synchronized (capsule) {
            if (this.oc.jmxConnection == null) {
                try {
                    this.send(2, null);
                    this.receive();
                }
                catch (IOException e) {
                    Capsule.printError(1, e);
                }
            }
            return this.oc.jmxConnection;
        }
    }

    private Object invokeMBeanServer(Method method, Object[] args) throws ReflectiveOperationException {
        MBeanServerConnection conn = this.lifecycleStage >= 1 ? this.getMBeanServerConnection() : null;
        MBeanServerConnection target = conn != null ? conn : this.origMBeanServer;
        Method m = Capsule.getMethod(target.getClass(), method);
        if (m != null) {
            return m.invoke((Object)target, args);
        }
        if (method.getName().startsWith("getClassLoader")) {
            return MY_CLASSLOADER;
        }
        throw new UnsupportedOperationException();
    }

    private void overridePlatformMBeanServer() {
        try {
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            if (platformMBeanServer instanceof JmxMBeanServer) {
                Field interceptorField = Capsule.accessible(JmxMBeanServer.class.getDeclaredField("mbsInterceptor"));
                this.origMBeanServer = (MBeanServer)interceptorField.get(platformMBeanServer);
                MBeanServer interceptor = (MBeanServer)Proxy.newProxyInstance(MY_CLASSLOADER, new Class[]{MBeanServer.class}, (InvocationHandler)this);
                interceptorField.set(platformMBeanServer, interceptor);
            }
        }
        catch (ReflectiveOperationException e) {
            throw Capsule.rethrow(e);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (!MBeanServerConnection.class.equals(method.getDeclaringClass()) && !MBeanServer.class.equals(method.getDeclaringClass())) {
                throw new UnsupportedOperationException();
            }
            Object res = this.invokeMBeanServer(method, args);
            if (Capsule.isLogging(3)) {
                Capsule.log(3, "Invoke " + method + " with args: " + Arrays.toString(args) + " => " + res);
            }
            return res;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            assert (t instanceof RuntimeException || t instanceof Error || Capsule.isThrows(method, t));
            Capsule.log(3, "Exception while running method " + method + " with args: " + Arrays.toString(args) + ": " + t);
            Capsule.log(3, t);
            throw e;
        }
        catch (Exception e) {
            Capsule.log(2, "Exception while running method " + method + " with args: " + Arrays.toString(args) + ": " + e);
            Capsule.log(2, e);
            throw e;
        }
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        if (Capsule.isLogging(3)) {
            sb.append('@').append(Integer.toHexString(System.identityHashCode(this)));
        }
        if (this.cc != this.oc) {
            sb.append('(');
            Capsule c = this.cc;
            while (c != null) {
                sb.append(c.getClass().getName());
                if (Capsule.isLogging(3)) {
                    sb.append('@').append(Integer.toHexString(System.identityHashCode(c)));
                }
                sb.append(" ");
                c = c.sup;
            }
            sb.delete(sb.length() - 1, sb.length());
            sb.append(')');
        }
        sb.append('[');
        sb.append(this.jarFile);
        if (this.getAppId() != null) {
            sb.append(", ").append(this.getAppId());
            sb.append(", ").append(this.getAttribute(ATTR_APP_CLASS) != null ? this.getAttribute(ATTR_APP_CLASS) : this.getAttribute(ATTR_APP_ARTIFACT));
        } else {
            sb.append(", ").append("empty");
        }
        if (this.getMode() != null) {
            sb.append(", ").append("mode: ").append(this.getMode());
        }
        sb.append(']');
        return sb.toString();
    }

    protected Capsule loadTargetCapsule(ClassLoader parent, Path jarFile) {
        this._ct = this.getCallTarget(Capsule.class);
        return this._ct != null ? this._ct.loadTargetCapsule(parent, jarFile) : this.loadTargetCapsule0(parent, jarFile);
    }

    private Capsule loadTargetCapsule0(ClassLoader parent, Path jar) {
        return Capsule.newCapsule(this.newClassLoader(parent, jar), jar);
    }

    static Capsule newCapsule(ClassLoader cl, Path jarFile) {
        return (Capsule)Capsule.newCapsule0(cl, jarFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object newCapsule0(ClassLoader cl, Path jarFile) {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            Capsule capsule = Capsule.accessible(Capsule.loadCapsule(cl, jarFile).getDeclaredConstructor(Path.class)).newInstance(jarFile);
            Thread.currentThread().setContextClassLoader(ccl);
            return capsule;
        }
        catch (Throwable throwable) {
            try {
                Thread.currentThread().setContextClassLoader(ccl);
                throw throwable;
            }
            catch (IncompatibleClassChangeError e) {
                throw new RuntimeException("Caplet " + jarFile + " is not compatible with this capsule (" + VERSION + ")");
            }
            catch (InvocationTargetException e) {
                throw Capsule.rethrow(e.getTargetException());
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Could not instantiate capsule.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Capsule newCapsule(Path jarFile, Capsule pred) {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl = this.newClassLoader(pred.getClass().getClassLoader(), jarFile);
            Thread.currentThread().setContextClassLoader(cl);
            Capsule capsule = Capsule.accessible(Capsule.loadCapsule(cl, jarFile).getDeclaredConstructor(Path.class)).newInstance(jarFile);
            Thread.currentThread().setContextClassLoader(ccl);
            return capsule;
        }
        catch (Throwable throwable) {
            try {
                Thread.currentThread().setContextClassLoader(ccl);
                throw throwable;
            }
            catch (IncompatibleClassChangeError e) {
                throw new RuntimeException("Caplet " + jarFile + " is not compatible with this capsule (" + VERSION + ")");
            }
            catch (InvocationTargetException e) {
                throw Capsule.rethrow(e.getTargetException());
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Could not instantiate capsule.", e);
            }
        }
    }

    private static Capsule newCapsule(String capsuleClass, Capsule pred) {
        try {
            Class<? extends Capsule> clazz = Capsule.loadCapsule(Thread.currentThread().getContextClassLoader(), capsuleClass, capsuleClass);
            assert (Capsule.getActualCapsuleClass(clazz) == Capsule.class);
            return Capsule.accessible(clazz.getDeclaredConstructor(Capsule.class)).newInstance(pred);
        }
        catch (IncompatibleClassChangeError e) {
            throw new RuntimeException("Caplet " + capsuleClass + " is not compatible with this capsule (" + VERSION + ")");
        }
        catch (InvocationTargetException e) {
            throw Capsule.rethrow(e.getTargetException());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not instantiate capsule " + capsuleClass, e);
        }
    }

    private static Class<? extends Capsule> loadCapsule(ClassLoader cl, Path jarFile) {
        String mainClassName = Capsule.getMainClass(jarFile);
        if (mainClassName != null) {
            return Capsule.loadCapsule(cl, mainClassName, jarFile.toString());
        }
        throw new RuntimeException(jarFile + " does not appear to be a valid capsule.");
    }

    private static Class<? extends Capsule> loadCapsule(ClassLoader cl, String capsuleClass, String name) {
        try {
            Capsule.log(3, "Loading capsule class " + capsuleClass + " using class loader " + Capsule.toString(cl));
            Class<?> clazz = cl.loadClass(capsuleClass);
            Class<Capsule> c = Capsule.getActualCapsuleClass(clazz);
            if (c == null) {
                throw new RuntimeException(name + " does not appear to be a valid capsule.");
            }
            if (c != Capsule.class) {
                Capsule.accessible(c.getDeclaredField("PROPERTIES")).set(null, new Properties(PROPERTIES));
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Caplet " + capsuleClass + " not found.", e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(name + " does not appear to be a valid capsule.");
        }
        catch (ClassCastException | IncompatibleClassChangeError e) {
            throw new RuntimeException("Caplet " + capsuleClass + " is not compatible with this capsule (" + VERSION + ")");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<Capsule> getActualCapsuleClass(Class<?> clazz) {
        Class<Capsule> c;
        for (c = clazz; c != null && !Capsule.class.getName().equals(c.getName()); c = c.getSuperclass()) {
        }
        return c;
    }

    private static String getCapsuleVersion(Class<?> cls) {
        while (cls != null && !cls.getName().equals(Capsule.class.getName())) {
            cls = cls.getSuperclass();
        }
        if (cls == null) {
            return null;
        }
        try {
            Field f = cls.getDeclaredField("VERSION");
            return (String)f.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String toString(ClassLoader cl) {
        return cl == null ? "null" : cl.toString() + (cl instanceof URLClassLoader ? "{" + Arrays.toString(((URLClassLoader)cl).getURLs()) + "}" : "") + " --> " + Capsule.toString(cl.getParent());
    }

    private Capsule unsafe(Capsule target) {
        SecurityManager security;
        if (target != null && (security = System.getSecurityManager()) != null && !target.getClass().getProtectionDomain().implies(PERM_UNSAFE_OVERRIDE)) {
            Capsule.log(3, "Unsafe target " + target + " skipped");
            target = null;
        }
        return target;
    }

    static {
        contextType_ = new ThreadLocal();
        contextKey_ = new ThreadLocal();
        contextValue_ = new ThreadLocal();
        PAT_JAVA_SPECIFIC_SECTION = Pattern.compile("\\A(.+-|)java-[0-9]+\\z");
        EMPTY_ATTRIBUTES = new Attributes();
        PAT_DEPENDENCY = Pattern.compile("(?<groupId>[^:\\(]+):(?<artifactId>[^:\\(]+)(:(?<version>\\(?[^:\\(]*))?(:(?<classifier>[^:\\(]+))?(\\((?<exclusions>[^\\(\\)]*)\\))?");
        jarEntriesCache = new HashMap<Path, List<String>>();
        ZIP_HEADER = new int[]{80, 75, 3, 4};
        PAT_JAVA_VERSION_LINE = Pattern.compile(".*?\"(.+?)\"");
        PAT_JAVA_VERSION = Pattern.compile("(?<major>\\d+)(\\.(?<minor>\\d+))?(?:\\.(?<patch>\\d+))?(_(?<update>\\d+))?(-(?<pre>[^-]+))?(-(?<build>.+))?");
        PAT_VAR = Pattern.compile("\\$(?:([a-zA-Z0-9_\\-]+)|(?:\\{([^\\}]*)\\}))");
    }
}

