/*
 * Decompiled with CFR 0.152.
 */
package net.corda.common.logging;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.common.logging.ExceptionsErrorCodeFunctionsKt;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.Message;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Plugin(name="ErrorCodeRewritePolicy", category="Core", elementType="rewritePolicy", printObject=false)
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lnet/corda/common/logging/ErrorCodeRewritePolicy;", "Lorg/apache/logging/log4j/core/appender/rewrite/RewritePolicy;", "()V", "rewrite", "Lorg/apache/logging/log4j/core/LogEvent;", "source", "Companion", "common-logging"})
public final class ErrorCodeRewritePolicy
implements RewritePolicy {
    public static final Companion Companion = new Companion(null);

    @Nullable
    public LogEvent rewrite(@NotNull LogEvent source) {
        Message message;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Message message2 = source.getMessage();
        if (message2 != null) {
            Throwable throwable = source.getThrown();
            Level level = source.getLevel();
            Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"source.level");
            message = ExceptionsErrorCodeFunctionsKt.withErrorCodeFor(message2, throwable, level);
        } else {
            message = null;
        }
        Message newMessage = message;
        return Intrinsics.areEqual(newMessage, (Object)source.getMessage()) ? source : (LogEvent)new Log4jLogEvent.Builder(source).setMessage(newMessage).build();
    }

    @JvmStatic
    @PluginFactory
    @NotNull
    public static final ErrorCodeRewritePolicy createPolicy() {
        return Companion.createPolicy();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lnet/corda/common/logging/ErrorCodeRewritePolicy$Companion;", "", "()V", "createPolicy", "Lnet/corda/common/logging/ErrorCodeRewritePolicy;", "common-logging"})
    public static final class Companion {
        @JvmStatic
        @PluginFactory
        @NotNull
        public final ErrorCodeRewritePolicy createPolicy() {
            return new ErrorCodeRewritePolicy();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

